/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import java.util.HashMap;
import java.util.Map;

public enum Http2ErrorCode {
    NO_ERROR(0),
    PROTOCOL(1),
    INTERNAL(2),
    FLOW_CONTROL(3),
    SETTINGS_TIMEOUT(4),
    STREAM_CLOSED(5),
    FRAME_SIZE(6),
    REFUSED_STREAM(7),
    CANCEL(8),
    COMPRESSION(9),
    CONNECT(10),
    ENHANCE_YOUR_CALM(11),
    INADEQUATE_SECURITY(12),
    HTTP_1_1_REQUIRED(13),
    REQUEST_HEADER_FIELDS_TOO_LARGE(431);

    private static final Map<Integer, Http2ErrorCode> BY_CODE;
    private final int code;

    private Http2ErrorCode(int code) {
        this.code = code;
    }

    public static Http2ErrorCode get(int errorCode) {
        Http2ErrorCode code = BY_CODE.get(errorCode);
        if (code == null) {
            return INTERNAL;
        }
        return code;
    }

    public int code() {
        return this.code;
    }

    static {
        HashMap<Integer, Http2ErrorCode> map = new HashMap<Integer, Http2ErrorCode>();
        for (Http2ErrorCode value : Http2ErrorCode.values()) {
            map.put(value.code, value);
        }
        BY_CODE = Map.copyOf(map);
    }
}

