/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.http.http2.Http2ErrorCode;
import io.helidon.http.http2.Http2Exception;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2FrameType;
import io.helidon.http.http2.Http2FrameTypes;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;

final class Http2FrameTypeUtil {
    private static final Map<Http2FrameType, Http2FrameTypes<? extends Http2Flag>> TYPES_BY_TYPE;

    private Http2FrameTypeUtil() {
    }

    static Http2FrameTypes<? extends Http2Flag> get(Http2FrameType frameType) {
        Http2FrameTypes<? extends Http2Flag> found = TYPES_BY_TYPE.get((Object)frameType);
        if (found == null) {
            throw new Http2Exception(Http2ErrorCode.INTERNAL, "Invalid frame type: " + String.valueOf((Object)frameType));
        }
        return found;
    }

    private static void add(Map<Http2FrameType, Http2FrameTypes<? extends Http2Flag>> byId, Http2FrameTypes<? extends Http2Flag> data) {
        byId.put(data.type(), data);
    }

    static {
        EnumMap<Http2FrameType, Http2FrameTypes<? extends Http2Flag>> typesByType = new EnumMap<Http2FrameType, Http2FrameTypes<? extends Http2Flag>>(Http2FrameType.class);
        Http2FrameTypeUtil.add(typesByType, Http2FrameTypes.DATA);
        Http2FrameTypeUtil.add(typesByType, Http2FrameTypes.HEADERS);
        Http2FrameTypeUtil.add(typesByType, Http2FrameTypes.PRIORITY);
        Http2FrameTypeUtil.add(typesByType, Http2FrameTypes.RST_STREAM);
        Http2FrameTypeUtil.add(typesByType, Http2FrameTypes.SETTINGS);
        Http2FrameTypeUtil.add(typesByType, Http2FrameTypes.PUSH_PROMISE);
        Http2FrameTypeUtil.add(typesByType, Http2FrameTypes.PING);
        Http2FrameTypeUtil.add(typesByType, Http2FrameTypes.GO_AWAY);
        Http2FrameTypeUtil.add(typesByType, Http2FrameTypes.WINDOW_UPDATE);
        Http2FrameTypeUtil.add(typesByType, Http2FrameTypes.CONTINUATION);
        Http2FrameTypeUtil.add(typesByType, Http2FrameTypes.UNKNOWN);
        TYPES_BY_TYPE = typesByType;
    }

    static class FrameTypeImpl<T extends Http2Flag>
    implements Http2FrameTypes<T> {
        private final Http2FrameType type;
        private final Function<Integer, T> flagsFunction;

        FrameTypeImpl(Http2FrameType type, Function<Integer, T> flagsFunction) {
            this.type = type;
            this.flagsFunction = flagsFunction;
        }

        @Override
        public Http2FrameType type() {
            return this.type;
        }

        @Override
        public T flags(int flags) {
            return (T)((Http2Flag)this.flagsFunction.apply(flags));
        }
    }
}

