/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.Headers;
import io.helidon.http.Http;
import io.helidon.http.HttpMediaType;
import io.helidon.http.WritableHeaders;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

class ClientRequestHeadersImpl
implements ClientRequestHeaders {
    private final WritableHeaders<?> delegate;
    private List<HttpMediaType> mediaTypes;

    ClientRequestHeadersImpl(WritableHeaders<?> delegate) {
        this.delegate = delegate;
    }

    @Override
    public List<String> all(Http.HeaderName name, Supplier<List<String>> defaultSupplier) {
        return this.delegate.all(name, defaultSupplier);
    }

    @Override
    public boolean contains(Http.HeaderName name) {
        return this.delegate.contains(name);
    }

    @Override
    public boolean contains(Http.Header headerWithValue) {
        return this.delegate.contains(headerWithValue);
    }

    @Override
    public Http.Header get(Http.HeaderName name) {
        return this.delegate.get(name);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public List<HttpMediaType> acceptedTypes() {
        if (this.mediaTypes == null) {
            if (this.delegate.contains(Http.HeaderNames.ACCEPT)) {
                List<String> accepts = this.delegate.get(Http.HeaderNames.ACCEPT).allValues(true);
                ArrayList<HttpMediaType> mediaTypes = new ArrayList<HttpMediaType>(accepts.size());
                for (String accept : accepts) {
                    mediaTypes.add(HttpMediaType.create(accept));
                }
                Collections.sort(mediaTypes);
                this.mediaTypes = List.copyOf(mediaTypes);
            } else {
                this.mediaTypes = List.of();
            }
        }
        return this.mediaTypes;
    }

    @Override
    public ClientRequestHeaders setIfAbsent(Http.Header header) {
        this.delegate.setIfAbsent(header);
        return this;
    }

    @Override
    public ClientRequestHeaders add(Http.Header header) {
        this.delegate.add(header);
        return this;
    }

    @Override
    public ClientRequestHeaders remove(Http.HeaderName name) {
        this.delegate.remove(name);
        return this;
    }

    @Override
    public ClientRequestHeaders remove(Http.HeaderName name, Consumer<Http.Header> removedConsumer) {
        this.delegate.remove(name, removedConsumer);
        return this;
    }

    @Override
    public ClientRequestHeaders set(Http.Header header) {
        this.delegate.set(header);
        return this;
    }

    @Override
    public Iterator<Http.Header> iterator() {
        return this.delegate.iterator();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public ClientRequestHeaders clear() {
        this.delegate.clear();
        return this;
    }

    @Override
    public ClientRequestHeaders from(Headers headers) {
        headers.forEach(this::set);
        return this;
    }
}

