/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.media.type.ParserMode;
import io.helidon.http.ClientResponseHeaders;
import io.helidon.http.HeaderNameEnum;
import io.helidon.http.Headers;
import io.helidon.http.Http;
import io.helidon.http.HttpMediaType;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

class ClientResponseHeadersImpl
implements ClientResponseHeaders {
    private final Headers headers;
    private final ParserMode parserMode;

    ClientResponseHeadersImpl(Headers headers, ParserMode parserMode) {
        this.headers = headers;
        this.parserMode = parserMode;
    }

    @Override
    public List<String> all(Http.HeaderName name, Supplier<List<String>> defaultSupplier) {
        return this.headers.all(name, defaultSupplier);
    }

    @Override
    public boolean contains(Http.HeaderName name) {
        return this.headers.contains(name);
    }

    @Override
    public boolean contains(Http.Header headerWithValue) {
        return this.headers.contains(headerWithValue);
    }

    @Override
    public Http.Header get(Http.HeaderName name) {
        return this.headers.get(name);
    }

    @Override
    public Optional<HttpMediaType> contentType() {
        if (this.parserMode == ParserMode.RELAXED) {
            return this.contains(HeaderNameEnum.CONTENT_TYPE) ? Optional.of(HttpMediaType.create(this.get(HeaderNameEnum.CONTENT_TYPE).value(), this.parserMode)) : Optional.empty();
        }
        return this.headers.contentType();
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public Iterator<Http.Header> iterator() {
        return this.headers.iterator();
    }

    @Override
    public List<HttpMediaType> acceptedTypes() {
        return this.headers.acceptedTypes();
    }

    public String toString() {
        return this.headers.toString();
    }
}

