/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.HeaderValueBase;
import io.helidon.http.Http;
import java.nio.charset.StandardCharsets;
import java.util.List;

class HeaderValueCached
extends HeaderValueBase {
    private final byte[] cached;
    private final String value;
    private final byte[] cachedHttp1Header;

    HeaderValueCached(Http.HeaderName name, boolean changing, boolean sensitive, byte[] cached, String value) {
        super(name, changing, sensitive, value);
        this.value = value;
        this.cached = cached;
        byte[] nameBytes = name.defaultCase().getBytes(StandardCharsets.US_ASCII);
        this.cachedHttp1Header = new byte[nameBytes.length + cached.length + 4];
        int pos = nameBytes.length;
        System.arraycopy(nameBytes, 0, this.cachedHttp1Header, 0, pos);
        this.cachedHttp1Header[pos++] = 58;
        this.cachedHttp1Header[pos++] = 32;
        System.arraycopy(cached, 0, this.cachedHttp1Header, pos, cached.length);
        pos += cached.length;
        this.cachedHttp1Header[pos++] = 13;
        this.cachedHttp1Header[pos] = 10;
    }

    @Override
    public byte[] valueBytes() {
        return this.cached;
    }

    @Override
    public void writeHttp1Header(BufferData buffer) {
        buffer.write(this.cachedHttp1Header);
    }

    @Override
    public Http.HeaderValueWriteable addValue(String value) {
        throw new UnsupportedOperationException("Cannot change values of a cached header " + this.name());
    }

    @Override
    public List<String> allValues() {
        return List.of(this.value);
    }

    @Override
    public int valueCount() {
        return 1;
    }
}

