/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.media.type.MediaType;
import io.helidon.http.HeaderNameEnum;
import io.helidon.http.Http;
import io.helidon.http.HttpMediaType;
import io.helidon.http.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Headers
extends Iterable<Http.Header> {
    public List<String> all(Http.HeaderName var1, Supplier<List<String>> var2);

    public boolean contains(Http.HeaderName var1);

    public boolean contains(Http.Header var1);

    public Http.Header get(Http.HeaderName var1);

    default public Optional<String> value(Http.HeaderName headerName) {
        if (this.contains(headerName)) {
            List<String> hdrs = this.all(headerName, List::of);
            return Optional.of(String.join((CharSequence)",", hdrs));
        }
        return Optional.empty();
    }

    default public Optional<String> first(Http.HeaderName headerName) {
        if (this.contains(headerName)) {
            return Optional.of((String)this.get(headerName).get());
        }
        return Optional.empty();
    }

    default public List<String> values(Http.HeaderName headerName) {
        return this.all(headerName, List::of).stream().flatMap(val -> Utils.tokenize(',', "\"", true, val).stream()).collect(Collectors.toList());
    }

    default public OptionalLong contentLength() {
        if (this.contains(HeaderNameEnum.CONTENT_LENGTH)) {
            return OptionalLong.of((Long)this.get(HeaderNameEnum.CONTENT_LENGTH).get(Long.TYPE));
        }
        return OptionalLong.empty();
    }

    default public Optional<HttpMediaType> contentType() {
        if (this.contains(HeaderNameEnum.CONTENT_TYPE)) {
            return Optional.of(HttpMediaType.create((String)this.get(HeaderNameEnum.CONTENT_TYPE).get()));
        }
        return Optional.empty();
    }

    public int size();

    public List<HttpMediaType> acceptedTypes();

    default public boolean isAccepted(MediaType mediaType) {
        return true;
    }

    @Deprecated
    default public Map<String, List<String>> toMap() {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        this.forEach(it -> headers.put(it.name(), it.allValues()));
        return headers;
    }

    default public Stream<Http.Header> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

