/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.buffers.Ascii;
import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.LazyString;
import io.helidon.common.mapper.Value;
import io.helidon.http.DateTimeHelper;
import io.helidon.http.HeaderNameEnum;
import io.helidon.http.HeaderNameImpl;
import io.helidon.http.HeaderValueArray;
import io.helidon.http.HeaderValueCached;
import io.helidon.http.HeaderValueCopy;
import io.helidon.http.HeaderValueLazy;
import io.helidon.http.HeaderValueList;
import io.helidon.http.HeaderValueSingle;
import io.helidon.http.HttpToken;
import io.helidon.http.MethodHelper;
import io.helidon.http.MethodPredicates;
import io.helidon.http.StatusHelper;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public final class Http {
    private Http() {
    }

    public static final class DateTime {
        public static final DateTimeFormatter RFC_850_DATE_TIME = DateTimeHelper.RFC_850_DATE_TIME;
        public static final DateTimeFormatter RFC_1123_DATE_TIME = DateTimeFormatter.RFC_1123_DATE_TIME;
        public static final DateTimeFormatter ASCTIME_DATE_TIME = DateTimeHelper.ASCTIME_DATE_TIME;

        private DateTime() {
        }

        public static ZonedDateTime parse(String text) {
            return DateTimeHelper.parse(text);
        }

        public static ZonedDateTime timestamp() {
            return DateTimeHelper.timestamp();
        }

        public static String rfc1123String() {
            return DateTimeHelper.rfc1123String();
        }

        public static byte[] http1Bytes() {
            return DateTimeHelper.http1Bytes();
        }
    }

    public static final class Headers {
        public static final Header ACCEPT_RANGES_BYTES = Headers.createCached(HeaderNames.ACCEPT_RANGES, "bytes");
        public static final Header ACCEPT_RANGES_NONE = Headers.createCached(HeaderNames.ACCEPT_RANGES, "none");
        public static final Header TRANSFER_ENCODING_CHUNKED = Headers.createCached(HeaderNames.TRANSFER_ENCODING, "chunked");
        public static final Header CONNECTION_KEEP_ALIVE = Headers.createCached(HeaderNames.CONNECTION, "keep-alive");
        public static final Header CONNECTION_CLOSE = Headers.createCached(HeaderNames.CONNECTION, "close");
        public static final Header CONTENT_TYPE_JSON = Headers.createCached(HeaderNames.CONTENT_TYPE, "application/json");
        public static final Header CONTENT_TYPE_TEXT_PLAIN = Headers.createCached(HeaderNames.CONTENT_TYPE, "text/plain");
        public static final Header CONTENT_TYPE_OCTET_STREAM = Headers.createCached(HeaderNames.CONTENT_TYPE, "application/octet-stream");
        public static final Header CONTENT_TYPE_EVENT_STREAM = Headers.createCached(HeaderNames.CONTENT_TYPE, "text/event-stream");
        public static final Header ACCEPT_JSON = Headers.createCached(HeaderNames.ACCEPT, "application/json");
        public static final Header ACCEPT_TEXT = Headers.createCached(HeaderNames.ACCEPT, "text/plain;charset=UTF-8");
        public static final Header ACCEPT_EVENT_STREAM = Headers.createCached(HeaderNames.ACCEPT, "text/event-stream");
        public static final Header EXPECT_100 = Headers.createCached(HeaderNames.EXPECT, "100-continue");
        public static final Header CONTENT_LENGTH_ZERO = Headers.createCached(HeaderNames.CONTENT_LENGTH, "0");
        public static final Header CACHE_NO_CACHE = Headers.create(HeaderNames.CACHE_CONTROL, "no-cache", "no-store", "must-revalidate", "no-transform");
        public static final Header CACHE_NORMAL = Headers.createCached(HeaderNames.CACHE_CONTROL, "no-transform");
        public static final Header TE_TRAILERS = Headers.createCached(HeaderNames.TE, "trailers");

        private Headers() {
        }

        public static Header createCached(String name, String value) {
            return Headers.createCached(HeaderNames.create(name), value);
        }

        public static Header createCached(String name, int value) {
            return Headers.createCached(HeaderNames.create(name), value);
        }

        public static Header createCached(String name, long value) {
            return Headers.createCached(HeaderNames.create(name), value);
        }

        public static Header createCached(HeaderName name, String value) {
            return new HeaderValueCached(name, false, false, value.getBytes(StandardCharsets.US_ASCII), value);
        }

        public static Header createCached(HeaderName name, int value) {
            return Headers.createCached(name, String.valueOf(value));
        }

        public static Header createCached(HeaderName name, long value) {
            return Headers.createCached(name, String.valueOf(value));
        }

        public static Header create(HeaderName name, LazyString value) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(value);
            return new HeaderValueLazy(name, false, false, value);
        }

        public static Header create(HeaderName name, int value) {
            Objects.requireNonNull(name);
            return new HeaderValueSingle(name, false, false, String.valueOf(value));
        }

        public static Header create(HeaderName name, long value) {
            Objects.requireNonNull(name);
            return new HeaderValueSingle(name, false, false, String.valueOf(value));
        }

        public static Header create(HeaderName name, String value) {
            Objects.requireNonNull(name, "HeaderName must not be null");
            Objects.requireNonNull(value, "HeaderValue must not be null");
            return new HeaderValueSingle(name, false, false, value);
        }

        public static Header create(String name, String value) {
            Objects.requireNonNull(name, "Header name must not be null");
            return Headers.create(HeaderNames.create(name), value);
        }

        public static Header create(String name, int value) {
            Objects.requireNonNull(name, "Header name must not be null");
            return Headers.create(HeaderNames.create(name), value);
        }

        public static Header create(String name, long value) {
            Objects.requireNonNull(name, "Header name must not be null");
            return Headers.create(HeaderNames.create(name), value);
        }

        public static Header create(HeaderName name, String ... values) {
            if (values.length == 0) {
                throw new IllegalArgumentException("Cannot create a header without a value. Header: " + String.valueOf(name));
            }
            return new HeaderValueArray(name, false, false, values);
        }

        public static Header create(String name, String ... values) {
            return Headers.create(HeaderNames.create(name), values);
        }

        public static Header create(HeaderName name, Collection<String> values) {
            return new HeaderValueList(name, false, false, values);
        }

        public static Header create(String name, Collection<String> values) {
            return Headers.create(HeaderNames.create(name), values);
        }

        public static Header createCached(HeaderName name, boolean changing, boolean sensitive, String value) {
            return new HeaderValueCached(name, changing, sensitive, value.getBytes(StandardCharsets.UTF_8), value);
        }

        public static Header create(HeaderName name, boolean changing, boolean sensitive, String ... values) {
            return new HeaderValueArray(name, changing, sensitive, values);
        }

        public static Header create(HeaderName name, boolean changing, boolean sensitive, int value) {
            return Headers.create(name, changing, sensitive, String.valueOf(value));
        }

        public static Header create(HeaderName name, boolean changing, boolean sensitive, long value) {
            return Headers.create(name, changing, sensitive, String.valueOf(value));
        }
    }

    public static final class HeaderNames {
        public static final HeaderName ACCEPT = HeaderNameEnum.ACCEPT;
        public static final HeaderName ACCEPT_CHARSET = HeaderNameEnum.ACCEPT_CHARSET;
        public static final HeaderName ACCEPT_ENCODING = HeaderNameEnum.ACCEPT_ENCODING;
        public static final HeaderName ACCEPT_LANGUAGE = HeaderNameEnum.ACCEPT_LANGUAGE;
        public static final HeaderName ACCEPT_DATETIME = HeaderNameEnum.ACCEPT_DATETIME;
        public static final HeaderName ACCESS_CONTROL_ALLOW_CREDENTIALS = HeaderNameEnum.ACCESS_CONTROL_ALLOW_CREDENTIALS;
        public static final HeaderName ACCESS_CONTROL_ALLOW_HEADERS = HeaderNameEnum.ACCESS_CONTROL_ALLOW_HEADERS;
        public static final HeaderName ACCESS_CONTROL_ALLOW_METHODS = HeaderNameEnum.ACCESS_CONTROL_ALLOW_METHODS;
        public static final HeaderName ACCESS_CONTROL_ALLOW_ORIGIN = HeaderNameEnum.ACCESS_CONTROL_ALLOW_ORIGIN;
        public static final HeaderName ACCESS_CONTROL_EXPOSE_HEADERS = HeaderNameEnum.ACCESS_CONTROL_EXPOSE_HEADERS;
        public static final HeaderName ACCESS_CONTROL_MAX_AGE = HeaderNameEnum.ACCESS_CONTROL_MAX_AGE;
        public static final HeaderName ACCESS_CONTROL_REQUEST_HEADERS = HeaderNameEnum.ACCESS_CONTROL_REQUEST_HEADERS;
        public static final HeaderName ACCESS_CONTROL_REQUEST_METHOD = HeaderNameEnum.ACCESS_CONTROL_REQUEST_METHOD;
        public static final HeaderName AUTHORIZATION = HeaderNameEnum.AUTHORIZATION;
        public static final HeaderName COOKIE = HeaderNameEnum.COOKIE;
        public static final HeaderName EXPECT = HeaderNameEnum.EXPECT;
        public static final HeaderName FORWARDED = HeaderNameEnum.FORWARDED;
        public static final HeaderName FROM = HeaderNameEnum.FROM;
        public static final HeaderName HOST = HeaderNameEnum.HOST;
        public static final String HOST_STRING = "Host";
        public static final HeaderName IF_MATCH = HeaderNameEnum.IF_MATCH;
        public static final HeaderName IF_MODIFIED_SINCE = HeaderNameEnum.IF_MODIFIED_SINCE;
        public static final HeaderName IF_NONE_MATCH = HeaderNameEnum.IF_NONE_MATCH;
        public static final HeaderName IF_RANGE = HeaderNameEnum.IF_RANGE;
        public static final HeaderName IF_UNMODIFIED_SINCE = HeaderNameEnum.IF_UNMODIFIED_SINCE;
        public static final HeaderName MAX_FORWARDS = HeaderNameEnum.MAX_FORWARDS;
        public static final HeaderName ORIGIN = HeaderNameEnum.ORIGIN;
        public static final HeaderName PROXY_AUTHENTICATE = HeaderNameEnum.PROXY_AUTHENTICATE;
        public static final HeaderName PROXY_AUTHORIZATION = HeaderNameEnum.PROXY_AUTHORIZATION;
        public static final HeaderName RANGE = HeaderNameEnum.RANGE;
        public static final HeaderName REFERER = HeaderNameEnum.REFERER;
        public static final HeaderName REFRESH = HeaderNameEnum.REFRESH;
        public static final HeaderName TE = HeaderNameEnum.TE;
        public static final HeaderName USER_AGENT = HeaderNameEnum.USER_AGENT;
        public static final HeaderName VIA = HeaderNameEnum.VIA;
        public static final HeaderName ACCEPT_PATCH = HeaderNameEnum.ACCEPT_PATCH;
        public static final HeaderName ACCEPT_RANGES = HeaderNameEnum.ACCEPT_RANGES;
        public static final HeaderName AGE = HeaderNameEnum.AGE;
        public static final HeaderName ALLOW = HeaderNameEnum.ALLOW;
        public static final HeaderName ALT_SVC = HeaderNameEnum.ALT_SVC;
        public static final HeaderName CACHE_CONTROL = HeaderNameEnum.CACHE_CONTROL;
        public static final HeaderName CONNECTION = HeaderNameEnum.CONNECTION;
        public static final HeaderName CONTENT_DISPOSITION = HeaderNameEnum.CONTENT_DISPOSITION;
        public static final HeaderName CONTENT_ENCODING = HeaderNameEnum.CONTENT_ENCODING;
        public static final HeaderName CONTENT_LANGUAGE = HeaderNameEnum.CONTENT_LANGUAGE;
        public static final HeaderName CONTENT_LENGTH = HeaderNameEnum.CONTENT_LENGTH;
        public static final HeaderName CONTENT_LOCATION = HeaderNameEnum.CONTENT_LOCATION;
        public static final HeaderName CONTENT_RANGE = HeaderNameEnum.CONTENT_RANGE;
        public static final HeaderName CONTENT_TYPE = HeaderNameEnum.CONTENT_TYPE;
        public static final HeaderName DATE = HeaderNameEnum.DATE;
        public static final HeaderName ETAG = HeaderNameEnum.ETAG;
        public static final HeaderName EXPIRES = HeaderNameEnum.EXPIRES;
        public static final HeaderName LAST_MODIFIED = HeaderNameEnum.LAST_MODIFIED;
        public static final HeaderName LINK = HeaderNameEnum.LINK;
        public static final HeaderName LOCATION = HeaderNameEnum.LOCATION;
        public static final HeaderName PRAGMA = HeaderNameEnum.PRAGMA;
        public static final HeaderName PUBLIC_KEY_PINS = HeaderNameEnum.PUBLIC_KEY_PINS;
        public static final HeaderName RETRY_AFTER = HeaderNameEnum.RETRY_AFTER;
        public static final HeaderName SERVER = HeaderNameEnum.SERVER;
        public static final HeaderName SET_COOKIE = HeaderNameEnum.SET_COOKIE;
        public static final HeaderName SET_COOKIE2 = HeaderNameEnum.SET_COOKIE2;
        public static final HeaderName STRICT_TRANSPORT_SECURITY = HeaderNameEnum.STRICT_TRANSPORT_SECURITY;
        public static final HeaderName TRAILER = HeaderNameEnum.TRAILER;
        public static final HeaderName TRANSFER_ENCODING = HeaderNameEnum.TRANSFER_ENCODING;
        public static final HeaderName TSV = HeaderNameEnum.TSV;
        public static final HeaderName UPGRADE = HeaderNameEnum.UPGRADE;
        public static final HeaderName VARY = HeaderNameEnum.VARY;
        public static final HeaderName WARNING = HeaderNameEnum.WARNING;
        public static final HeaderName WWW_AUTHENTICATE = HeaderNameEnum.WWW_AUTHENTICATE;
        public static final HeaderName X_HELIDON_CN = HeaderNameEnum.X_HELIDON_CN;
        public static final HeaderName X_FORWARDED_FOR = HeaderNameEnum.X_FORWARDED_FOR;
        public static final HeaderName X_FORWARDED_HOST = HeaderNameEnum.X_FORWARDED_HOST;
        public static final HeaderName X_FORWARDED_PORT = HeaderNameEnum.X_FORWARDED_PORT;
        public static final HeaderName X_FORWARDED_PREFIX = HeaderNameEnum.X_FORWARDED_PREFIX;
        public static final HeaderName X_FORWARDED_PROTO = HeaderNameEnum.X_FORWARDED_PROTO;

        private HeaderNames() {
        }

        public static HeaderName create(String name) {
            HeaderName headerName = HeaderNameEnum.byCapitalizedName(name);
            if (headerName == null) {
                return new HeaderNameImpl(Ascii.toLowerCase((String)name), name);
            }
            return headerName;
        }

        public static HeaderName create(String lowerCase, String defaultCase) {
            HeaderName headerName = HeaderNameEnum.byName(lowerCase);
            if (headerName == null) {
                return new HeaderNameImpl(lowerCase, defaultCase);
            }
            return headerName;
        }

        public static HeaderName createFromLowercase(String lowerCase) {
            HeaderName headerName = HeaderNameEnum.byName(lowerCase);
            if (headerName == null) {
                return new HeaderNameImpl(lowerCase, lowerCase);
            }
            return headerName;
        }
    }

    public static interface HeaderValueWriteable
    extends Header {
        public static HeaderValueWriteable create(Header header) {
            return new HeaderValueCopy(header);
        }

        public HeaderValueWriteable addValue(String var1);
    }

    public static interface Header
    extends Value<String> {
        public String name();

        @Deprecated(forRemoval=true, since="4.0.0")
        default public String value() {
            return (String)this.get();
        }

        public HeaderName headerName();

        default public String values() {
            return String.join((CharSequence)",", this.allValues());
        }

        public List<String> allValues();

        default public List<String> allValues(boolean split) {
            if (split) {
                List<String> values = this.allValues();
                if (values.size() == 1) {
                    String value = values.get(0);
                    if (value.contains(", ")) {
                        return List.of(value.split(", "));
                    }
                    return List.of(value);
                }
                return values;
            }
            return this.allValues();
        }

        public int valueCount();

        public boolean sensitive();

        public boolean changing();

        default public byte[] valueBytes() {
            return ((String)this.get()).getBytes(StandardCharsets.US_ASCII);
        }

        default public void writeHttp1Header(BufferData buffer) {
            byte[] nameBytes = this.name().getBytes(StandardCharsets.US_ASCII);
            if (this.valueCount() == 1) {
                this.writeHeader(buffer, nameBytes, this.valueBytes());
            } else {
                for (String value : this.allValues()) {
                    this.writeHeader(buffer, nameBytes, value.getBytes(StandardCharsets.US_ASCII));
                }
            }
        }

        default public void validate() throws IllegalArgumentException {
            String name = this.name();
            HttpToken.validate(name);
            Header.validateValue(name, this.values());
        }

        private static void validateValue(String name, String value) throws IllegalArgumentException {
            char[] vChars = value.toCharArray();
            int vLength = vChars.length;
            for (int i = 0; i < vLength; ++i) {
                char vChar = vChars[i];
                if (i == 0) {
                    if (vChar >= '!' && vChar != '\u007f') continue;
                    throw new IllegalArgumentException("First character of the header value is invalid for header '" + name + "'");
                }
                if ((vChar >= ' ' || vChar == '\t') && vChar != '\u007f') continue;
                throw new IllegalArgumentException("Character at position " + (i + 1) + " of the header value is invalid for header '" + name + "'");
            }
        }

        private void writeHeader(BufferData buffer, byte[] nameBytes, byte[] valueBytes) {
            buffer.write(nameBytes);
            buffer.write(58);
            buffer.write(32);
            buffer.write(valueBytes);
            buffer.write(13);
            buffer.write(10);
        }
    }

    public static sealed interface HeaderName
    permits HeaderNameImpl, HeaderNameEnum {
        public String lowerCase();

        public String defaultCase();

        default public int index() {
            return -1;
        }

        default public boolean isPseudoHeader() {
            return this.lowerCase().charAt(0) == ':';
        }
    }

    public static class Status {
        public static final Status CONTINUE_100 = new Status(100, "Continue", true);
        public static final Status SWITCHING_PROTOCOLS_101 = new Status(101, "Switching Protocols", true);
        public static final Status OK_200 = new Status(200, "OK", true);
        public static final Status CREATED_201 = new Status(201, "Created", true);
        public static final Status ACCEPTED_202 = new Status(202, "Accepted", true);
        public static final Status NO_CONTENT_204 = new Status(204, "No Content", true);
        public static final Status RESET_CONTENT_205 = new Status(205, "Reset Content", true);
        public static final Status PARTIAL_CONTENT_206 = new Status(206, "Partial Content", true);
        public static final Status MOVED_PERMANENTLY_301 = new Status(301, "Moved Permanently", true);
        public static final Status FOUND_302 = new Status(302, "Found", true);
        public static final Status SEE_OTHER_303 = new Status(303, "See Other", true);
        public static final Status NOT_MODIFIED_304 = new Status(304, "Not Modified", true);
        public static final Status USE_PROXY_305 = new Status(305, "Use Proxy", true);
        public static final Status TEMPORARY_REDIRECT_307 = new Status(307, "Temporary Redirect", true);
        public static final Status PERMANENT_REDIRECT_308 = new Status(308, "Permanent Redirect", true);
        public static final Status BAD_REQUEST_400 = new Status(400, "Bad Request", true);
        public static final Status UNAUTHORIZED_401 = new Status(401, "Unauthorized", true);
        public static final Status PAYMENT_REQUIRED_402 = new Status(402, "Payment Required", true);
        public static final Status FORBIDDEN_403 = new Status(403, "Forbidden", true);
        public static final Status NOT_FOUND_404 = new Status(404, "Not Found", true);
        public static final Status METHOD_NOT_ALLOWED_405 = new Status(405, "Method Not Allowed", true);
        public static final Status NOT_ACCEPTABLE_406 = new Status(406, "Not Acceptable", true);
        public static final Status PROXY_AUTHENTICATION_REQUIRED_407 = new Status(407, "Proxy Authentication Required", true);
        public static final Status REQUEST_TIMEOUT_408 = new Status(408, "Request Timeout", true);
        public static final Status CONFLICT_409 = new Status(409, "Conflict", true);
        public static final Status GONE_410 = new Status(410, "Gone", true);
        public static final Status LENGTH_REQUIRED_411 = new Status(411, "Length Required", true);
        public static final Status PRECONDITION_FAILED_412 = new Status(412, "Precondition Failed", true);
        public static final Status REQUEST_ENTITY_TOO_LARGE_413 = new Status(413, "Request Entity Too Large", true);
        public static final Status REQUEST_URI_TOO_LONG_414 = new Status(414, "Request-URI Too Long", true);
        public static final Status UNSUPPORTED_MEDIA_TYPE_415 = new Status(415, "Unsupported Media Type", true);
        public static final Status REQUESTED_RANGE_NOT_SATISFIABLE_416 = new Status(416, "Requested Range Not Satisfiable", true);
        public static final Status EXPECTATION_FAILED_417 = new Status(417, "Expectation Failed", true);
        public static final Status I_AM_A_TEAPOT_418 = new Status(418, "I'm a teapot", true);
        public static final Status MISDIRECTED_REQUEST_421 = new Status(421, "Misdirected Request", true);
        public static final Status UNPROCESSABLE_CONTENT_422 = new Status(422, "Unprocessable Content", true);
        public static final Status LOCKED_423 = new Status(423, "Locked", true);
        public static final Status FAILED_DEPENDENCY_424 = new Status(424, "Failed Dependency", true);
        public static final Status UPGRADE_REQUIRED_426 = new Status(426, "Upgrade Required", true);
        public static final Status PRECONDITION_REQUIRED_428 = new Status(428, "Precondition Required", true);
        public static final Status TOO_MANY_REQUESTS_429 = new Status(429, "Too Many Requests", true);
        public static final Status INTERNAL_SERVER_ERROR_500 = new Status(500, "Internal Server Error", true);
        public static final Status NOT_IMPLEMENTED_501 = new Status(501, "Not Implemented", true);
        public static final Status BAD_GATEWAY_502 = new Status(502, "Bad Gateway", true);
        public static final Status SERVICE_UNAVAILABLE_503 = new Status(503, "Service Unavailable", true);
        public static final Status GATEWAY_TIMEOUT_504 = new Status(504, "Gateway Timeout", true);
        public static final Status HTTP_VERSION_NOT_SUPPORTED_505 = new Status(505, "HTTP Version Not Supported", true);
        private final int code;
        private final String reason;
        private final Family family;
        private final String codeText;
        private final String stringValue;

        private Status(int statusCode, String reasonPhrase, boolean instance) {
            this.code = statusCode;
            this.reason = reasonPhrase;
            this.family = Family.of(statusCode);
            this.codeText = String.valueOf(this.code);
            this.stringValue = this.code + " " + this.reason;
            if (instance) {
                StatusHelper.add(this);
            }
        }

        private Status(int statusCode, String reasonPhrase, Family family, String codeText) {
            this.code = statusCode;
            this.reason = reasonPhrase;
            this.family = family;
            this.codeText = codeText;
            this.stringValue = this.code + " " + this.reason;
        }

        public static Status create(int statusCode) {
            Status found = StatusHelper.find(statusCode);
            if (found == null) {
                return Status.createNew(Family.of(statusCode), statusCode, "", String.valueOf(statusCode));
            }
            return found;
        }

        public static Status create(int statusCode, String reasonPhrase) {
            Status found = StatusHelper.find(statusCode);
            if (found == null) {
                return Status.createNew(Family.of(statusCode), statusCode, reasonPhrase, String.valueOf(statusCode));
            }
            if (reasonPhrase == null) {
                return found;
            }
            if (found.reasonPhrase().equalsIgnoreCase(reasonPhrase)) {
                return found;
            }
            return Status.createNew(found.family(), statusCode, reasonPhrase, found.codeText());
        }

        private static Status createNew(Family family, int statusCode, String reasonPhrase, String codeText) {
            return new Status(statusCode, reasonPhrase, family, codeText);
        }

        public int code() {
            return this.code;
        }

        public Family family() {
            return this.family;
        }

        public String reasonPhrase() {
            return this.reason;
        }

        public String codeText() {
            return this.codeText;
        }

        public String toString() {
            return this.stringValue;
        }

        public String text() {
            return this.stringValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.code == status.code && this.reason.equals(status.reason);
        }

        public int hashCode() {
            return Objects.hash(this.code, this.reason);
        }

        static {
            StatusHelper.statusesDone();
        }

        public static enum Family {
            INFORMATIONAL,
            SUCCESSFUL,
            REDIRECTION,
            CLIENT_ERROR,
            SERVER_ERROR,
            OTHER;


            public static Family of(int statusCode) {
                return switch (statusCode / 100) {
                    case 1 -> INFORMATIONAL;
                    case 2 -> SUCCESSFUL;
                    case 3 -> REDIRECTION;
                    case 4 -> CLIENT_ERROR;
                    case 5 -> SERVER_ERROR;
                    default -> OTHER;
                };
            }
        }
    }

    public static interface MethodPredicate
    extends Predicate<Method> {
        public Set<Method> acceptedMethods();
    }

    public static final class Method {
        private static final String GET_STRING = "GET";
        public static final Method GET = new Method("GET", true);
        public static final Method POST = new Method("POST", true);
        public static final Method PUT = new Method("PUT", true);
        public static final Method DELETE = new Method("DELETE", true);
        public static final Method HEAD = new Method("HEAD", true);
        public static final Method OPTIONS = new Method("OPTIONS", true);
        public static final Method TRACE = new Method("TRACE", true);
        public static final Method PATCH = new Method("PATCH", true);
        public static final Method CONNECT = new Method("CONNECT", true);
        private final String name;
        private final int length;
        private final boolean instance;

        private Method(String name, boolean instance) {
            this.name = name;
            this.length = name.length();
            this.instance = instance;
            if (instance) {
                MethodHelper.add(this);
            }
        }

        public static Method create(String name) {
            if (name.equals(GET_STRING)) {
                return GET;
            }
            String methodName = Ascii.toUpperCase((String)name);
            Method method = MethodHelper.byName(methodName);
            if (method == null) {
                HttpToken.validate(methodName);
                return new Method(methodName, false);
            }
            return method;
        }

        public static MethodPredicate predicate(Method ... methods) {
            return switch (methods.length) {
                case 0 -> MethodPredicates.TruePredicate.get();
                case 1 -> {
                    if (methods[0].instance) {
                        yield new MethodPredicates.SingleMethodEnumPredicate(methods[0]);
                    }
                    yield new MethodPredicates.SingleMethodPredicate(methods[0]);
                }
                default -> new MethodPredicates.MethodsPredicate(methods);
            };
        }

        public static MethodPredicate predicate(Collection<Method> methods) {
            switch (methods.size()) {
                case 0: {
                    return MethodPredicates.TruePredicate.get();
                }
                case 1: {
                    Method first = methods.iterator().next();
                    return first.instance ? new MethodPredicates.SingleMethodEnumPredicate(first) : new MethodPredicates.SingleMethodPredicate(first);
                }
            }
            return new MethodPredicates.MethodsPredicate(methods.toArray(new Method[0]));
        }

        @Deprecated
        public String name() {
            return this.text();
        }

        public String text() {
            return this.name;
        }

        public int length() {
            return this.length;
        }

        public String toString() {
            return this.text();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Method method = (Method)o;
            return this.name.equals(method.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        static {
            MethodHelper.methodsDone();
        }
    }
}

