/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.uri.UriFragment;
import io.helidon.common.uri.UriPath;
import io.helidon.common.uri.UriQuery;
import io.helidon.http.Http;
import java.util.Objects;

public class HttpPrologue {
    private final String rawProtocol;
    private final String protocol;
    private final String protocolVersion;
    private final Http.Method method;
    private final UriPath uriPath;
    private final String rawQuery;
    private final String rawFragment;
    private UriQuery query;
    private UriFragment fragment;

    private HttpPrologue(String rawProtocol, String protocol, String protocolVersion, Http.Method method, UriPath path, String rawQuery, String rawFragment) {
        this.rawProtocol = rawProtocol;
        this.protocol = protocol;
        this.protocolVersion = protocolVersion;
        this.method = method;
        this.uriPath = path;
        this.rawQuery = rawQuery;
        this.rawFragment = rawFragment;
    }

    private HttpPrologue(String rawProtocol, String protocol, String protocolVersion, Http.Method httpMethod, UriPath uriPath, UriQuery uriQuery, UriFragment uriFragment) {
        this.rawProtocol = rawProtocol;
        this.protocol = protocol;
        this.protocolVersion = protocolVersion;
        this.method = httpMethod;
        this.uriPath = uriPath;
        this.rawQuery = uriQuery.rawValue();
        this.rawFragment = uriFragment.rawValue();
        this.fragment = uriFragment;
        this.query = uriQuery;
    }

    public static HttpPrologue create(String rawProtocol, String protocol, String protocolVersion, Http.Method httpMethod, String unresolvedPath, boolean validatePath) {
        String rawQuery;
        String rawFragment;
        String rawPath = unresolvedPath;
        int fragment = rawPath.lastIndexOf(35);
        if (fragment > -1) {
            rawFragment = rawPath.substring(fragment + 1);
            rawPath = rawPath.substring(0, fragment);
        } else {
            rawFragment = null;
        }
        int query = rawPath.indexOf(63);
        if (query > -1) {
            rawQuery = rawPath.substring(query + 1);
            rawPath = rawPath.substring(0, query);
        } else {
            rawQuery = null;
        }
        UriPath uriPath = UriPath.create((String)rawPath);
        if (validatePath) {
            uriPath.validate();
        }
        return new HttpPrologue(rawProtocol, protocol, protocolVersion, httpMethod, uriPath, rawQuery, rawFragment);
    }

    public static HttpPrologue create(String rawProtocol, String protocol, String protocolVersion, Http.Method httpMethod, UriPath uriPath, UriQuery uriQuery, UriFragment uriFragment) {
        return new HttpPrologue(rawProtocol, protocol, protocolVersion, httpMethod, uriPath, uriQuery, uriFragment);
    }

    public String rawProtocol() {
        return this.rawProtocol;
    }

    public String protocol() {
        return this.protocol;
    }

    public String protocolVersion() {
        return this.protocolVersion;
    }

    public Http.Method method() {
        return this.method;
    }

    public UriPath uriPath() {
        return this.uriPath;
    }

    public UriQuery query() {
        if (this.query == null) {
            this.query = this.rawQuery == null ? UriQuery.empty() : UriQuery.create((String)this.rawQuery);
        }
        return this.query;
    }

    public UriFragment fragment() {
        if (this.fragment == null) {
            this.fragment = this.rawFragment == null ? UriFragment.empty() : UriFragment.create((String)this.rawFragment);
        }
        return this.fragment;
    }

    public int hashCode() {
        return Objects.hash(this.protocol, this.protocolVersion, this.method, this.uriPath, this.query(), this.fragment());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        HttpPrologue that = (HttpPrologue)obj;
        return Objects.equals(this.protocol, that.protocol()) && Objects.equals(this.protocolVersion, that.protocolVersion()) && Objects.equals(this.method, that.method()) && Objects.equals(this.uriPath, that.uriPath()) && Objects.equals(this.query, that.query()) && Objects.equals(this.fragment, that.fragment());
    }

    public String toString() {
        return "HttpPrologue[protocol=" + this.protocol + ", protocolVersion=" + this.protocolVersion + ", method=" + String.valueOf(this.method) + ", uriPath=" + String.valueOf(this.uriPath) + ", query=" + String.valueOf(this.query()) + ", fragment=" + String.valueOf(this.fragment()) + "]";
    }
}

