/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.http.Http;
import java.util.ArrayList;
import java.util.List;

final class MethodHelper {
    private static final List<Http.Method> KNOWN = new ArrayList<Http.Method>(10);
    private static AsciiMethodPair[] methods;

    private MethodHelper() {
    }

    static void add(Http.Method method) {
        KNOWN.add(method);
    }

    static void methodsDone() {
        methods = new AsciiMethodPair[KNOWN.size()];
        for (int i = 0; i < KNOWN.size(); ++i) {
            MethodHelper.methods[i] = AsciiMethodPair.create(KNOWN.get(i));
        }
        KNOWN.clear();
    }

    static Http.Method byName(String upperCase) {
        for (AsciiMethodPair method : methods) {
            if (!method.string().equals(upperCase)) continue;
            return method.method();
        }
        return null;
    }

    private record AsciiMethodPair(String string, Http.Method method) {
        public static AsciiMethodPair create(Http.Method method) {
            return new AsciiMethodPair(method.text(), method);
        }
    }
}

