/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.common.parameters.Parameters;
import io.helidon.http.CookieParser;
import io.helidon.http.Headers;
import io.helidon.http.Http;
import io.helidon.http.HttpMediaType;
import io.helidon.http.ServerRequestHeadersImpl;
import io.helidon.http.WritableHeaders;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;

public interface ServerRequestHeaders
extends Headers {
    public static final Http.Header HUC_ACCEPT_DEFAULT = Http.Headers.create(Http.HeaderNames.ACCEPT, "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2");
    public static final List<HttpMediaType> HUC_ACCEPT_DEFAULT_TYPES = List.of(HttpMediaType.create(MediaTypes.TEXT_HTML), HttpMediaType.create(MediaTypes.create((String)"image", (String)"gif")), HttpMediaType.create(MediaTypes.create((String)"image", (String)"jpeg")), HttpMediaType.builder().mediaType(MediaTypes.WILDCARD).q(0.2).build());

    public static ServerRequestHeaders create(Headers headers) {
        return new ServerRequestHeadersImpl(headers);
    }

    public static ServerRequestHeaders create() {
        return new ServerRequestHeadersImpl(WritableHeaders.create());
    }

    default public Optional<ZonedDateTime> ifModifiedSince() {
        if (this.contains(Http.HeaderNames.IF_MODIFIED_SINCE)) {
            return Optional.of(this.get(Http.HeaderNames.IF_MODIFIED_SINCE)).map(Http.Header::value).map(Http.DateTime::parse);
        }
        return Optional.empty();
    }

    default public Optional<ZonedDateTime> ifUnmodifiedSince() {
        if (this.contains(Http.HeaderNames.IF_UNMODIFIED_SINCE)) {
            return Optional.of(this.get(Http.HeaderNames.IF_UNMODIFIED_SINCE)).map(Http.Header::value).map(Http.DateTime::parse);
        }
        return Optional.empty();
    }

    @Override
    default public boolean isAccepted(MediaType mediaType) {
        List<HttpMediaType> accepted = this.acceptedTypes();
        if (accepted.isEmpty()) {
            return true;
        }
        for (HttpMediaType acceptedType : accepted) {
            if (!acceptedType.test(mediaType)) continue;
            return true;
        }
        return false;
    }

    default public Optional<MediaType> bestAccepted(MediaType ... mediaTypes) {
        if (mediaTypes.length == 0) {
            return Optional.empty();
        }
        List<HttpMediaType> accepted = this.acceptedTypes();
        if (accepted.isEmpty()) {
            return Optional.of(mediaTypes[0]);
        }
        double best = 0.0;
        MediaType result = null;
        for (MediaType mt : mediaTypes) {
            for (HttpMediaType acc : accepted) {
                double q = acc.qualityFactor();
                if (!(q > best) || !acc.test(mt)) continue;
                if (q == 1.0) {
                    return Optional.of(mt);
                }
                best = q;
                result = mt;
            }
        }
        return Optional.ofNullable(result);
    }

    default public Parameters cookies() {
        if (this.contains(Http.HeaderNames.COOKIE)) {
            return CookieParser.parse(this.get(Http.HeaderNames.COOKIE));
        }
        return CookieParser.empty();
    }

    default public Optional<ZonedDateTime> acceptDatetime() {
        if (this.contains(Http.HeaderNames.ACCEPT_DATETIME)) {
            return Optional.of(this.get(Http.HeaderNames.ACCEPT_DATETIME)).map(Http.Header::value).map(Http.DateTime::parse);
        }
        return Optional.empty();
    }

    default public Optional<ZonedDateTime> date() {
        if (this.contains(Http.HeaderNames.DATE)) {
            return Optional.of(this.get(Http.HeaderNames.DATE)).map(Http.Header::value).map(Http.DateTime::parse);
        }
        return Optional.empty();
    }

    default public Optional<URI> referer() {
        if (this.contains(Http.HeaderNames.REFERER)) {
            return Optional.of(this.get(Http.HeaderNames.REFERER)).map(Http.Header::value).map(URI::create);
        }
        return Optional.empty();
    }
}

