/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.http.Http;
import java.util.ArrayList;
import java.util.List;

final class StatusHelper {
    private static final List<Http.Status> KNOWN = new ArrayList<Http.Status>(40);
    private static StatusPair[] statuses;

    private StatusHelper() {
    }

    static Http.Status find(int statusCode) {
        for (StatusPair status : statuses) {
            if (status.code != statusCode) continue;
            return status.status;
        }
        return null;
    }

    static void add(Http.Status status) {
        KNOWN.add(status);
    }

    static void statusesDone() {
        statuses = new StatusPair[KNOWN.size()];
        for (int i = 0; i < KNOWN.size(); ++i) {
            StatusHelper.statuses[i] = StatusPair.create(KNOWN.get(i));
        }
        KNOWN.clear();
    }

    private record StatusPair(int code, Http.Status status) {
        public static StatusPair create(Http.Status status) {
            return new StatusPair(status.code(), status);
        }
    }
}

