/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.media.type.MediaType;
import io.helidon.http.HeaderNameEnum;
import io.helidon.http.Headers;
import io.helidon.http.HeadersImpl;
import io.helidon.http.Http;
import java.util.Collection;
import java.util.function.Consumer;

public interface WritableHeaders<B extends WritableHeaders<B>>
extends Headers {
    public static WritableHeaders<?> create() {
        return new HeadersImpl();
    }

    public static WritableHeaders<?> create(Headers headers) {
        return new HeadersImpl(headers);
    }

    public B setIfAbsent(Http.Header var1);

    public B add(Http.Header var1);

    default public B add(Http.HeaderName header, String ... value) {
        return this.add(Http.Headers.create(header, value));
    }

    default public B add(Http.HeaderName header, int value) {
        return this.add(Http.Headers.create(header, value));
    }

    default public B add(Http.HeaderName header, long value) {
        return this.add(Http.Headers.create(header, value));
    }

    public B remove(Http.HeaderName var1);

    public B remove(Http.HeaderName var1, Consumer<Http.Header> var2);

    default public B contentType(MediaType contentType) {
        return this.set(Http.Headers.create((Http.HeaderName)HeaderNameEnum.CONTENT_TYPE, contentType.text()));
    }

    public B set(Http.Header var1);

    default public B set(Http.HeaderName name, String ... values) {
        return this.set(Http.Headers.create(name, true, false, values));
    }

    default public B set(Http.HeaderName name, int value) {
        return this.set(Http.Headers.create(name, true, false, value));
    }

    default public B set(Http.HeaderName name, long value) {
        return this.set(Http.Headers.create(name, true, false, value));
    }

    default public B set(Http.HeaderName name, Collection<String> values) {
        return this.set(Http.Headers.create(name, values));
    }

    default public B contentLength(long length) {
        return this.set(Http.Headers.create((Http.HeaderName)HeaderNameEnum.CONTENT_LENGTH, true, false, String.valueOf(length)));
    }

    public B clear();

    public B from(Headers var1);
}

