/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperException;
import io.helidon.common.mapper.MapperManager;
import io.helidon.common.mapper.Value;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderWriteable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

abstract class HeaderValueBase
implements HeaderWriteable {
    private static final String[] QUALIFIER = new String[]{"http", "header"};
    private final HeaderName name;
    private final String actualName;
    private final String firstValue;
    private final boolean changing;
    private final boolean sensitive;

    HeaderValueBase(HeaderName name, boolean changing, boolean sensitive, String value) {
        this.name = name;
        this.actualName = name.defaultCase();
        this.changing = changing;
        this.sensitive = sensitive;
        this.firstValue = value;
    }

    @Override
    public abstract HeaderWriteable addValue(String var1);

    @Override
    public String name() {
        return this.actualName;
    }

    @Override
    public HeaderName headerName() {
        return this.name;
    }

    public String get() {
        return this.firstValue;
    }

    public <T> T get(Class<T> type) {
        return (T)MapperManager.global().map((Object)this.get(), String.class, type, QUALIFIER);
    }

    public <N> Value<N> as(Function<? super String, ? extends N> mapper) {
        return Value.create((MapperManager)MapperManager.global(), (String)this.name(), mapper.apply(this.get()), (String[])QUALIFIER);
    }

    public <N> Value<N> as(Class<N> type) throws MapperException {
        return this.asString().as(type);
    }

    public Value<String> asString() {
        return Value.create((MapperManager)MapperManager.global(), (String)this.name(), (Object)this.get(), (GenericType)GenericType.STRING, (String[])QUALIFIER);
    }

    public <N> Value<N> as(GenericType<N> type) throws MapperException {
        return this.asString().as(type);
    }

    public Optional<String> asOptional() throws MapperException {
        return this.asString().asOptional();
    }

    public Value<Boolean> asBoolean() {
        return this.asString().asBoolean();
    }

    public Value<Integer> asInt() {
        return this.asString().asInt();
    }

    public Value<Long> asLong() {
        return this.asString().asLong();
    }

    public Value<Double> asDouble() {
        return this.asString().asDouble();
    }

    @Override
    public abstract int valueCount();

    @Override
    public boolean sensitive() {
        return this.sensitive;
    }

    @Override
    public boolean changing() {
        return this.changing;
    }

    public int hashCode() {
        return Objects.hash(this.changing, this.sensitive, this.actualName, this.allValues());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HeaderValueBase)) {
            return false;
        }
        HeaderValueBase that = (HeaderValueBase)o;
        return this.changing == that.changing && this.sensitive == that.sensitive && this.actualName.equals(that.actualName) && this.valueCount() == that.valueCount() && this.allValues().equals(that.allValues());
    }

    public String toString() {
        return "HttpHeaderImpl[name=" + String.valueOf(this.name) + ", values=" + String.valueOf(this.allValues()) + ", changing=" + this.changing + ", sensitive=" + this.sensitive + "]";
    }
}

