/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.buffers.LazyString;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderValueBase;
import io.helidon.http.HeaderWriteable;
import java.util.ArrayList;
import java.util.List;

class HeaderValueLazy
extends HeaderValueBase {
    private final LazyString value;
    private List<String> values;

    HeaderValueLazy(HeaderName name, boolean changing, boolean sensitive, LazyString value) {
        super(name, changing, sensitive, null);
        this.value = value;
    }

    @Override
    public HeaderWriteable addValue(String value) {
        if (this.values == null) {
            this.values = new ArrayList<String>(2);
            this.values.add(this.value.stripOws());
        }
        this.values.add(value);
        return this;
    }

    @Override
    public String get() {
        return this.value.stripOws();
    }

    @Override
    public List<String> allValues() {
        if (this.values == null) {
            this.values = new ArrayList<String>(2);
            this.values.add(this.value.stripOws());
        }
        return this.values;
    }

    @Override
    public int valueCount() {
        if (this.values == null) {
            return 1;
        }
        return this.values.size();
    }
}

