/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.buffers.LazyString;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValueArray;
import io.helidon.http.HeaderValueCached;
import io.helidon.http.HeaderValueLazy;
import io.helidon.http.HeaderValueList;
import io.helidon.http.HeaderValueSingle;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Objects;

public final class HeaderValues {
    public static final Header ACCEPT_RANGES_BYTES = HeaderValues.createCached(HeaderNames.ACCEPT_RANGES, "bytes");
    public static final Header ACCEPT_RANGES_NONE = HeaderValues.createCached(HeaderNames.ACCEPT_RANGES, "none");
    public static final Header TRANSFER_ENCODING_CHUNKED = HeaderValues.createCached(HeaderNames.TRANSFER_ENCODING, "chunked");
    public static final Header CONNECTION_KEEP_ALIVE = HeaderValues.createCached(HeaderNames.CONNECTION, "keep-alive");
    public static final Header CONNECTION_CLOSE = HeaderValues.createCached(HeaderNames.CONNECTION, "close");
    public static final Header CONTENT_TYPE_JSON = HeaderValues.createCached(HeaderNames.CONTENT_TYPE, "application/json");
    public static final Header CONTENT_TYPE_TEXT_PLAIN = HeaderValues.createCached(HeaderNames.CONTENT_TYPE, "text/plain");
    public static final Header CONTENT_TYPE_OCTET_STREAM = HeaderValues.createCached(HeaderNames.CONTENT_TYPE, "application/octet-stream");
    public static final Header CONTENT_TYPE_EVENT_STREAM = HeaderValues.createCached(HeaderNames.CONTENT_TYPE, "text/event-stream");
    public static final Header ACCEPT_JSON = HeaderValues.createCached(HeaderNames.ACCEPT, "application/json");
    public static final Header ACCEPT_TEXT = HeaderValues.createCached(HeaderNames.ACCEPT, "text/plain;charset=UTF-8");
    public static final Header ACCEPT_EVENT_STREAM = HeaderValues.createCached(HeaderNames.ACCEPT, "text/event-stream");
    public static final Header EXPECT_100 = HeaderValues.createCached(HeaderNames.EXPECT, "100-continue");
    public static final Header CONTENT_LENGTH_ZERO = HeaderValues.createCached(HeaderNames.CONTENT_LENGTH, "0");
    public static final Header CACHE_NO_CACHE = HeaderValues.create(HeaderNames.CACHE_CONTROL, "no-cache", "no-store", "must-revalidate", "no-transform");
    public static final Header CACHE_NORMAL = HeaderValues.createCached(HeaderNames.CACHE_CONTROL, "no-transform");
    public static final Header TE_TRAILERS = HeaderValues.createCached(HeaderNames.TE, "trailers");

    private HeaderValues() {
    }

    public static Header createCached(String name, String value) {
        return HeaderValues.createCached(HeaderNames.create(name), value);
    }

    public static Header createCached(String name, int value) {
        return HeaderValues.createCached(HeaderNames.create(name), value);
    }

    public static Header createCached(String name, long value) {
        return HeaderValues.createCached(HeaderNames.create(name), value);
    }

    public static Header createCached(HeaderName name, String value) {
        return new HeaderValueCached(name, false, false, value.getBytes(StandardCharsets.US_ASCII), value);
    }

    public static Header createCached(HeaderName name, int value) {
        return HeaderValues.createCached(name, String.valueOf(value));
    }

    public static Header createCached(HeaderName name, long value) {
        return HeaderValues.createCached(name, String.valueOf(value));
    }

    public static Header create(HeaderName name, LazyString value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        return new HeaderValueLazy(name, false, false, value);
    }

    public static Header create(HeaderName name, int value) {
        Objects.requireNonNull(name);
        return new HeaderValueSingle(name, false, false, String.valueOf(value));
    }

    public static Header create(HeaderName name, long value) {
        Objects.requireNonNull(name);
        return new HeaderValueSingle(name, false, false, String.valueOf(value));
    }

    public static Header create(HeaderName name, String value) {
        Objects.requireNonNull(name, "HeaderName must not be null");
        Objects.requireNonNull(value, "HeaderValue must not be null");
        return new HeaderValueSingle(name, false, false, value);
    }

    public static Header create(String name, String value) {
        Objects.requireNonNull(name, "Header name must not be null");
        return HeaderValues.create(HeaderNames.create(name), value);
    }

    public static Header create(String name, int value) {
        Objects.requireNonNull(name, "Header name must not be null");
        return HeaderValues.create(HeaderNames.create(name), value);
    }

    public static Header create(String name, long value) {
        Objects.requireNonNull(name, "Header name must not be null");
        return HeaderValues.create(HeaderNames.create(name), value);
    }

    public static Header create(HeaderName name, String ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Cannot create a header without a value. Header: " + String.valueOf(name));
        }
        return new HeaderValueArray(name, false, false, values);
    }

    public static Header create(String name, String ... values) {
        return HeaderValues.create(HeaderNames.create(name), values);
    }

    public static Header create(HeaderName name, Collection<String> values) {
        return new HeaderValueList(name, false, false, values);
    }

    public static Header create(String name, Collection<String> values) {
        return HeaderValues.create(HeaderNames.create(name), values);
    }

    public static Header createCached(HeaderName name, boolean changing, boolean sensitive, String value) {
        return new HeaderValueCached(name, changing, sensitive, value.getBytes(StandardCharsets.UTF_8), value);
    }

    public static Header create(HeaderName name, boolean changing, boolean sensitive, String ... values) {
        return new HeaderValueArray(name, changing, sensitive, values);
    }

    public static Header create(HeaderName name, boolean changing, boolean sensitive, int value) {
        return HeaderValues.create(name, changing, sensitive, String.valueOf(value));
    }

    public static Header create(HeaderName name, boolean changing, boolean sensitive, long value) {
        return HeaderValues.create(name, changing, sensitive, String.valueOf(value));
    }
}

