/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.parameters.Parameters;
import io.helidon.common.uri.UriPath;
import io.helidon.http.PathMatcher;
import io.helidon.http.RoutedPath;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PathMatchers {
    private static final char[] REGEXP_META_CHARACTERS = "<([{\\^-=$!|]})?*+.>".toCharArray();
    private static final UriPath ROOT = UriPath.create((String)"/");
    private static final RoutedPath ROUTED_ROOT = new NoParamRoutedPath(ROOT);
    private static final String PARAM_PREFIX = "gfXdbHQlk";

    private PathMatchers() {
    }

    public static PathMatcher exact(String pathToMatch) {
        return new ExactPathMatcher(PathMatchers.fixPrefix(pathToMatch));
    }

    public static PathMatcher prefix(String pathToMatch) {
        return new PrefixPathMatcher(PathMatchers.fixPrefix(pathToMatch));
    }

    public static PathMatcher pattern(String pattern) {
        StringBuilder regexp = new StringBuilder(pattern.length() * 2);
        boolean escape = false;
        boolean optionalSequence = false;
        int paramCounter = 0;
        HashMap<String, String> paramToGroupName = new HashMap<String, String>();
        CharIterator iter = new CharIterator(pattern);
        while (iter.hasNext()) {
            char ch = iter.next();
            if (escape) {
                escape = false;
            } else {
                boolean shouldContinue = true;
                switch (ch) {
                    case '\\': {
                        escape = true;
                        break;
                    }
                    case '[': {
                        if (optionalSequence) {
                            throw new IllegalStateException("Optional sequences cannot be nested! Pattern: " + pattern + ", index: " + (iter.index() - 1));
                        }
                        optionalSequence = true;
                        regexp.append('(');
                        break;
                    }
                    case ']': {
                        if (optionalSequence) {
                            optionalSequence = false;
                            regexp.append(")?");
                            break;
                        }
                        shouldContinue = false;
                        break;
                    }
                    case '{': {
                        String name = PathMatchers.parseParameter(iter, regexp, paramCounter);
                        if (name.length() <= 0) break;
                        paramToGroupName.put(name, PARAM_PREFIX + paramCounter);
                        ++paramCounter;
                        break;
                    }
                    case '*': {
                        regexp.append(".*?");
                        break;
                    }
                    default: {
                        shouldContinue = false;
                    }
                }
                if (shouldContinue) continue;
            }
            PathMatchers.escapeIfNeeded(ch, regexp);
        }
        if (optionalSequence) {
            throw new IllegalStateException("Missing end of a optional sequence (']' character)! Pattern: " + pattern + ", index: " + (iter.index() - 1));
        }
        return new PatternPathMatcher(regexp.toString(), paramToGroupName);
    }

    public static PathMatcher create(String pathPattern) {
        boolean prefix = false;
        String checkPattern = pathPattern;
        if (pathPattern.endsWith("/*")) {
            prefix = true;
            checkPattern = pathPattern.substring(0, pathPattern.length() - 2);
        }
        if (checkPattern.contains("{") || checkPattern.contains("[") || checkPattern.contains("*") || checkPattern.contains("\\")) {
            return PathMatchers.pattern(pathPattern);
        }
        if (prefix) {
            return PathMatchers.prefix(checkPattern + "/");
        }
        return PathMatchers.exact(pathPattern);
    }

    public static PathMatcher any() {
        return new AnyMatcher();
    }

    private static void escapeIfNeeded(char ch, StringBuilder builder) {
        if (Arrays.binarySearch(REGEXP_META_CHARACTERS, ch) < 0) {
            builder.append(ch);
        } else {
            builder.append('\\').append(ch);
        }
    }

    private static String parseParameter(CharIterator iter, StringBuilder builder, int index) {
        StringBuilder name = new StringBuilder();
        boolean first = true;
        boolean greedy = false;
        while (iter.hasNext()) {
            char ch = iter.next();
            if (first) {
                first = false;
                if ('+' == ch) {
                    greedy = true;
                    continue;
                }
            }
            switch (ch) {
                case ':': {
                    if (greedy) {
                        throw new IllegalStateException("Parameter modifier '+' cannot be combined with custom regexp! Text: " + iter.seq.toString() + ", index: " + (iter.index() - 1));
                    }
                    String r1 = name.toString().trim();
                    PathMatchers.addParamRegexp(builder, r1.length() > 0 ? index : -1, PathMatchers.parseParamRegexp(iter));
                    return r1;
                }
                case '}': {
                    String r2 = name.toString().trim();
                    PathMatchers.addParamRegexp(builder, r2.length() > 0 ? index : -1, greedy ? ".+" : "[^/]+");
                    return r2;
                }
            }
            name.append(ch);
        }
        throw new IllegalStateException("Pattern parameter has no end character '}'! Text: " + iter.seq.toString() + ", index: " + (iter.index() - 1));
    }

    private static String parseParamRegexp(CharIterator iter) {
        StringBuilder builder = new StringBuilder();
        int subSeqCounter = 0;
        block4: while (iter.hasNext()) {
            char ch = iter.next();
            switch (ch) {
                case '{': {
                    ++subSeqCounter;
                    continue block4;
                }
                case '}': {
                    if (subSeqCounter > 0) {
                        --subSeqCounter;
                        continue block4;
                    }
                    return builder.toString();
                }
            }
            builder.append(ch);
        }
        throw new IllegalStateException("Pattern parameter has specified regexp but no end character '}'! Text: " + iter.seq.toString() + ", index: " + (iter.index() - 1));
    }

    private static void addParamRegexp(StringBuilder builder, int nameIndex, String regexp) {
        builder.append("(");
        if (nameIndex >= 0) {
            builder.append("?<").append(PARAM_PREFIX).append(nameIndex).append('>');
        }
        builder.append(regexp);
        builder.append(')');
    }

    private static String fixPrefix(String pathToMatch) {
        if (pathToMatch.isEmpty()) {
            return "/";
        }
        if (pathToMatch.charAt(0) == '/') {
            return pathToMatch;
        }
        return "/" + pathToMatch;
    }

    static {
        Arrays.sort(REGEXP_META_CHARACTERS);
    }

    static final class ExactPathMatcher
    implements PathMatcher {
        private final String path;
        private final String pathWithTrailingSlash;

        ExactPathMatcher(String path) {
            this.path = path;
            this.pathWithTrailingSlash = path + "/";
        }

        @Override
        public MatchResult match(UriPath uriPath) {
            if (this.path.equals(uriPath.rawPath())) {
                return new MatchResult(true, new NoParamRoutedPath(uriPath));
            }
            String decodedPath = uriPath.path();
            if (this.path.equals(decodedPath)) {
                return new MatchResult(true, new NoParamRoutedPath(uriPath));
            }
            return MatchResult.notAccepted();
        }

        @Override
        public PrefixMatchResult prefixMatch(UriPath uriPath) {
            if (this.path.equals("/")) {
                return new PrefixMatchResult(true, ROUTED_ROOT, uriPath);
            }
            String actualPath = uriPath.path();
            if (actualPath.startsWith(this.pathWithTrailingSlash) || actualPath.equals(this.path)) {
                String remaining = actualPath.substring(this.path.length());
                if (remaining.isEmpty()) {
                    return new PrefixMatchResult(true, new NoParamRoutedPath(uriPath), UriPath.createRelative((UriPath)uriPath, (String)"/"));
                }
                return new PrefixMatchResult(true, new NoParamRoutedPath(UriPath.createRelative((UriPath)uriPath, (String)this.path)), UriPath.createRelative((UriPath)uriPath, (String)remaining));
            }
            return PrefixMatchResult.notAccepted();
        }

        public String toString() {
            return "exact: " + this.path;
        }
    }

    static final class PrefixPathMatcher
    implements PathMatcher {
        private final String prefix;
        private final String exactMatch;

        PrefixPathMatcher(String prefix) {
            this.prefix = prefix;
            this.exactMatch = prefix.endsWith("/") ? prefix.substring(0, prefix.length() - 1) : prefix;
        }

        @Override
        public MatchResult match(UriPath uriPath) {
            String decodedPath = uriPath.path();
            if (decodedPath.startsWith(this.prefix)) {
                return new MatchResult(true, new NoParamRoutedPath(uriPath));
            }
            if (this.exactMatch.equals(decodedPath)) {
                return new MatchResult(true, new NoParamRoutedPath(uriPath));
            }
            return MatchResult.notAccepted();
        }

        @Override
        public PrefixMatchResult prefixMatch(UriPath uriPath) {
            if (this.prefix.equals("/")) {
                return new PrefixMatchResult(true, ROUTED_ROOT, uriPath);
            }
            String actualPath = uriPath.path();
            if (actualPath.startsWith(this.prefix)) {
                String remaining = actualPath.substring(this.prefix.length());
                if (remaining.isEmpty()) {
                    return new PrefixMatchResult(true, new NoParamRoutedPath(uriPath), UriPath.createRelative((UriPath)uriPath, (String)"/"));
                }
                int slash = remaining.indexOf(47);
                if (slash == -1) {
                    return new PrefixMatchResult(true, new NoParamRoutedPath(uriPath), UriPath.createRelative((UriPath)uriPath, (String)"/"));
                }
                String matchedPath = this.prefix + remaining.substring(0, slash);
                remaining = remaining.substring(slash);
                return new PrefixMatchResult(true, new NoParamRoutedPath(UriPath.createRelative((UriPath)uriPath, (String)matchedPath)), UriPath.createRelative((UriPath)uriPath, (String)remaining));
            }
            return PrefixMatchResult.notAccepted();
        }

        public String toString() {
            return "prefix: " + this.prefix;
        }
    }

    private static class CharIterator {
        private final CharSequence seq;
        private int index = 0;

        CharIterator(CharSequence seq) {
            this.seq = seq;
        }

        boolean hasNext() {
            return this.seq.length() > this.index;
        }

        char next() {
            if (this.hasNext()) {
                return this.seq.charAt(this.index++);
            }
            return '\u0000';
        }

        int index() {
            return this.index;
        }
    }

    static class PatternPathMatcher
    implements PathMatcher {
        private static final String RIGHT_PART_PARAM_NAME = "gfXdbHQlkrightpart";
        private final Map<String, String> paramToGroupName;
        private final Pattern pattern;
        private final Pattern leftPattern;
        private final String patternString;

        PatternPathMatcher(String pattern, Map<String, String> paramToGroupName) {
            this.patternString = pattern;
            this.pattern = Pattern.compile(pattern);
            this.leftPattern = Pattern.compile(pattern + "(?<gfXdbHQlkrightpart>/.+)?");
            this.paramToGroupName = paramToGroupName;
        }

        @Override
        public MatchResult match(UriPath uriPath) {
            String decodedPath = uriPath.path();
            Matcher matcher = this.pattern.matcher(decodedPath);
            if (matcher.matches()) {
                return new MatchResult(true, new ParamRoutedPath(uriPath, this.extractParams(matcher)));
            }
            return MatchResult.notAccepted();
        }

        @Override
        public PrefixMatchResult prefixMatch(UriPath uriPath) {
            String decodedPath = uriPath.path();
            Matcher matcher = this.leftPattern.matcher(decodedPath);
            if (matcher.matches()) {
                String unmatched = matcher.group(RIGHT_PART_PARAM_NAME);
                if (unmatched == null || unmatched.isEmpty()) {
                    unmatched = "/";
                }
                if (unmatched.startsWith("/")) {
                    String matched = decodedPath.substring(0, decodedPath.length() - unmatched.length());
                    return new PrefixMatchResult(true, new ParamRoutedPath(UriPath.createRelative((UriPath)uriPath, (String)matched), this.extractParams(matcher)), UriPath.createRelative((UriPath)uriPath, (String)unmatched));
                }
            }
            return PrefixMatchResult.notAccepted();
        }

        public String toString() {
            return "pattern: " + this.patternString;
        }

        private Parameters extractParams(Matcher matcher) {
            HashMap<String, String> params = new HashMap<String, String>(this.paramToGroupName.size());
            for (Map.Entry<String, String> entry : this.paramToGroupName.entrySet()) {
                String paramValue = matcher.group(entry.getValue());
                if (paramValue == null) continue;
                params.put(entry.getKey(), paramValue);
            }
            return Parameters.createSingleValueMap((String)"http/path", params);
        }
    }

    static class AnyMatcher
    implements PathMatcher {
        AnyMatcher() {
        }

        @Override
        public MatchResult match(UriPath uriPath) {
            return new MatchResult(true, new NoParamRoutedPath(uriPath));
        }

        @Override
        public PrefixMatchResult prefixMatch(UriPath uriPath) {
            return new PrefixMatchResult(true, new NoParamRoutedPath(UriPath.create((String)"")), uriPath);
        }

        public String toString() {
            return "any path";
        }
    }

    private static class NoParamRoutedPath
    implements RoutedPath,
    Supplier<RoutedPath> {
        private static final Parameters EMPTY_PARAMS = Parameters.empty((String)"http/path");
        private final UriPath path;

        NoParamRoutedPath(UriPath path) {
            this.path = path;
        }

        public String rawPath() {
            return this.path.rawPath();
        }

        public String rawPathNoParams() {
            return this.path.rawPathNoParams();
        }

        public String path() {
            return this.path.path();
        }

        public Parameters matrixParameters() {
            return this.path.matrixParameters();
        }

        public void validate() {
            this.path.validate();
        }

        @Override
        public Parameters pathParameters() {
            return EMPTY_PARAMS;
        }

        @Override
        public RoutedPath absolute() {
            return new NoParamRoutedPath(this.path.absolute());
        }

        @Override
        public RoutedPath get() {
            return this;
        }

        public String toString() {
            return this.path.toString();
        }
    }

    public record MatchResult(boolean accepted, RoutedPath path) {
        private static final MatchResult NOT_ACCEPTED = new MatchResult(false, null);

        public static MatchResult notAccepted() {
            return NOT_ACCEPTED;
        }
    }

    public record PrefixMatchResult(boolean accepted, RoutedPath matchedPath, UriPath unmatchedPath) {
        private static final PrefixMatchResult NOT_ACCEPTED = new PrefixMatchResult(false, null, null);

        public static PrefixMatchResult notAccepted() {
            return NOT_ACCEPTED;
        }
    }

    private static class ParamRoutedPath
    extends NoParamRoutedPath {
        private final UriPath path;
        private final Parameters pathTemplateParams;

        private ParamRoutedPath(UriPath path, Parameters pathTemplateParams) {
            super(path);
            this.path = path;
            this.pathTemplateParams = pathTemplateParams;
        }

        @Override
        public Parameters pathParameters() {
            return this.pathTemplateParams;
        }

        @Override
        public RoutedPath absolute() {
            return new ParamRoutedPath(this.path.absolute(), this.pathTemplateParams);
        }

        @Override
        public String toString() {
            return String.valueOf(this.path) + " (" + String.valueOf(this.pathTemplateParams) + ")";
        }
    }
}

