/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.parameters.Parameters;
import io.helidon.http.Header;
import io.helidon.http.HeaderHelper;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.Headers;
import io.helidon.http.HttpMediaType;
import io.helidon.http.ServerRequestHeaders;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

class ServerRequestHeadersImpl
implements ServerRequestHeaders {
    private final Headers headers;
    private List<HttpMediaType> cachedAccepted;
    private Parameters cacheCookies;
    private Optional<HttpMediaType> cacheContentType;

    ServerRequestHeadersImpl(Headers headers) {
        this.headers = headers;
    }

    @Override
    public List<String> all(HeaderName name, Supplier<List<String>> defaultSupplier) {
        return this.headers.all(name, defaultSupplier);
    }

    @Override
    public boolean contains(HeaderName name) {
        return this.headers.contains(name);
    }

    @Override
    public boolean contains(Header headerWithValue) {
        return this.headers.contains(headerWithValue);
    }

    @Override
    public Header get(HeaderName name) {
        return this.headers.get(name);
    }

    @Override
    public Optional<HttpMediaType> contentType() {
        if (this.cacheContentType == null) {
            this.cacheContentType = ServerRequestHeaders.super.contentType();
        }
        return this.cacheContentType;
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public List<HttpMediaType> acceptedTypes() {
        List<HttpMediaType> acceptedTypes;
        if (this.cachedAccepted != null) {
            return this.cachedAccepted;
        }
        List<String> acceptValues = this.all(HeaderNames.ACCEPT, List::of);
        if (acceptValues.size() == 1 && HUC_ACCEPT_DEFAULT.value().equals(acceptValues.get(0))) {
            acceptedTypes = HUC_ACCEPT_DEFAULT_TYPES;
        } else {
            acceptedTypes = new ArrayList(5);
            for (String acceptValue : acceptValues) {
                List<String> tokenized = HeaderHelper.tokenize(',', acceptValue);
                for (String token : tokenized) {
                    acceptedTypes.add(HttpMediaType.create(token.trim()));
                }
            }
            Collections.sort(acceptedTypes);
        }
        this.cachedAccepted = acceptedTypes;
        return this.cachedAccepted;
    }

    @Override
    public Iterator<Header> iterator() {
        return this.headers.iterator();
    }

    public String toString() {
        return this.headers.toString();
    }

    @Override
    public Parameters cookies() {
        if (this.cacheCookies == null) {
            this.cacheCookies = ServerRequestHeaders.super.cookies();
        }
        return this.cacheCookies;
    }
}

