/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.buffers.DataReader;
import io.helidon.common.buffers.LazyString;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNameEnum;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.WritableHeaders;
import java.nio.charset.StandardCharsets;

public final class Http1HeadersParser {
    private static final byte[] HD_HOST = (HeaderNameEnum.HOST.defaultCase() + ":").getBytes(StandardCharsets.UTF_8);
    private static final byte[] HD_ACCEPT = (HeaderNameEnum.ACCEPT.defaultCase() + ":").getBytes(StandardCharsets.UTF_8);
    private static final byte[] HD_CONNECTION = (HeaderNameEnum.CONNECTION.defaultCase() + ":").getBytes(StandardCharsets.UTF_8);
    private static final byte[] HD_USER_AGENT = (HeaderNameEnum.USER_AGENT.defaultCase() + ":").getBytes(StandardCharsets.UTF_8);

    private Http1HeadersParser() {
    }

    public static WritableHeaders<?> readHeaders(DataReader reader, int maxHeadersSize, boolean validate) {
        WritableHeaders<?> headers = WritableHeaders.create();
        int maxLength = maxHeadersSize;
        do {
            HeaderName header;
            int eol;
            if (reader.startsWithNewLine()) {
                reader.skip(2);
                return headers;
            }
            if ((eol = reader.findNewLine(maxLength -= (header = Http1HeadersParser.readHeaderName(reader, maxLength, validate)).defaultCase().length() + 2)) == maxLength) {
                throw new IllegalStateException("Header size exceeded");
            }
            LazyString value = reader.readLazyString(StandardCharsets.US_ASCII, eol);
            reader.skip(2);
            maxLength -= eol + 1;
            Header headerValue = HeaderValues.create(header, value);
            headers.add(headerValue);
            if (!validate) continue;
            headerValue.validate();
        } while (maxLength >= 0);
        throw new IllegalStateException("Header size exceeded");
    }

    private static HeaderName readHeaderName(DataReader reader, int maxLength, boolean validate) {
        switch (reader.lookup()) {
            case 72: {
                if (!reader.startsWith(HD_HOST)) break;
                reader.skip(HD_HOST.length);
                return HeaderNameEnum.HOST;
            }
            case 65: {
                if (!reader.startsWith(HD_ACCEPT)) break;
                reader.skip(HD_ACCEPT.length);
                return HeaderNameEnum.ACCEPT;
            }
            case 67: {
                if (!reader.startsWith(HD_CONNECTION)) break;
                reader.skip(HD_CONNECTION.length);
                return HeaderNameEnum.CONNECTION;
            }
            case 85: {
                if (!reader.startsWith(HD_USER_AGENT)) break;
                reader.skip(HD_USER_AGENT.length);
                return HeaderNameEnum.USER_AGENT;
            }
        }
        int col = reader.findOrNewLine((byte)58, maxLength);
        if (col == maxLength) {
            throw new IllegalStateException("Header size exceeded");
        }
        if (col < 0) {
            throw new IllegalArgumentException("Invalid header, missing colon:\n" + reader.debugDataHex());
        }
        String headerName = reader.readAsciiString(col);
        HeaderName header = HeaderNames.create(headerName);
        reader.skip(1);
        return header;
    }
}

