/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.http.HtmlEncoder;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HostValidator {
    private static final Pattern IP_V4_PATTERN;
    private static final boolean[] HEXDIGIT;
    private static final boolean[] UNRESERVED;
    private static final boolean[] SUB_DELIMS;

    private HostValidator() {
    }

    public static void validate(String host) {
        Objects.requireNonNull(host);
        if (host.indexOf(91) == 0 && host.indexOf(93) == host.length() - 1) {
            HostValidator.validateIpLiteral(host);
        } else {
            HostValidator.validateNonIpLiteral(host);
        }
    }

    public static void validateIpLiteral(String ipLiteral) {
        Objects.requireNonNull(ipLiteral);
        HostValidator.checkNotBlank("IP Literal", ipLiteral, ipLiteral);
        if (ipLiteral.charAt(0) != '[' || ipLiteral.charAt(ipLiteral.length() - 1) != ']') {
            throw new IllegalArgumentException("Invalid IP literal, missing square bracket(s): " + HtmlEncoder.encode(ipLiteral));
        }
        String host = ipLiteral.substring(1, ipLiteral.length() - 1);
        HostValidator.checkNotBlank("Host", ipLiteral, host);
        if (host.charAt(0) == 'v') {
            HostValidator.validateIpFuture(ipLiteral, host);
            return;
        }
        if (host.equals("::")) {
            return;
        }
        if (host.equals("::1")) {
            return;
        }
        boolean skipped = false;
        int segments = 0;
        String inProgress = host;
        while (!inProgress.isEmpty()) {
            if (inProgress.length() == 1) {
                ++segments;
                HostValidator.validateH16(ipLiteral, inProgress);
                break;
            }
            if (inProgress.charAt(0) == ':' && inProgress.charAt(1) == ':') {
                if (skipped) {
                    throw new IllegalArgumentException("Host IPv6 contains more than one skipped segment: " + HtmlEncoder.encode(ipLiteral));
                }
                skipped = true;
                ++segments;
                inProgress = inProgress.substring(2);
                continue;
            }
            if (inProgress.charAt(0) == ':') {
                throw new IllegalArgumentException("Host IPv6 contains excessive colon: " + HtmlEncoder.encode(ipLiteral));
            }
            int nextColon = inProgress.indexOf(58);
            if (nextColon == -1) {
                if (inProgress.indexOf(46) == -1) {
                    ++segments;
                    HostValidator.validateH16(ipLiteral, inProgress);
                    break;
                }
                Matcher matcher = IP_V4_PATTERN.matcher(inProgress);
                if (matcher.matches()) {
                    HostValidator.validateIpOctet("Host IPv6 dual address contains invalid IPv4 address:", ipLiteral, matcher.group(1));
                    HostValidator.validateIpOctet("Host IPv6 dual address contains invalid IPv4 address:", ipLiteral, matcher.group(2));
                    HostValidator.validateIpOctet("Host IPv6 dual address contains invalid IPv4 address:", ipLiteral, matcher.group(3));
                    HostValidator.validateIpOctet("Host IPv6 dual address contains invalid IPv4 address:", ipLiteral, matcher.group(4));
                    break;
                }
                throw new IllegalArgumentException("Host IPv6 dual address contains invalid IPv4 address: " + HtmlEncoder.encode(ipLiteral));
            }
            HostValidator.validateH16(ipLiteral, inProgress.substring(0, nextColon));
            ++segments;
            if (inProgress.length() >= nextColon + 2 && inProgress.charAt(nextColon + 1) == ':') {
                inProgress = inProgress.substring(nextColon);
                continue;
            }
            if (!(inProgress = inProgress.substring(nextColon + 1)).isBlank()) continue;
            HostValidator.validateH16(ipLiteral, inProgress);
        }
        if (segments > 8) {
            throw new IllegalArgumentException("Host IPv6 address contains too many segments: " + HtmlEncoder.encode(ipLiteral));
        }
    }

    public static void validateNonIpLiteral(String host) {
        Objects.requireNonNull(host);
        HostValidator.checkNotBlank("Host", host, host);
        Matcher matcher = IP_V4_PATTERN.matcher(host);
        if (matcher.matches()) {
            return;
        }
        char[] charArray = host.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c > '\u00ff') {
                throw new IllegalArgumentException("Host contains invalid character: " + HtmlEncoder.encode(host));
            }
            if (UNRESERVED[c] || SUB_DELIMS[c]) continue;
            if (c == '%') {
                if (i + 2 >= charArray.length) {
                    throw new IllegalArgumentException("Host contains invalid % encoding: " + HtmlEncoder.encode(host));
                }
                char p1 = charArray[++i];
                char p2 = charArray[++i];
                if (p1 > '\u00ff' || p2 > '\u00ff') {
                    throw new IllegalArgumentException("Host contains invalid character in % encoding: " + HtmlEncoder.encode(host));
                }
                if (HEXDIGIT[p1] && HEXDIGIT[p2]) continue;
                throw new IllegalArgumentException("Host contains non-hexadecimal character in % encoding: " + HtmlEncoder.encode(host));
            }
            throw new IllegalArgumentException("Host contains invalid character: " + HtmlEncoder.encode(host));
        }
    }

    private static void validateH16(String host, String inProgress) {
        if (inProgress.isBlank()) {
            throw new IllegalArgumentException("IPv6 segment is empty: " + HtmlEncoder.encode(host));
        }
        if (inProgress.length() > 4) {
            throw new IllegalArgumentException("IPv6 segment has more than 4 characters: " + HtmlEncoder.encode(host));
        }
        HostValidator.validateHexDigits("IPv6 segment", host, inProgress);
    }

    private static void validateHexDigits(String description, String host, String segment) {
        for (char c : segment.toCharArray()) {
            if (c > '\u00ff') {
                throw new IllegalArgumentException(description + " non hexadecimal character: " + HtmlEncoder.encode(host));
            }
            if (HEXDIGIT[c]) continue;
            throw new IllegalArgumentException(description + " non hexadecimal character: " + HtmlEncoder.encode(host));
        }
    }

    private static void validateIpOctet(String message, String host, String octet) {
        int octetInt = Integer.parseInt(octet);
        if (octetInt > 255) {
            throw new IllegalArgumentException(message + " " + HtmlEncoder.encode(host));
        }
    }

    private static void validateIpFuture(String ipLiteral, String host) {
        int dot = host.indexOf(46);
        if (dot == -1) {
            throw new IllegalArgumentException("IP Future must contain 'v<version>.': " + HtmlEncoder.encode(ipLiteral));
        }
        String version = host.substring(1, dot);
        HostValidator.checkNotBlank("Version", ipLiteral, version);
        HostValidator.validateHexDigits("Future version", ipLiteral, version);
        String address = host.substring(dot + 1);
        HostValidator.checkNotBlank("IP Future", ipLiteral, address);
        for (char c : address.toCharArray()) {
            if (c > '\u00ff') {
                throw new IllegalArgumentException("Host contains invalid character: " + HtmlEncoder.encode(ipLiteral));
            }
            if (UNRESERVED[c] || SUB_DELIMS[c] || c == ':') continue;
            throw new IllegalArgumentException("Host contains invalid character: " + HtmlEncoder.encode(ipLiteral));
        }
    }

    private static void checkNotBlank(String message, String ipLiteral, String toValidate) {
        if (toValidate.isBlank()) {
            throw new IllegalArgumentException(message + " cannot be blank: " + HtmlEncoder.encode(ipLiteral));
        }
    }

    static {
        int i;
        IP_V4_PATTERN = Pattern.compile("^([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})$");
        HEXDIGIT = new boolean[256];
        UNRESERVED = new boolean[256];
        SUB_DELIMS = new boolean[256];
        for (i = 48; i <= 57; ++i) {
            HostValidator.UNRESERVED[i] = true;
        }
        for (i = 97; i <= 122; ++i) {
            HostValidator.UNRESERVED[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            HostValidator.UNRESERVED[i] = true;
        }
        HostValidator.UNRESERVED[45] = true;
        HostValidator.UNRESERVED[46] = true;
        HostValidator.UNRESERVED[95] = true;
        HostValidator.UNRESERVED[126] = true;
        for (i = 48; i <= 57; ++i) {
            HostValidator.HEXDIGIT[i] = true;
        }
        for (i = 97; i <= 102; ++i) {
            HostValidator.HEXDIGIT[i] = true;
        }
        for (i = 65; i <= 70; ++i) {
            HostValidator.HEXDIGIT[i] = true;
        }
        HostValidator.SUB_DELIMS[33] = true;
        HostValidator.SUB_DELIMS[36] = true;
        HostValidator.SUB_DELIMS[38] = true;
        HostValidator.SUB_DELIMS[39] = true;
        HostValidator.SUB_DELIMS[40] = true;
        HostValidator.SUB_DELIMS[41] = true;
        HostValidator.SUB_DELIMS[42] = true;
        HostValidator.SUB_DELIMS[43] = true;
        HostValidator.SUB_DELIMS[44] = true;
        HostValidator.SUB_DELIMS[59] = true;
        HostValidator.SUB_DELIMS[61] = true;
    }
}

