/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.http.Status;
import java.util.ArrayList;
import java.util.List;

final class StatusHelper {
    private static final List<Status> KNOWN = new ArrayList<Status>(40);
    private static StatusPair[] statuses;

    private StatusHelper() {
    }

    static Status find(int statusCode) {
        for (StatusPair status : statuses) {
            if (status.code != statusCode) continue;
            return status.status;
        }
        return null;
    }

    static void add(Status status) {
        KNOWN.add(status);
    }

    static void statusesDone() {
        statuses = new StatusPair[KNOWN.size()];
        for (int i = 0; i < KNOWN.size(); ++i) {
            StatusHelper.statuses[i] = StatusPair.create(KNOWN.get(i));
        }
        KNOWN.clear();
    }

    private record StatusPair(int code, Status status) {
        public static StatusPair create(Status status) {
            return new StatusPair(status.code(), status);
        }
    }
}

