/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.media.type.MediaType;
import io.helidon.http.HttpMediaType;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

final class HttpMediaTypeImpl
implements HttpMediaType {
    private final Map<String, String> parameters = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final MediaType mediaType;
    private double q = -1.0;

    HttpMediaTypeImpl(HttpMediaType.Builder builder) {
        this.parameters.putAll(builder.parameters());
        this.mediaType = builder.mediaType();
    }

    @Override
    public int compareTo(HttpMediaType o) {
        int compared = Double.compare(o.qualityFactor(), this.qualityFactor());
        if (compared == 0) {
            if (this.mediaType.isWildcardSubtype() && !o.mediaType().isWildcardSubtype()) {
                return 1;
            }
            if (this.mediaType.isWildcardType() && !o.mediaType().isWildcardType()) {
                return 1;
            }
            if (o.mediaType().isWildcardSubtype() && !this.mediaType.isWildcardSubtype()) {
                return -1;
            }
            if (o.mediaType().isWildcardType() && !this.mediaType.isWildcardType()) {
                return -1;
            }
            return 0;
        }
        return compared;
    }

    @Override
    public MediaType mediaType() {
        return this.mediaType;
    }

    @Override
    public double qualityFactor() {
        if (this.q == -1.0) {
            String q = this.parameters.get("q");
            this.q = q == null ? 1.0 : Double.parseDouble(q);
        }
        return this.q;
    }

    @Override
    public Map<String, String> parameters() {
        return Map.copyOf(this.parameters);
    }

    @Override
    public boolean test(HttpMediaType other) {
        if (this.mediaType == null) {
            return false;
        }
        if (this.typeMismatch(other)) {
            return false;
        }
        return !this.subtypeMismatch(other);
    }

    @Override
    public boolean test(MediaType mediaType) {
        if (mediaType == null) {
            return false;
        }
        if (this.typeMismatch(mediaType)) {
            return false;
        }
        return !this.subtypeMismatch(mediaType);
    }

    @Override
    public String text() {
        StringBuilder result = new StringBuilder(this.mediaType.text());
        for (Map.Entry<String, String> param : this.parameters.entrySet()) {
            result.append("; ").append(param.getKey()).append('=').append(param.getValue());
        }
        return result.toString();
    }

    public int hashCode() {
        return Objects.hash(this.parameters, this.mediaType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpMediaTypeImpl)) {
            return false;
        }
        HttpMediaTypeImpl that = (HttpMediaTypeImpl)o;
        return this.parameters.equals(that.parameters) && this.mediaType.equals((Object)that.mediaType);
    }

    public String toString() {
        return this.text();
    }

    private boolean subtypeMismatch(MediaType other) {
        if (this.mediaType.isWildcardSubtype() || other.isWildcardSubtype()) {
            return false;
        }
        return !this.mediaType.subtype().equalsIgnoreCase(other.subtype());
    }

    private boolean typeMismatch(MediaType other) {
        if (this.mediaType.isWildcardType() || other.isWildcardType()) {
            return false;
        }
        return !this.mediaType.type().equalsIgnoreCase(other.type());
    }
}

