/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.media.jsonb;

import io.helidon.builder.api.Prototype;
import io.helidon.builder.api.RuntimeType;
import io.helidon.common.GenericType;
import io.helidon.common.config.Config;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.HttpMediaType;
import io.helidon.http.WritableHeaders;
import io.helidon.http.media.EntityReader;
import io.helidon.http.media.EntityWriter;
import io.helidon.http.media.MediaSupport;
import io.helidon.http.media.jsonb.JsonbReader;
import io.helidon.http.media.jsonb.JsonbSupportConfig;
import io.helidon.http.media.jsonb.JsonbWriter;
import jakarta.json.JsonObject;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=JsonbSupportConfig.class)
public class JsonbSupport
implements MediaSupport,
RuntimeType.Api<JsonbSupportConfig> {
    private static final GenericType<JsonObject> JSON_OBJECT_TYPE = GenericType.create(JsonObject.class);
    private static final String DEFAULT_JSON_B_NAME = "jsonb";
    private static final Jsonb JSON_B = JsonbBuilder.create();
    private final JsonbReader reader;
    private final JsonbWriter writer;
    private final JsonbSupportConfig jsonbSupportConfig;
    private final String name;

    private JsonbSupport(JsonbSupportConfig jsonbSupportConfig) {
        this.jsonbSupportConfig = jsonbSupportConfig;
        this.reader = new JsonbReader(jsonbSupportConfig.jsonb());
        this.writer = new JsonbWriter(jsonbSupportConfig.jsonb());
        this.name = jsonbSupportConfig.name();
    }

    public static MediaSupport create() {
        return JsonbSupport.builder().build();
    }

    public static MediaSupport create(Config config) {
        return JsonbSupport.create(config, DEFAULT_JSON_B_NAME);
    }

    public static MediaSupport create(Config config, String name) {
        return ((JsonbSupportConfig.Builder)((JsonbSupportConfig.Builder)JsonbSupport.builder().name(name)).config(config)).build();
    }

    public static MediaSupport create(Jsonb jsonb) {
        return ((JsonbSupportConfig.Builder)JsonbSupport.builder().jsonb(jsonb)).build();
    }

    public static JsonbSupport create(JsonbSupportConfig jsonbSupportConfig) {
        Objects.requireNonNull(jsonbSupportConfig);
        return new JsonbSupport(jsonbSupportConfig);
    }

    public static JsonbSupport create(Consumer<JsonbSupportConfig.Builder> consumer) {
        return ((JsonbSupportConfig.Builder)JsonbSupport.builder().update(consumer)).build();
    }

    public static JsonbSupportConfig.Builder builder() {
        return JsonbSupportConfig.builder();
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return DEFAULT_JSON_B_NAME;
    }

    public <T> MediaSupport.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders) {
        if (requestHeaders.contentType().map(it -> it.test(MediaTypes.APPLICATION_JSON)).orElse(true).booleanValue()) {
            if (type.equals(JSON_OBJECT_TYPE)) {
                return MediaSupport.ReaderResponse.unsupported();
            }
            return new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.COMPATIBLE, this::reader);
        }
        return MediaSupport.ReaderResponse.unsupported();
    }

    public <T> MediaSupport.WriterResponse<T> writer(GenericType<T> type, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
        if (JSON_OBJECT_TYPE.equals(type)) {
            return MediaSupport.WriterResponse.unsupported();
        }
        for (HttpMediaType acceptedType : requestHeaders.acceptedTypes()) {
            if (!acceptedType.test(MediaTypes.APPLICATION_JSON)) continue;
            return new MediaSupport.WriterResponse(MediaSupport.SupportLevel.COMPATIBLE, this::writer);
        }
        if (requestHeaders.acceptedTypes().isEmpty()) {
            return new MediaSupport.WriterResponse(MediaSupport.SupportLevel.COMPATIBLE, this::writer);
        }
        return MediaSupport.WriterResponse.unsupported();
    }

    public <T> MediaSupport.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders, Headers responseHeaders) {
        if (JSON_OBJECT_TYPE.equals(type)) {
            return MediaSupport.ReaderResponse.unsupported();
        }
        for (HttpMediaType acceptedType : requestHeaders.acceptedTypes()) {
            if (!acceptedType.test(MediaTypes.APPLICATION_JSON) && !acceptedType.mediaType().isWildcardType()) continue;
            return new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.COMPATIBLE, this::reader);
        }
        if (requestHeaders.acceptedTypes().isEmpty()) {
            return new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.COMPATIBLE, this::reader);
        }
        return MediaSupport.ReaderResponse.unsupported();
    }

    public <T> MediaSupport.WriterResponse<T> writer(GenericType<T> type, WritableHeaders<?> requestHeaders) {
        if (type.equals(JSON_OBJECT_TYPE)) {
            return MediaSupport.WriterResponse.unsupported();
        }
        if (requestHeaders.contains(HeaderNames.CONTENT_TYPE)) {
            if (requestHeaders.contains(HeaderValues.CONTENT_TYPE_JSON)) {
                return new MediaSupport.WriterResponse(MediaSupport.SupportLevel.COMPATIBLE, this::writer);
            }
        } else {
            return new MediaSupport.WriterResponse(MediaSupport.SupportLevel.SUPPORTED, this::writer);
        }
        return MediaSupport.WriterResponse.unsupported();
    }

    <T> EntityReader<T> reader() {
        return this.reader;
    }

    <T> EntityWriter<T> writer() {
        return this.writer;
    }

    public JsonbSupportConfig prototype() {
        return this.jsonbSupportConfig;
    }

    static class Decorator
    implements Prototype.BuilderDecorator<JsonbSupportConfig.BuilderBase<?, ?>> {
        Decorator() {
        }

        public void decorate(JsonbSupportConfig.BuilderBase<?, ?> target) {
            Map<String, Object> properties = target.properties();
            target.stringProperties().forEach(properties::putIfAbsent);
            target.booleanProperties().forEach(properties::putIfAbsent);
            target.classProperties().forEach(properties::putIfAbsent);
            if (target.jsonb().isEmpty()) {
                if (properties.isEmpty()) {
                    target.jsonb(JSON_B);
                } else {
                    JsonbConfig jsonbConfig = new JsonbConfig();
                    properties.forEach((arg_0, arg_1) -> ((JsonbConfig)jsonbConfig).setProperty(arg_0, arg_1));
                    target.jsonb(JsonbBuilder.create((JsonbConfig)jsonbConfig));
                }
            }
        }
    }
}

