/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.media.jsonb;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.http.media.jsonb.JsonbSupport;
import io.helidon.http.media.jsonb.JsonbSupportConfigBlueprint;
import jakarta.json.bind.Jsonb;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.http.media.jsonb.JsonbSupportConfigBlueprint")
public interface JsonbSupportConfig
extends JsonbSupportConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(JsonbSupportConfig instance) {
        return (Builder)JsonbSupportConfig.builder().from(instance);
    }

    public static JsonbSupportConfig create(Config config) {
        return ((Builder)JsonbSupportConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static JsonbSupportConfig create(io.helidon.common.config.Config config) {
        return JsonbSupportConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static JsonbSupportConfig create() {
        return JsonbSupportConfig.builder().buildPrototype();
    }

    @Override
    public String name();

    @Override
    public Jsonb jsonb();

    @Override
    public Map<String, String> stringProperties();

    @Override
    public Map<String, Boolean> booleanProperties();

    @Override
    public Map<String, Class<?>> classProperties();

    @Override
    public Map<String, Object> properties();

    public static class Builder
    extends BuilderBase<Builder, JsonbSupportConfig>
    implements io.helidon.common.Builder<Builder, JsonbSupport> {
        private Builder() {
        }

        public JsonbSupportConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.JsonbSupportConfigImpl(this);
        }

        public JsonbSupport build() {
            return JsonbSupport.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends JsonbSupportConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final Map<String, Boolean> booleanProperties = new LinkedHashMap<String, Boolean>();
        private final Map<String, Class<?>> classProperties = new LinkedHashMap();
        private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
        private final Map<String, String> stringProperties = new LinkedHashMap<String, String>();
        private Config config;
        private Jsonb jsonb;
        private String name = "jsonb";

        protected BuilderBase() {
        }

        public BUILDER from(JsonbSupportConfig prototype) {
            this.name(prototype.name());
            this.jsonb(prototype.jsonb());
            this.addStringProperties(prototype.stringProperties());
            this.addBooleanProperties(prototype.booleanProperties());
            this.addClassProperties(prototype.classProperties());
            this.addProperties(prototype.properties());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.name(builder.name());
            builder.jsonb().ifPresent(this::jsonb);
            this.addStringProperties(builder.stringProperties);
            this.addBooleanProperties(builder.booleanProperties);
            this.addClassProperties(builder.classProperties);
            this.addProperties(builder.properties);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("name").as(String.class).ifPresent(this::name);
            config.get("properties").detach().asMap().ifPresent(this::stringProperties);
            config.get("boolean-properties").detach().traverse().filter(io.helidon.common.config.Config::hasValue).forEach(node -> this.booleanProperties.put((String)node.get("name").asString().orElse((Object)node.key().toString()), (Boolean)node.as(Boolean.class).get()));
            config.get("class-properties").detach().traverse().filter(io.helidon.common.config.Config::hasValue).forEach(node -> this.classProperties.put((String)node.get("name").asString().orElse((Object)node.key().toString()), (Class)node.as(Class.class).get()));
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER jsonb(Jsonb jsonb) {
            Objects.requireNonNull(jsonb);
            this.jsonb = jsonb;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER properties(Map<String, ?> properties) {
            Objects.requireNonNull(properties);
            this.properties.clear();
            this.properties.putAll(properties);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addProperties(Map<String, ?> properties) {
            Objects.requireNonNull(properties);
            this.properties.putAll(properties);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putProperty(String key, Object property) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(property);
            this.properties.put(key, property);
            return (BUILDER)((BuilderBase)this.self());
        }

        public String name() {
            return this.name;
        }

        public Optional<Jsonb> jsonb() {
            return Optional.ofNullable(this.jsonb);
        }

        public Map<String, Object> properties() {
            return this.properties;
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "JsonbSupportConfigBuilder{name=" + this.name + ",jsonb=" + String.valueOf(this.jsonb) + ",stringProperties=" + String.valueOf(this.stringProperties) + ",booleanProperties=" + String.valueOf(this.booleanProperties) + ",classProperties=" + String.valueOf(this.classProperties) + ",properties=" + String.valueOf(this.properties) + "}";
        }

        protected void preBuildPrototype() {
            new JsonbSupport.Decorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.jsonb == null) {
                collector.fatal(this.getClass(), "Property \"jsonb\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER stringProperties(Map<String, String> stringProperties) {
            Objects.requireNonNull(stringProperties);
            this.stringProperties.clear();
            this.stringProperties.putAll(stringProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER addStringProperties(Map<String, String> stringProperties) {
            Objects.requireNonNull(stringProperties);
            this.stringProperties.putAll(stringProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER booleanProperties(Map<String, Boolean> booleanProperties) {
            Objects.requireNonNull(booleanProperties);
            this.booleanProperties.clear();
            this.booleanProperties.putAll(booleanProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER addBooleanProperties(Map<String, Boolean> booleanProperties) {
            Objects.requireNonNull(booleanProperties);
            this.booleanProperties.putAll(booleanProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER classProperties(Map<String, Class<?>> classProperties) {
            Objects.requireNonNull(classProperties);
            this.classProperties.clear();
            this.classProperties.putAll(classProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER addClassProperties(Map<String, Class<?>> classProperties) {
            Objects.requireNonNull(classProperties);
            this.classProperties.putAll(classProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        Map<String, String> stringProperties() {
            return this.stringProperties;
        }

        Map<String, Boolean> booleanProperties() {
            return this.booleanProperties;
        }

        Map<String, Class<?>> classProperties() {
            return this.classProperties;
        }

        protected static class JsonbSupportConfigImpl
        implements JsonbSupportConfig,
        Supplier<JsonbSupport> {
            private final Jsonb jsonb;
            private final Map<String, Boolean> booleanProperties;
            private final Map<String, Class<?>> classProperties;
            private final Map<String, Object> properties;
            private final Map<String, String> stringProperties;
            private final String name;

            protected JsonbSupportConfigImpl(BuilderBase<?, ?> builder) {
                this.name = builder.name();
                this.jsonb = builder.jsonb().get();
                this.stringProperties = Collections.unmodifiableMap(new LinkedHashMap<String, String>(builder.stringProperties()));
                this.booleanProperties = Collections.unmodifiableMap(new LinkedHashMap<String, Boolean>(builder.booleanProperties()));
                this.classProperties = Collections.unmodifiableMap(new LinkedHashMap(builder.classProperties()));
                this.properties = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(builder.properties()));
            }

            public JsonbSupport build() {
                return JsonbSupport.create(this);
            }

            @Override
            public JsonbSupport get() {
                return this.build();
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public Jsonb jsonb() {
                return this.jsonb;
            }

            @Override
            public Map<String, String> stringProperties() {
                return this.stringProperties;
            }

            @Override
            public Map<String, Boolean> booleanProperties() {
                return this.booleanProperties;
            }

            @Override
            public Map<String, Class<?>> classProperties() {
                return this.classProperties;
            }

            @Override
            public Map<String, Object> properties() {
                return this.properties;
            }

            public String toString() {
                return "JsonbSupportConfig{name=" + this.name + ",jsonb=" + String.valueOf(this.jsonb) + ",stringProperties=" + String.valueOf(this.stringProperties) + ",booleanProperties=" + String.valueOf(this.booleanProperties) + ",classProperties=" + String.valueOf(this.classProperties) + ",properties=" + String.valueOf(this.properties) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof JsonbSupportConfig)) {
                    return false;
                }
                JsonbSupportConfig other = (JsonbSupportConfig)o;
                return Objects.equals(this.name, other.name()) && Objects.equals(this.jsonb, other.jsonb()) && Objects.equals(this.stringProperties, other.stringProperties()) && Objects.equals(this.booleanProperties, other.booleanProperties()) && Objects.equals(this.classProperties, other.classProperties()) && Objects.equals(this.properties, other.properties());
            }

            public int hashCode() {
                return Objects.hash(this.name, this.jsonb, this.stringProperties, this.booleanProperties, this.classProperties, this.properties);
            }
        }
    }
}

