/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.media.jsonb;

import io.helidon.common.GenericType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.HttpMediaType;
import io.helidon.http.WritableHeaders;
import io.helidon.http.media.EntityWriter;
import jakarta.json.bind.Jsonb;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Optional;

class JsonbWriter<T>
implements EntityWriter<T> {
    private final Jsonb jsonb;

    JsonbWriter(Jsonb jsonb) {
        this.jsonb = jsonb;
    }

    public void write(GenericType<T> type, T object, OutputStream outputStream, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
        responseHeaders.setIfAbsent(HeaderValues.CONTENT_TYPE_JSON);
        for (HttpMediaType acceptedType : requestHeaders.acceptedTypes()) {
            if (!acceptedType.test(MediaTypes.APPLICATION_JSON)) continue;
            Optional charset = acceptedType.charset();
            if (charset.isPresent()) {
                Charset characterSet = Charset.forName((String)charset.get());
                this.write(type, object, new OutputStreamWriter(outputStream, characterSet));
            } else {
                this.write(type, object, outputStream);
            }
            return;
        }
        this.write(type, object, outputStream);
    }

    public void write(GenericType<T> type, T object, OutputStream outputStream, WritableHeaders<?> headers) {
        headers.setIfAbsent(HeaderValues.CONTENT_TYPE_JSON);
        this.write(type, object, outputStream);
    }

    private void write(GenericType<T> type, T object, Writer out) {
        this.jsonb.toJson(object, type.type(), out);
        try {
            out.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void write(GenericType<T> type, T object, OutputStream out) {
        try (OutputStream outputStream = out;){
            this.jsonb.toJson(object, type.type(), out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

