/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.media.jsonp;

import io.helidon.builder.api.Prototype;
import io.helidon.builder.api.RuntimeType;
import io.helidon.common.GenericType;
import io.helidon.common.config.Config;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.http.Headers;
import io.helidon.http.HttpMediaType;
import io.helidon.http.WritableHeaders;
import io.helidon.http.media.EntityReader;
import io.helidon.http.media.EntityWriter;
import io.helidon.http.media.MediaSupport;
import io.helidon.http.media.jsonp.JsonpReader;
import io.helidon.http.media.jsonp.JsonpSupportConfig;
import io.helidon.http.media.jsonp.JsonpWriter;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonStructure;
import jakarta.json.JsonWriterFactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=JsonpSupportConfig.class)
public class JsonpSupport
implements MediaSupport,
RuntimeType.Api<JsonpSupportConfig> {
    public static final GenericType<JsonObject> JSON_OBJECT_TYPE = GenericType.create(JsonObject.class);
    public static final GenericType<JsonArray> JSON_ARRAY_TYPE = GenericType.create(JsonArray.class);
    private static final JsonReaderFactory READER_FACTORY = Json.createReaderFactory(Map.of());
    private static final JsonWriterFactory WRITER_FACTORY = Json.createWriterFactory(Map.of());
    private final JsonpReader reader;
    private final JsonpWriter writer;
    private final String name;
    private final JsonpSupportConfig jsonpSupportConfig;

    private JsonpSupport(JsonpSupportConfig jsonpSupportConfig) {
        this.jsonpSupportConfig = jsonpSupportConfig;
        this.name = jsonpSupportConfig.name();
        this.reader = new JsonpReader(jsonpSupportConfig.readerFactory());
        this.writer = new JsonpWriter(jsonpSupportConfig.writerFactory());
    }

    public static MediaSupport create() {
        return JsonpSupport.builder().build();
    }

    public static MediaSupport create(Config config) {
        return JsonpSupport.create(config, "jsonp");
    }

    public static MediaSupport create(Config config, String name) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(name);
        return ((JsonpSupportConfig.Builder)JsonpSupport.builder().name(name)).build();
    }

    public static JsonpSupport create(JsonpSupportConfig jsonpSupportConfig) {
        Objects.requireNonNull(jsonpSupportConfig);
        return new JsonpSupport(jsonpSupportConfig);
    }

    public static JsonpSupport create(Consumer<JsonpSupportConfig.Builder> consumer) {
        return ((JsonpSupportConfig.Builder)JsonpSupport.builder().update(consumer)).build();
    }

    public static JsonpSupportConfig.Builder builder() {
        return JsonpSupportConfig.builder();
    }

    public static <T extends JsonStructure> EntityWriter<T> serverResponseWriter() {
        return new JsonpWriter(WRITER_FACTORY);
    }

    public static <T extends JsonStructure> EntityReader<T> serverRequestReader() {
        return new JsonpReader(READER_FACTORY);
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return "jsonp";
    }

    public <T> MediaSupport.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders) {
        if (this.isSupportedType(type) && requestHeaders.contentType().map(this::isMediaTypeSupported).orElse(true).booleanValue()) {
            return new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.SUPPORTED, this::reader);
        }
        return MediaSupport.ReaderResponse.unsupported();
    }

    public <T> MediaSupport.WriterResponse<T> writer(GenericType<T> type, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
        if (this.isSupportedType(type)) {
            return new MediaSupport.WriterResponse(MediaSupport.SupportLevel.SUPPORTED, this::writer);
        }
        return MediaSupport.WriterResponse.unsupported();
    }

    public <T> MediaSupport.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders, Headers responseHeaders) {
        if (this.isSupportedType(type)) {
            List acceptedTypes = requestHeaders.acceptedTypes();
            if (acceptedTypes.isEmpty()) {
                return new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.SUPPORTED, this::reader);
            }
            for (HttpMediaType acceptedType : acceptedTypes) {
                if (!this.isMediaTypeSupported(acceptedType)) continue;
                return new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.SUPPORTED, this::reader);
            }
        }
        return MediaSupport.ReaderResponse.unsupported();
    }

    public <T> MediaSupport.WriterResponse<T> writer(GenericType<T> type, WritableHeaders<?> requestHeaders) {
        if (this.isSupportedType(type)) {
            return new MediaSupport.WriterResponse(MediaSupport.SupportLevel.SUPPORTED, this::writer);
        }
        return MediaSupport.WriterResponse.unsupported();
    }

    boolean isSupportedType(GenericType<?> type) {
        return JsonStructure.class.isAssignableFrom(type.rawType());
    }

    boolean isMediaTypeSupported(HttpMediaType mediaType) {
        return mediaType.test(MediaTypes.APPLICATION_JSON) || mediaType.test(MediaTypes.APPLICATION_JSON_PATCH_JSON);
    }

    <T> EntityReader<T> reader() {
        return this.reader;
    }

    <T> EntityWriter<T> writer() {
        return this.writer;
    }

    public JsonpSupportConfig prototype() {
        return this.jsonpSupportConfig;
    }

    static class Decorator
    implements Prototype.BuilderDecorator<JsonpSupportConfig.BuilderBase<?, ?>> {
        Decorator() {
        }

        public void decorate(JsonpSupportConfig.BuilderBase<?, ?> target) {
            if (target.readerFactory().isEmpty()) {
                target.readerFactory(READER_FACTORY);
            }
            if (target.writerFactory().isEmpty()) {
                target.writerFactory(WRITER_FACTORY);
            }
        }
    }
}

