/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.media.jsonp;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.http.media.jsonp.JsonpSupport;
import io.helidon.http.media.jsonp.JsonpSupportConfigBlueprint;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonWriterFactory;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.http.media.jsonp.JsonpSupportConfigBlueprint")
public interface JsonpSupportConfig
extends JsonpSupportConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(JsonpSupportConfig instance) {
        return (Builder)JsonpSupportConfig.builder().from(instance);
    }

    public static JsonpSupportConfig create() {
        return JsonpSupportConfig.builder().buildPrototype();
    }

    @Override
    public String name();

    @Override
    public JsonReaderFactory readerFactory();

    @Override
    public JsonWriterFactory writerFactory();

    public static class Builder
    extends BuilderBase<Builder, JsonpSupportConfig>
    implements io.helidon.common.Builder<Builder, JsonpSupport> {
        private Builder() {
        }

        public JsonpSupportConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.JsonpSupportConfigImpl(this);
        }

        public JsonpSupport build() {
            return JsonpSupport.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends JsonpSupportConfig>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private JsonReaderFactory readerFactory;
        private JsonWriterFactory writerFactory;
        private String name = "jsonp";

        protected BuilderBase() {
        }

        public BUILDER from(JsonpSupportConfig prototype) {
            this.name(prototype.name());
            this.readerFactory(prototype.readerFactory());
            this.writerFactory(prototype.writerFactory());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.name(builder.name());
            builder.readerFactory().ifPresent(this::readerFactory);
            builder.writerFactory().ifPresent(this::writerFactory);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER readerFactory(JsonReaderFactory readerFactory) {
            Objects.requireNonNull(readerFactory);
            this.readerFactory = readerFactory;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER writerFactory(JsonWriterFactory writerFactory) {
            Objects.requireNonNull(writerFactory);
            this.writerFactory = writerFactory;
            return (BUILDER)((BuilderBase)this.self());
        }

        public String name() {
            return this.name;
        }

        public Optional<JsonReaderFactory> readerFactory() {
            return Optional.ofNullable(this.readerFactory);
        }

        public Optional<JsonWriterFactory> writerFactory() {
            return Optional.ofNullable(this.writerFactory);
        }

        public String toString() {
            return "JsonpSupportConfigBuilder{name=" + this.name + ",readerFactory=" + String.valueOf(this.readerFactory) + ",writerFactory=" + String.valueOf(this.writerFactory) + "}";
        }

        protected void preBuildPrototype() {
            new JsonpSupport.Decorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.readerFactory == null) {
                collector.fatal(this.getClass(), "Property \"readerFactory\" must not be null, but not set");
            }
            if (this.writerFactory == null) {
                collector.fatal(this.getClass(), "Property \"writerFactory\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class JsonpSupportConfigImpl
        implements JsonpSupportConfig,
        Supplier<JsonpSupport> {
            private final JsonReaderFactory readerFactory;
            private final JsonWriterFactory writerFactory;
            private final String name;

            protected JsonpSupportConfigImpl(BuilderBase<?, ?> builder) {
                this.name = builder.name();
                this.readerFactory = builder.readerFactory().get();
                this.writerFactory = builder.writerFactory().get();
            }

            public JsonpSupport build() {
                return JsonpSupport.create(this);
            }

            @Override
            public JsonpSupport get() {
                return this.build();
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public JsonReaderFactory readerFactory() {
                return this.readerFactory;
            }

            @Override
            public JsonWriterFactory writerFactory() {
                return this.writerFactory;
            }

            public String toString() {
                return "JsonpSupportConfig{name=" + this.name + ",readerFactory=" + String.valueOf(this.readerFactory) + ",writerFactory=" + String.valueOf(this.writerFactory) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof JsonpSupportConfig)) {
                    return false;
                }
                JsonpSupportConfig other = (JsonpSupportConfig)o;
                return Objects.equals(this.name, other.name()) && Objects.equals(this.readerFactory, other.readerFactory()) && Objects.equals(this.writerFactory, other.writerFactory());
            }

            public int hashCode() {
                return Objects.hash(this.name, this.readerFactory, this.writerFactory);
            }
        }
    }
}

