/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.media;

import io.helidon.common.GenericType;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.common.parameters.Parameters;
import io.helidon.common.uri.UriEncoding;
import io.helidon.http.Headers;
import io.helidon.http.Http;
import io.helidon.http.HttpMediaType;
import io.helidon.http.WritableHeaders;
import io.helidon.http.media.EntityReader;
import io.helidon.http.media.EntityWriter;
import io.helidon.http.media.MediaSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormParamsSupport
implements MediaSupport {
    private static final EntityReader URL_READER = new FormParamsUrlReader();
    private static final EntityWriter URL_WRITER = new FormParamsUrlWriter();
    private static final EntityReader PLAINTEXT_READER = new FormParamsPlaintextReader();
    private static final EntityWriter PLAINTEXT_WRITER = new FormParamsPlaintextWriter();

    private FormParamsSupport() {
    }

    public static MediaSupport create() {
        return new FormParamsSupport();
    }

    @Override
    public <T> MediaSupport.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders) {
        if (!Parameters.class.isAssignableFrom(type.rawType())) {
            return MediaSupport.ReaderResponse.unsupported();
        }
        return requestHeaders.contentType().map(it -> {
            MediaSupport.ReaderResponse response = it.test(MediaTypes.APPLICATION_FORM_URLENCODED) ? new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.SUPPORTED, FormParamsSupport::urlEncodedReader) : (it.test(MediaTypes.TEXT_PLAIN) ? new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.SUPPORTED, FormParamsSupport::textReader) : MediaSupport.ReaderResponse.unsupported());
            return response;
        }).orElseGet(() -> new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.COMPATIBLE, FormParamsSupport::urlEncodedReader));
    }

    @Override
    public <T> MediaSupport.WriterResponse<T> writer(GenericType<T> type, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
        if (!Parameters.class.isAssignableFrom(type.rawType())) {
            return MediaSupport.WriterResponse.unsupported();
        }
        return responseHeaders.contentType().map(it -> {
            MediaSupport.WriterResponse response = it.test(MediaTypes.APPLICATION_FORM_URLENCODED) ? new MediaSupport.WriterResponse(MediaSupport.SupportLevel.SUPPORTED, FormParamsSupport::urlEncodedWriter) : (it.test(MediaTypes.TEXT_PLAIN) ? new MediaSupport.WriterResponse(MediaSupport.SupportLevel.SUPPORTED, FormParamsSupport::textWriter) : MediaSupport.WriterResponse.unsupported());
            return response;
        }).orElseGet(() -> new MediaSupport.WriterResponse(MediaSupport.SupportLevel.COMPATIBLE, FormParamsSupport::urlEncodedWriter));
    }

    @Override
    public <T> MediaSupport.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders, Headers responseHeaders) {
        if (!Parameters.class.isAssignableFrom(type.rawType())) {
            return MediaSupport.ReaderResponse.unsupported();
        }
        return responseHeaders.contentType().map(it -> {
            MediaSupport.ReaderResponse response = it.test(MediaTypes.APPLICATION_FORM_URLENCODED) ? new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.SUPPORTED, FormParamsSupport::urlEncodedReader) : (it.test(MediaTypes.TEXT_PLAIN) ? new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.SUPPORTED, FormParamsSupport::textReader) : MediaSupport.ReaderResponse.unsupported());
            return response;
        }).orElseGet(() -> new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.COMPATIBLE, FormParamsSupport::urlEncodedReader));
    }

    @Override
    public <T> MediaSupport.WriterResponse<T> writer(GenericType<T> type, WritableHeaders<?> requestHeaders) {
        if (!Parameters.class.isAssignableFrom(type.rawType())) {
            return MediaSupport.WriterResponse.unsupported();
        }
        return requestHeaders.contentType().map(it -> {
            MediaSupport.WriterResponse response = it.test(MediaTypes.APPLICATION_FORM_URLENCODED) ? new MediaSupport.WriterResponse(MediaSupport.SupportLevel.SUPPORTED, FormParamsSupport::urlEncodedWriter) : (it.test(MediaTypes.TEXT_PLAIN) ? new MediaSupport.WriterResponse(MediaSupport.SupportLevel.SUPPORTED, FormParamsSupport::textWriter) : MediaSupport.WriterResponse.unsupported());
            return response;
        }).orElseGet(() -> new MediaSupport.WriterResponse(MediaSupport.SupportLevel.COMPATIBLE, FormParamsSupport::urlEncodedWriter));
    }

    public String name() {
        return "form-params";
    }

    public String type() {
        return "form-params";
    }

    private static <T> EntityReader<T> urlEncodedReader() {
        return URL_READER;
    }

    private static <T> EntityReader<T> textReader() {
        return PLAINTEXT_READER;
    }

    private static <T> EntityWriter<T> urlEncodedWriter() {
        return URL_WRITER;
    }

    private static <T> EntityWriter<T> textWriter() {
        return PLAINTEXT_WRITER;
    }

    static final class FormParamsUrlReader
    extends FormParamsReader {
        static final Pattern PATTERN = Pattern.compile("([^=&]+)=([^&]*)&?");
        private static final System.Logger LOGGER = System.getLogger(FormParamsUrlReader.class.getName());
        private static final BiFunction<Charset, String, String> DECODER = (charset, value) -> URLDecoder.decode(value, charset);

        private FormParamsUrlReader() {
            super(LOGGER, PATTERN, DECODER);
        }
    }

    private static class FormParamsUrlWriter
    extends FormParamsWriter {
        private static final Http.Header CONTENT_TYPE_URL_ENCODED = Http.Headers.createCached((Http.HeaderName)Http.HeaderNames.CONTENT_TYPE, (String)HttpMediaType.create((MediaType)MediaTypes.APPLICATION_FORM_URLENCODED).withCharset("utf-8").text());
        private static final String SEPARATOR = "&";
        private static final Function<String, String> NAME_ENCODER = it -> UriEncoding.encode((String)it, (UriEncoding.Type)UriEncoding.Type.QUERY);
        private static final Function<String, String> VALUE_ENCODER = it -> UriEncoding.encode((String)it, (UriEncoding.Type)UriEncoding.Type.QUERY_PARAM);

        private FormParamsUrlWriter() {
            super(SEPARATOR, NAME_ENCODER, VALUE_ENCODER, CONTENT_TYPE_URL_ENCODED);
        }
    }

    private static final class FormParamsPlaintextReader
    extends FormParamsReader {
        private static final System.Logger LOGGER = System.getLogger(FormParamsPlaintextReader.class.getName());
        private static final Pattern PATTERN = Pattern.compile("([^=]+)=([^\\n]*)\\n?");
        private static final BiFunction<Charset, String, String> DECODER = (charset, value) -> value;

        private FormParamsPlaintextReader() {
            super(LOGGER, PATTERN, DECODER);
        }
    }

    private static class FormParamsPlaintextWriter
    extends FormParamsWriter {
        private static final Http.Header CONTENT_TYPE_TEXT = Http.Headers.createCached((Http.HeaderName)Http.HeaderNames.CONTENT_TYPE, (String)HttpMediaType.create((MediaType)MediaTypes.TEXT_PLAIN).withCharset("utf-8").text());
        private static final String SEPARATOR = "\n";
        private static final Function<String, String> NAME_ENCODER = Function.identity();
        private static final Function<String, String> VALUE_ENCODER = Function.identity();

        private FormParamsPlaintextWriter() {
            super(SEPARATOR, NAME_ENCODER, VALUE_ENCODER, CONTENT_TYPE_TEXT);
        }
    }

    private static class FormParamsReader
    implements EntityReader<Parameters> {
        private final System.Logger logger;
        private final Pattern pattern;
        private final BiFunction<Charset, String, String> decoder;

        private FormParamsReader(System.Logger logger, Pattern pattern, BiFunction<Charset, String, String> decoder) {
            this.logger = logger;
            this.pattern = pattern;
            this.decoder = decoder;
        }

        @Override
        public Parameters read(GenericType<Parameters> type, InputStream stream, Headers headers) {
            return this.read(stream, headers.contentType());
        }

        @Override
        public Parameters read(GenericType<Parameters> type, InputStream stream, Headers requestHeaders, Headers responseHeaders) {
            return this.read(stream, responseHeaders.contentType());
        }

        private Parameters read(InputStream stream, Optional<HttpMediaType> contentType) {
            Parameters parameters;
            block11: {
                Charset charset = contentType.flatMap(HttpMediaType::charset).map(Charset::forName).orElse(StandardCharsets.UTF_8);
                InputStream inputStream = stream;
                try {
                    Parameters.Builder builder = Parameters.builder((String)"form-params");
                    String encodedString = new String(stream.readAllBytes(), charset);
                    if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                        this.logger.log(System.Logger.Level.DEBUG, "Reading encoded form parameters: {0}", encodedString);
                    }
                    Matcher matcher = this.pattern.matcher(encodedString);
                    while (matcher.find()) {
                        String key = this.decoder.apply(charset, matcher.group(1));
                        String encodedValue = matcher.group(2);
                        if (encodedValue == null || encodedValue.isEmpty()) {
                            builder.add(key, new String[0]);
                            continue;
                        }
                        String value = this.decoder.apply(charset, encodedValue);
                        builder.add(key, new String[]{value});
                    }
                    parameters = builder.build();
                    if (inputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                inputStream.close();
            }
            return parameters;
        }
    }

    private static class FormParamsWriter
    implements EntityWriter<Parameters> {
        private final String separator;
        private final Function<String, String> nameEncoder;
        private final Function<String, String> valueEncoder;
        private final Http.Header contentTypeHeader;

        private FormParamsWriter(String separator, Function<String, String> nameEncoder, Function<String, String> valueEncoder, Http.Header contentTypeHeader) {
            this.separator = separator;
            this.nameEncoder = nameEncoder;
            this.valueEncoder = valueEncoder;
            this.contentTypeHeader = contentTypeHeader;
        }

        @Override
        public void write(GenericType<Parameters> type, Parameters object, OutputStream outputStream, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
            this.write(object, outputStream, responseHeaders);
        }

        @Override
        public void write(GenericType<Parameters> type, Parameters object, OutputStream outputStream, WritableHeaders<?> headers) {
            this.write(object, outputStream, headers);
        }

        private void write(Parameters toWrite, OutputStream outputStream, WritableHeaders<?> writableHeaders) {
            Charset charset;
            if (writableHeaders.contains(Http.HeaderNames.CONTENT_TYPE)) {
                charset = writableHeaders.contentType().flatMap(HttpMediaType::charset).map(Charset::forName).orElse(StandardCharsets.UTF_8);
            } else {
                writableHeaders.set(this.contentTypeHeader);
                charset = StandardCharsets.UTF_8;
            }
            ArrayList<CallSite> allParams = new ArrayList<CallSite>(toWrite.size());
            for (String name : toWrite.names()) {
                List<String> all = toWrite.all(name).stream().map(this.valueEncoder).toList();
                String encodedName = this.nameEncoder.apply(name);
                if (all.isEmpty()) {
                    allParams.add((CallSite)((Object)(encodedName + "=")));
                    continue;
                }
                for (String value : all) {
                    allParams.add((CallSite)((Object)(encodedName + "=" + value)));
                }
            }
            try (OutputStream outputStream2 = outputStream;){
                outputStream.write(String.join((CharSequence)this.separator, allParams).getBytes(charset));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

