/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.media;

import io.helidon.common.GenericType;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.http.ContentDisposition;
import io.helidon.http.Headers;
import io.helidon.http.Http;
import io.helidon.http.WritableHeaders;
import io.helidon.http.media.EntityWriter;
import io.helidon.http.media.InstanceWriter;
import io.helidon.http.media.MediaSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.OptionalLong;

public class PathSupport
implements MediaSupport {
    private static final EntityWriter WRITER = new PathWriter();
    private final String name;

    protected PathSupport(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public static MediaSupport create() {
        return new PathSupport("path");
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return "path";
    }

    @Override
    public <T> MediaSupport.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders) {
        return MediaSupport.ReaderResponse.unsupported();
    }

    @Override
    public <T> MediaSupport.WriterResponse<T> writer(GenericType<T> type, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
        if (Path.class.isAssignableFrom(type.rawType())) {
            return new MediaSupport.WriterResponse(MediaSupport.SupportLevel.SUPPORTED, PathSupport::writer);
        }
        return MediaSupport.WriterResponse.unsupported();
    }

    @Override
    public <T> MediaSupport.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders, Headers responseHeaders) {
        return MediaSupport.ReaderResponse.unsupported();
    }

    @Override
    public <T> MediaSupport.WriterResponse<T> writer(GenericType<T> type, WritableHeaders<?> requestHeaders) {
        if (Path.class.isAssignableFrom(type.rawType())) {
            return new MediaSupport.WriterResponse(MediaSupport.SupportLevel.SUPPORTED, PathSupport::writer);
        }
        return MediaSupport.WriterResponse.unsupported();
    }

    private static <T> EntityWriter<T> writer() {
        return WRITER;
    }

    private static void updateHeaders(Path path, WritableHeaders<?> writableHeaders) {
        if (!writableHeaders.contains(Http.HeaderNames.CONTENT_TYPE)) {
            MediaType mediaType = MediaTypes.detectType((Path)path).orElse(MediaTypes.APPLICATION_OCTET_STREAM);
            writableHeaders.contentType(mediaType);
        }
        if (!writableHeaders.contains(Http.HeaderNames.CONTENT_DISPOSITION)) {
            writableHeaders.set((Http.Header)ContentDisposition.builder().filename(String.valueOf(path.getFileName())).build());
        }
    }

    private static final class PathWriter
    implements EntityWriter<Path> {
        private PathWriter() {
        }

        @Override
        public void write(GenericType<Path> type, Path object, OutputStream outputStream, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
            this.write(object, outputStream, responseHeaders);
        }

        @Override
        public void write(GenericType<Path> type, Path object, OutputStream outputStream, WritableHeaders<?> headers) {
            this.write(object, outputStream, headers);
        }

        @Override
        public boolean supportsInstanceWriter() {
            return true;
        }

        @Override
        public InstanceWriter instanceWriter(GenericType<Path> type, Path object, WritableHeaders<?> requestHeaders) {
            return new PathInstanceWriter(object, requestHeaders);
        }

        @Override
        public InstanceWriter instanceWriter(GenericType<Path> type, Path object, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
            return new PathInstanceWriter(object, responseHeaders);
        }

        private void write(Path toWrite, OutputStream outputStream, WritableHeaders<?> writableHeaders) {
            PathSupport.updateHeaders(toWrite, writableHeaders);
            try (InputStream in = Files.newInputStream(toWrite, new OpenOption[0]);
                 OutputStream outputStream2 = outputStream;){
                in.transferTo(outputStream);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class PathInstanceWriter
    implements InstanceWriter {
        private final OptionalLong contentLength;
        private final Path path;

        private PathInstanceWriter(Path path, WritableHeaders<?> writableHeaders) {
            OptionalLong discoveredLength;
            this.path = path;
            try {
                discoveredLength = OptionalLong.of(Files.size(path));
            }
            catch (IOException e) {
                discoveredLength = OptionalLong.empty();
            }
            this.contentLength = discoveredLength;
            PathSupport.updateHeaders(path, writableHeaders);
        }

        @Override
        public OptionalLong contentLength() {
            return this.contentLength;
        }

        @Override
        public boolean alwaysInMemory() {
            return false;
        }

        @Override
        public void write(OutputStream stream) {
            try (InputStream in = Files.newInputStream(this.path, new OpenOption[0]);
                 OutputStream outputStream = stream;){
                in.transferTo(stream);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public byte[] instanceBytes() {
            try {
                return Files.readAllBytes(this.path);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

