/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.media;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.GenericType;
import io.helidon.common.config.Config;
import io.helidon.http.Headers;
import io.helidon.http.WritableHeaders;
import io.helidon.http.media.EntityReader;
import io.helidon.http.media.EntityWriter;
import io.helidon.http.media.MediaContextConfig;
import io.helidon.http.media.MediaContextImpl;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=MediaContextConfig.class)
public interface MediaContext
extends RuntimeType.Api<MediaContextConfig> {
    public static MediaContext create() {
        return MediaContext.builder().build();
    }

    public static MediaContext create(Config config) {
        return ((MediaContextConfig.Builder)MediaContext.builder().config(config)).build();
    }

    public static MediaContext create(MediaContextConfig config) {
        return new MediaContextImpl(config);
    }

    public static MediaContext create(Consumer<MediaContextConfig.Builder> consumer) {
        MediaContextConfig.Builder builder = MediaContextConfig.builder();
        consumer.accept(builder);
        return builder.build();
    }

    public static MediaContextConfig.Builder builder() {
        return MediaContextConfig.builder();
    }

    public <T> EntityReader<T> reader(GenericType<T> var1, Headers var2);

    public <T> EntityWriter<T> writer(GenericType<T> var1, Headers var2, WritableHeaders<?> var3);

    public <T> EntityReader<T> reader(GenericType<T> var1, Headers var2, Headers var3);

    public <T> EntityWriter<T> writer(GenericType<T> var1, WritableHeaders<?> var2);
}

