/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.inject.api.CallingContext;
import io.helidon.inject.api.InjectionServices;
import io.helidon.inject.api.InjectionServicesConfigBlueprint;
import java.util.Objects;
import java.util.Optional;

public class CallingContextFactory {
    private static volatile CallingContext defaultCallingContext;

    private CallingContextFactory() {
    }

    public static void globalCallingContext(CallingContext callingContext, boolean throwIfAlreadySet) {
        Objects.requireNonNull(callingContext);
        CallingContext global = defaultCallingContext;
        if (global != null && throwIfAlreadySet) {
            CallingContext currentCallingContext = CallingContextFactory.create(true).orElseThrow();
            throw new IllegalStateException("Expected to be the owner of the calling context. This context is: " + String.valueOf(currentCallingContext) + "\n Context previously set was: " + String.valueOf(global));
        }
        defaultCallingContext = callingContext;
    }

    public static Optional<CallingContext> create(boolean force) {
        Optional<CallingContext.Builder> optBuilder = CallingContextFactory.createBuilder(force);
        return optBuilder.map(CallingContext.Builder::build);
    }

    public static Optional<CallingContext.Builder> createBuilder(boolean force) {
        if (force || InjectionServices.injectionServices().map(InjectionServices::config).map(InjectionServicesConfigBlueprint::shouldDebug).orElse(false).booleanValue()) {
            return Optional.of((CallingContext.Builder)CallingContext.builder().stackTrace(new RuntimeException().getStackTrace()));
        }
        return Optional.empty();
    }
}

