/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.inject.api.DependencyInfoBlueprint;
import io.helidon.inject.api.InjectionPointInfo;
import io.helidon.inject.api.ServiceInfoCriteria;
import io.helidon.inject.api.ServiceProvider;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.inject.api.DependencyInfoBlueprint")
public interface DependencyInfo
extends DependencyInfoBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DependencyInfo instance) {
        return (Builder)DependencyInfo.builder().from(instance);
    }

    public static class Builder
    extends BuilderBase<Builder, DependencyInfo>
    implements io.helidon.common.Builder<Builder, DependencyInfo> {
        private Builder() {
        }

        public DependencyInfo buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.DependencyInfoImpl(this);
        }

        public DependencyInfo build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends DependencyInfo>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final Set<InjectionPointInfo> injectionPointDependencies = new LinkedHashSet<InjectionPointInfo>();
        private ServiceInfoCriteria dependencyTo;
        private ServiceProvider<?> resolvedTo;
        private String elementName;

        protected BuilderBase() {
        }

        public BUILDER from(DependencyInfo prototype) {
            this.elementName(prototype.elementName());
            this.dependencyTo(prototype.dependencyTo());
            this.addInjectionPointDependencies(prototype.injectionPointDependencies());
            this.resolvedTo(prototype.resolvedTo());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.elementName().ifPresent(this::elementName);
            builder.dependencyTo().ifPresent(this::dependencyTo);
            this.addInjectionPointDependencies(builder.injectionPointDependencies());
            builder.resolvedTo().ifPresent(this::resolvedTo);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementName(String elementName) {
            Objects.requireNonNull(elementName);
            this.elementName = elementName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER dependencyTo(ServiceInfoCriteria dependencyTo) {
            Objects.requireNonNull(dependencyTo);
            this.dependencyTo = dependencyTo;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER dependencyTo(Consumer<ServiceInfoCriteria.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ServiceInfoCriteria.Builder builder = ServiceInfoCriteria.builder();
            consumer.accept(builder);
            this.dependencyTo(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER dependencyTo(Supplier<? extends ServiceInfoCriteria> supplier) {
            Objects.requireNonNull(supplier);
            this.dependencyTo(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER injectionPointDependencies(Set<? extends InjectionPointInfo> injectionPointDependencies) {
            Objects.requireNonNull(injectionPointDependencies);
            this.injectionPointDependencies.clear();
            this.injectionPointDependencies.addAll(injectionPointDependencies);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInjectionPointDependencies(Set<? extends InjectionPointInfo> injectionPointDependencies) {
            Objects.requireNonNull(injectionPointDependencies);
            this.injectionPointDependencies.addAll(injectionPointDependencies);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInjectionPointDependency(InjectionPointInfo injectionPointDependency) {
            Objects.requireNonNull(injectionPointDependency);
            this.injectionPointDependencies.add(injectionPointDependency);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInjectionPointDependency(Consumer<InjectionPointInfo.Builder> consumer) {
            Objects.requireNonNull(consumer);
            InjectionPointInfo.Builder builder = InjectionPointInfo.builder();
            consumer.accept(builder);
            this.injectionPointDependencies.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearResolvedTo() {
            this.resolvedTo = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER resolvedTo(ServiceProvider<?> resolvedTo) {
            Objects.requireNonNull(resolvedTo);
            this.resolvedTo = resolvedTo;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> elementName() {
            return Optional.ofNullable(this.elementName);
        }

        public Optional<ServiceInfoCriteria> dependencyTo() {
            return Optional.ofNullable(this.dependencyTo);
        }

        public Set<InjectionPointInfo> injectionPointDependencies() {
            return this.injectionPointDependencies;
        }

        public Optional<ServiceProvider<?>> resolvedTo() {
            return Optional.ofNullable(this.resolvedTo);
        }

        public String toString() {
            return "DependencyInfoBuilder{elementName=" + this.elementName + ",dependencyTo=" + String.valueOf(this.dependencyTo) + ",injectionPointDependencies=" + String.valueOf(this.injectionPointDependencies) + ",resolvedTo=" + String.valueOf(this.resolvedTo) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.elementName == null) {
                collector.fatal(this.getClass(), "Property \"elementName\" must not be null, but not set");
            }
            if (this.dependencyTo == null) {
                collector.fatal(this.getClass(), "Property \"dependency-to\" is required, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER resolvedTo(Optional<ServiceProvider<?>> resolvedTo) {
            Objects.requireNonNull(resolvedTo);
            this.resolvedTo = resolvedTo.map(ServiceProvider.class::cast).orElse(this.resolvedTo);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class DependencyInfoImpl
        implements DependencyInfo {
            private final Optional<ServiceProvider<?>> resolvedTo;
            private final ServiceInfoCriteria dependencyTo;
            private final Set<InjectionPointInfo> injectionPointDependencies;
            private final String elementName;

            protected DependencyInfoImpl(BuilderBase<?, ?> builder) {
                this.elementName = builder.elementName().get();
                this.dependencyTo = builder.dependencyTo().get();
                this.injectionPointDependencies = Collections.unmodifiableSet(new LinkedHashSet<InjectionPointInfo>(builder.injectionPointDependencies()));
                this.resolvedTo = builder.resolvedTo();
            }

            @Override
            public String elementName() {
                return this.elementName;
            }

            @Override
            public ServiceInfoCriteria dependencyTo() {
                return this.dependencyTo;
            }

            @Override
            public Set<InjectionPointInfo> injectionPointDependencies() {
                return this.injectionPointDependencies;
            }

            @Override
            public Optional<ServiceProvider<?>> resolvedTo() {
                return this.resolvedTo;
            }

            public String toString() {
                return "DependencyInfo{elementName=" + this.elementName + ",dependencyTo=" + String.valueOf(this.dependencyTo) + ",injectionPointDependencies=" + String.valueOf(this.injectionPointDependencies) + ",resolvedTo=" + String.valueOf(this.resolvedTo) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DependencyInfo)) {
                    return false;
                }
                DependencyInfo other = (DependencyInfo)o;
                return Objects.equals(this.elementName, other.elementName()) && Objects.equals(this.dependencyTo, other.dependencyTo()) && Objects.equals(this.injectionPointDependencies, other.injectionPointDependencies()) && Objects.equals(this.resolvedTo, other.resolvedTo());
            }

            public int hashCode() {
                return Objects.hash(this.elementName, this.dependencyTo, this.injectionPointDependencies, this.resolvedTo);
            }
        }
    }
}

