/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.types.TypeName;
import io.helidon.inject.api.ClassNamed;
import io.helidon.inject.api.CommonQualifiers;
import io.helidon.inject.api.Qualifier;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Prototype.Blueprint
@Prototype.CustomMethods(value=QualifierMethods.class)
interface QualifierBlueprint
extends io.helidon.common.types.Annotation {
    public static final TypeName CLASS_NAMED = TypeName.create(ClassNamed.class);

    default public String qualifierTypeName() {
        return this.typeName().name();
    }

    public static final class QualifierMethods {
        private QualifierMethods() {
        }

        @Prototype.FactoryMethod
        static Qualifier create(Class<? extends Annotation> qualifierType) {
            Objects.requireNonNull(qualifierType);
            TypeName qualifierTypeName = QualifierMethods.maybeNamed(qualifierType.getName());
            return ((Qualifier.Builder)Qualifier.builder().typeName(qualifierTypeName)).build();
        }

        @Prototype.FactoryMethod
        static Qualifier create(Class<? extends Annotation> qualifierType, String value) {
            Objects.requireNonNull(qualifierType);
            TypeName qualifierTypeName = QualifierMethods.maybeNamed(qualifierType.getName());
            return ((Qualifier.Builder)((Qualifier.Builder)Qualifier.builder().typeName(qualifierTypeName)).putValue("value", value)).build();
        }

        @Prototype.FactoryMethod
        static Qualifier create(io.helidon.common.types.Annotation annotation) {
            Objects.requireNonNull(annotation);
            if (annotation instanceof Qualifier) {
                Qualifier qualifier = (Qualifier)annotation;
                return qualifier;
            }
            return ((Qualifier.Builder)((Qualifier.Builder)Qualifier.builder().typeName(QualifierMethods.maybeNamed(annotation.typeName()))).values(QualifierMethods.removeEmptyProperties(annotation.values()))).build();
        }

        @Prototype.FactoryMethod
        static Qualifier createNamed(String name) {
            Objects.requireNonNull(name);
            return ((Qualifier.Builder)((Qualifier.Builder)Qualifier.builder().typeName(CommonQualifiers.NAMED)).value(name)).build();
        }

        @Prototype.FactoryMethod
        static Qualifier createNamed(Named name) {
            Objects.requireNonNull(name);
            Qualifier.Builder builder = (Qualifier.Builder)Qualifier.builder().typeName(CommonQualifiers.NAMED);
            if (!name.value().isEmpty()) {
                builder.value(name.value());
            }
            return builder.build();
        }

        @Prototype.FactoryMethod
        static Qualifier createNamed(ClassNamed name) {
            Objects.requireNonNull(name);
            return ((Qualifier.Builder)((Qualifier.Builder)Qualifier.builder().typeName(CommonQualifiers.NAMED)).value(name.value().getName())).build();
        }

        @Prototype.FactoryMethod
        static Qualifier createNamed(Class<?> className) {
            Objects.requireNonNull(className);
            return ((Qualifier.Builder)((Qualifier.Builder)Qualifier.builder().typeName(CommonQualifiers.NAMED)).value(className.getName())).build();
        }

        private static TypeName maybeNamed(String qualifierTypeName) {
            if (qualifierTypeName.equals(ClassNamed.class.getName())) {
                return CommonQualifiers.NAMED;
            }
            return TypeName.create((String)qualifierTypeName);
        }

        private static TypeName maybeNamed(TypeName qualifierType) {
            if (CLASS_NAMED.equals((Object)qualifierType)) {
                return CommonQualifiers.NAMED;
            }
            return qualifierType;
        }

        private static Map<String, Object> removeEmptyProperties(Map<String, Object> values) {
            HashMap<String, Object> result = new HashMap<String, Object>(values);
            result.entrySet().removeIf(entry -> {
                String str;
                Object value = entry.getValue();
                return value instanceof String && (str = (String)value).isBlank();
            });
            return result;
        }
    }
}

