/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.common.config.Config;
import io.helidon.common.config.GlobalConfig;
import io.helidon.inject.api.Bootstrap;
import io.helidon.inject.api.InjectionPointProvider;
import io.helidon.inject.api.InjectionServices;
import io.helidon.inject.api.InjectionServicesHolder;
import io.helidon.inject.api.Services;
import io.helidon.inject.api.Startable;
import io.helidon.logging.common.LogConfig;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Deprecated(since="4.0.0")
public class Helidon {
    private static final System.Logger LOGGER = System.getLogger(Helidon.class.getName());
    private static final ReentrantReadWriteLock REENTRANT_READ_WRITE_LOCK = new ReentrantReadWriteLock();
    private static final ReentrantReadWriteLock.ReadLock READ_LOCK = REENTRANT_READ_WRITE_LOCK.readLock();
    private static final ReentrantReadWriteLock.WriteLock WRITE_LOCK = REENTRANT_READ_WRITE_LOCK.writeLock();
    private static final AtomicBoolean BASIC_INIT_DONE = new AtomicBoolean();
    private static final AtomicBoolean REGISTRY_INITIALIZED = new AtomicBoolean();
    private static final AtomicBoolean STARTED = new AtomicBoolean();

    private Helidon() {
    }

    public static Services serviceRegistry() {
        if (REGISTRY_INITIALIZED.compareAndSet(false, true)) {
            Helidon.basicInit();
            Helidon.registryInit(false);
        }
        try {
            READ_LOCK.lock();
            Services services = InjectionServices.realizedServices();
            return services;
        }
        finally {
            READ_LOCK.unlock();
        }
    }

    public static void start() {
        if (STARTED.compareAndSet(false, true)) {
            Helidon.basicInit();
            Helidon.registryInit(true);
        } else {
            LOGGER.log(System.Logger.Level.WARNING, "Helidon.start() has already been called.");
        }
    }

    private static boolean reset(boolean deep) {
        BASIC_INIT_DONE.set(false);
        REGISTRY_INITIALIZED.set(false);
        STARTED.set(false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registryInit(boolean bootServices) {
        try {
            WRITE_LOCK.lock();
            boolean explicitConfig = GlobalConfig.configured();
            Config bootstrapConfig = GlobalConfig.config();
            Bootstrap bootstrap = ((Bootstrap.Builder)Bootstrap.builder().config(bootstrapConfig)).build();
            InjectionServices.globalBootstrap(bootstrap);
            Services services = InjectionServices.realizedServices();
            if (!explicitConfig) {
                GlobalConfig.config(() -> (Config)services.lookup(Config.class).get(), (boolean)true);
            }
            if (bootServices) {
                services.lookupAll(Startable.class).stream().map(InjectionPointProvider::get).forEach(Startable::startService);
            }
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }

    private static void basicInit() {
        if (BASIC_INIT_DONE.compareAndSet(false, true)) {
            LogConfig.configureRuntime();
        }
    }

    static {
        LogConfig.initClass();
        ResettableHandler.registerReset();
    }

    private static final class ResettableHandler
    extends InjectionServicesHolder {
        @Deprecated
        private ResettableHandler() {
        }

        private static void registerReset() {
            InjectionServicesHolder.addResettable(Helidon::reset);
        }
    }
}

