/*
 * Copyright (c) 2024 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.helidon.inject.api;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.types.TypeName;

/**
 * Represents a per {@link ServiceInfo} mapping of {@link DependencyInfo}'s. These are typically assigned to a
 * {@link ServiceProvider} via compile-time code generation within the Injection framework.
 *
 * @deprecated Helidon inject is deprecated and will be replaced in a future version
 * @see #builder()
 * @see #create()
 */
@Generated(value = "io.helidon.builder.processor.BlueprintProcessor", trigger = "io.helidon.inject.api.DependenciesInfoBlueprint")
public interface DependenciesInfo extends DependenciesInfoBlueprint, Prototype.Api {

    /**
     * Create a new fluent API builder to customize configuration.
     *
     * @return a new builder
     */
    static DependenciesInfo.Builder builder() {
        return new DependenciesInfo.Builder();
    }

    /**
     * Create a new fluent API builder from an existing instance.
     *
     * @param instance an existing instance used as a base for the builder
     * @return a builder based on an instance
     */
    static DependenciesInfo.Builder builder(DependenciesInfo instance) {
        return DependenciesInfo.builder().from(instance);
    }

    /**
     * Create a new instance with default values.
     *
     * @return a new instance
     */
    static DependenciesInfo create() {
        return DependenciesInfo.builder().buildPrototype();
    }

    /**
     * Fluent API builder base for {@link DependenciesInfo}.
     *
     * @param <BUILDER> type of the builder extending this abstract builder
     * @param <PROTOTYPE> type of the prototype interface that would be built by {@link #buildPrototype()}
     */
    abstract class BuilderBase<BUILDER extends DependenciesInfo.BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends DependenciesInfo> implements Prototype.Builder<BUILDER, PROTOTYPE> {

        private final Map<ServiceInfoCriteria, Set<DependencyInfo>> serviceInfoDependencies = new LinkedHashMap<>();
        private TypeName fromServiceTypeName;

        /**
         * Protected to support extensibility.
         */
        protected BuilderBase() {
        }

        /**
         * Update this builder from an existing prototype instance.
         *
         * @param prototype existing prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(DependenciesInfo prototype) {
            addServiceInfoDependencies(prototype.serviceInfoDependencies());
            fromServiceTypeName(prototype.fromServiceTypeName());
            return self();
        }

        /**
         * Update this builder from an existing prototype builder instance.
         *
         * @param builder existing builder prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(DependenciesInfo.BuilderBase<?, ?> builder) {
            addServiceInfoDependencies(builder.serviceInfoDependencies());
            builder.fromServiceTypeName().ifPresent(this::fromServiceTypeName);
            return self();
        }

        /**
         * This method replaces all values with the new ones.
         *
         * @param serviceInfoDependencies map from the service info to its dependencies
         * @return updated builder instance
         * @see #serviceInfoDependencies()
         */
        public BUILDER serviceInfoDependencies(Map<? extends ServiceInfoCriteria, Set<DependencyInfo>> serviceInfoDependencies) {
            Objects.requireNonNull(serviceInfoDependencies);
            this.serviceInfoDependencies.clear();
            this.serviceInfoDependencies.putAll(serviceInfoDependencies);
            return self();
        }

        /**
         * This method keeps existing values, then puts all new values into the map.
         *
         * @param serviceInfoDependencies map from the service info to its dependencies
         * @return updated builder instance
         * @see #serviceInfoDependencies()
         */
        public BUILDER addServiceInfoDependencies(Map<? extends ServiceInfoCriteria, Set<DependencyInfo>> serviceInfoDependencies) {
            Objects.requireNonNull(serviceInfoDependencies);
            this.serviceInfoDependencies.putAll(serviceInfoDependencies);
            return self();
        }

        /**
         * This method adds a new value to the map value, or creates a new value.
         *
         * @param key key to add to
         * @param serviceInfoDependency additional value for the key
         * @return updated builder instance
         * @see #serviceInfoDependencies()
         */
        public BUILDER addServiceInfoDependency(ServiceInfoCriteria key, DependencyInfo serviceInfoDependency) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(serviceInfoDependency);
            this.serviceInfoDependencies.compute(key, (k, v) -> {
                v = v == null ? new LinkedHashSet<>() : new LinkedHashSet<>(v);
                v.add(serviceInfoDependency);
                return v;
            });
            return self();
        }

        /**
         * This method adds a new value to the map value, or creates a new value.
         *
         * @param key key to add to
         * @param serviceInfoDependencies additional values for the key
         * @return updated builder instance
         * @see #serviceInfoDependencies()
         */
        public BUILDER addServiceInfoDependencies(ServiceInfoCriteria key, Set<DependencyInfo> serviceInfoDependencies) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(serviceInfoDependencies);
            this.serviceInfoDependencies.compute(key, (k, v) -> {
                v = v == null ? new LinkedHashSet<>() : new LinkedHashSet<>(v);
                v.addAll(serviceInfoDependencies);
                return v;
            });
            return self();
        }

        /**
         * This method adds a new value to the map, or replaces it if the key already exists.
         *
         * @param key key to add or replace
         * @param serviceInfoDependency new value for the key
         * @return updated builder instance
         * @see #serviceInfoDependencies()
         */
        public BUILDER putServiceInfoDependency(ServiceInfoCriteria key, Set<DependencyInfo> serviceInfoDependency) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(serviceInfoDependency);
            this.serviceInfoDependencies.put(key, Set.copyOf(serviceInfoDependency));
            return self();
        }

        /**
         * Clear existing value of this property.
         *
         * @return updated builder instance
         * @see #fromServiceTypeName()
         */
        public BUILDER clearFromServiceTypeName() {
            this.fromServiceTypeName = null;
            return self();
        }

        /**
         * Optionally, the service type name aggregating {@link #allDependencies()}.
         *
         * @param fromServiceTypeName the optional service type name for which these dependencies belong
         * @return updated builder instance
         * @see #fromServiceTypeName()
         */
        public BUILDER fromServiceTypeName(TypeName fromServiceTypeName) {
            Objects.requireNonNull(fromServiceTypeName);
            this.fromServiceTypeName = fromServiceTypeName;
            return self();
        }

        /**
         * Optionally, the service type name aggregating {@link #allDependencies()}.
         *
         * @param consumer the optional service type name for which these dependencies belong
         * @return updated builder instance
         * @see #fromServiceTypeName()
         */
        public BUILDER fromServiceTypeName(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            var builder = TypeName.builder();
            consumer.accept(builder);
            this.fromServiceTypeName(builder.build());
            return self();
        }

        /**
         * Represents the set of dependencies for each {@link ServiceInfo}.
         *
         * @return the service info dependencies
         */
        public Map<ServiceInfoCriteria, Set<DependencyInfo>> serviceInfoDependencies() {
            return serviceInfoDependencies;
        }

        /**
         * Optionally, the service type name aggregating {@link #allDependencies()}.
         *
         * @return the from service type name
         */
        public Optional<TypeName> fromServiceTypeName() {
            return Optional.ofNullable(fromServiceTypeName);
        }

        @Override
        public String toString() {
            return "DependenciesInfoBuilder{"
                    + "serviceInfoDependencies=" + serviceInfoDependencies + ","
                    + "fromServiceTypeName=" + fromServiceTypeName
                    + "}";
        }

        /**
         * Handles providers and decorators.
         */
        protected void preBuildPrototype() {
        }

        /**
         * Validates required properties.
         */
        protected void validatePrototype() {
        }

        /**
         * Optionally, the service type name aggregating {@link #allDependencies()}.
         *
         * @param fromServiceTypeName the optional service type name for which these dependencies belong
         * @return updated builder instance
         * @see #fromServiceTypeName()
         */
        BUILDER fromServiceTypeName(Optional<? extends TypeName> fromServiceTypeName) {
            Objects.requireNonNull(fromServiceTypeName);
            this.fromServiceTypeName = fromServiceTypeName.map(io.helidon.common.types.TypeName.class::cast).orElse(this.fromServiceTypeName);
            return self();
        }

        /**
         * Generated implementation of the prototype, can be extended by descendant prototype implementations.
         */
        protected static class DependenciesInfoImpl implements DependenciesInfo {

            private final Map<ServiceInfoCriteria, Set<DependencyInfo>> serviceInfoDependencies;
            private final Optional<TypeName> fromServiceTypeName;

            /**
             * Create an instance providing a builder.
             *
             * @param builder extending builder base of this prototype
             */
            protected DependenciesInfoImpl(DependenciesInfo.BuilderBase<?, ?> builder) {
                this.serviceInfoDependencies = Collections.unmodifiableMap(new LinkedHashMap<>(builder.serviceInfoDependencies()));
                this.fromServiceTypeName = builder.fromServiceTypeName();
            }

            @Override
            public Map<ServiceInfoCriteria, Set<DependencyInfo>> serviceInfoDependencies() {
                return serviceInfoDependencies;
            }

            @Override
            public Optional<TypeName> fromServiceTypeName() {
                return fromServiceTypeName;
            }

            @Override
            public String toString() {
                return "DependenciesInfo{"
                        + "serviceInfoDependencies=" + serviceInfoDependencies + ","
                        + "fromServiceTypeName=" + fromServiceTypeName
                        + "}";
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DependenciesInfo other)) {
                    return false;
                }
                return Objects.equals(serviceInfoDependencies, other.serviceInfoDependencies())
                        && Objects.equals(fromServiceTypeName, other.fromServiceTypeName());
            }

            @Override
            public int hashCode() {
                return Objects.hash(serviceInfoDependencies, fromServiceTypeName);
            }

        }

    }

    /**
     * Fluent API builder for {@link DependenciesInfo}.
     */
    class Builder extends DependenciesInfo.BuilderBase<DependenciesInfo.Builder, DependenciesInfo> implements io.helidon.common.Builder<DependenciesInfo.Builder, DependenciesInfo> {

        private Builder() {
        }

        @Override
        public DependenciesInfo buildPrototype() {
            preBuildPrototype();
            validatePrototype();
            return new DependenciesInfoImpl(this);
        }

        @Override
        public DependenciesInfo build() {
            return buildPrototype();
        }

    }

}
