/*
 * Copyright (c) 2024 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.helidon.inject.api;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.types.TypeName;

/**
 * Describes a receiver for injection - identifies who/what is requesting an injection that needs to be satisfied.
 *
 * @deprecated Helidon inject is deprecated and will be replaced in a future version
 * @see #builder()
 * @see #create()
 */
@Generated(value = "io.helidon.builder.processor.BlueprintProcessor", trigger = "io.helidon.inject.api.InjectionPointInfoBlueprint")
public interface InjectionPointInfo extends InjectionPointInfoBlueprint, Prototype.Api, ElementInfo {

    /**
     * Create a new fluent API builder to customize configuration.
     *
     * @return a new builder
     */
    static InjectionPointInfo.Builder builder() {
        return new InjectionPointInfo.Builder();
    }

    /**
     * Create a new fluent API builder from an existing instance.
     *
     * @param instance an existing instance used as a base for the builder
     * @return a builder based on an instance
     */
    static InjectionPointInfo.Builder builder(InjectionPointInfo instance) {
        return InjectionPointInfo.builder().from(instance);
    }

    /**
     * Create a new instance with default values.
     *
     * @return a new instance
     */
    static InjectionPointInfo create() {
        return InjectionPointInfo.builder().buildPrototype();
    }

    /**
     * Fluent API builder base for {@link InjectionPointInfo}.
     *
     * @param <BUILDER> type of the builder extending this abstract builder
     * @param <PROTOTYPE> type of the prototype interface that would be built by {@link #buildPrototype()}
     */
    abstract class BuilderBase<BUILDER extends InjectionPointInfo.BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends InjectionPointInfo> extends ElementInfo.BuilderBase<BUILDER, PROTOTYPE> implements Prototype.Builder<BUILDER, PROTOTYPE> {

        private boolean listWrapped = false;
        private boolean optionalWrapped = false;
        private boolean providerWrapped = false;
        private ServiceInfoCriteria dependencyToServiceInfo;
        private String baseIdentity;
        private String id;
        private String ipName;
        private TypeName ipType;

        /**
         * Protected to support extensibility.
         */
        protected BuilderBase() {
        }

        /**
         * Update this builder from an existing prototype instance.
         *
         * @param prototype existing prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(InjectionPointInfo prototype) {
            super.from(prototype);
            ipName(prototype.ipName());
            ipType(prototype.ipType());
            id(prototype.id());
            baseIdentity(prototype.baseIdentity());
            listWrapped(prototype.listWrapped());
            optionalWrapped(prototype.optionalWrapped());
            providerWrapped(prototype.providerWrapped());
            dependencyToServiceInfo(prototype.dependencyToServiceInfo());
            return self();
        }

        /**
         * Update this builder from an existing prototype builder instance.
         *
         * @param builder existing builder prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(InjectionPointInfo.BuilderBase<?, ?> builder) {
            super.from(builder);
            builder.ipName().ifPresent(this::ipName);
            builder.ipType().ifPresent(this::ipType);
            builder.id().ifPresent(this::id);
            builder.baseIdentity().ifPresent(this::baseIdentity);
            listWrapped(builder.listWrapped());
            optionalWrapped(builder.optionalWrapped());
            providerWrapped(builder.providerWrapped());
            builder.dependencyToServiceInfo().ifPresent(this::dependencyToServiceInfo);
            return self();
        }

        /**
         * Name of the field or argument we are injecting into.
         * Best effort, if cannot be found, an indexed approach may be used (such as {@code arg0}).
         *
         * @param ipName name of the injection point field or argument
         * @return updated builder instance
         * @see #ipName()
         */
        public BUILDER ipName(String ipName) {
            Objects.requireNonNull(ipName);
            this.ipName = ipName;
            return self();
        }

        /**
         * Type of the field or argument we are injecting into.
         *
         * @param ipType type of the field or argument, including generic type declarations
         * @return updated builder instance
         * @see #ipType()
         */
        public BUILDER ipType(TypeName ipType) {
            Objects.requireNonNull(ipType);
            this.ipType = ipType;
            return self();
        }

        /**
         * Type of the field or argument we are injecting into.
         *
         * @param consumer consumer of builder for
         *                 type of the field or argument, including generic type declarations
         * @return updated builder instance
         * @see #ipType()
         */
        public BUILDER ipType(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            var builder = TypeName.builder();
            consumer.accept(builder);
            this.ipType(builder.build());
            return self();
        }

        /**
         * Type of the field or argument we are injecting into.
         *
         * @param supplier supplier of
         *                 type of the field or argument, including generic type declarations
         * @return updated builder instance
         * @see #ipType()
         */
        public BUILDER ipType(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.ipType(supplier.get());
            return self();
        }

        /**
         * The identity (aka id) for this injection point. The id should be unique for the service type it is contained within.
         * <p>
         * This method will return the {@link #baseIdentity()} when {@link #elementOffset()} is null.  If not null
         * then the elemOffset is part of the returned identity.
         *
         * @param id the unique identity
         * @return updated builder instance
         * @see #id()
         */
        public BUILDER id(String id) {
            Objects.requireNonNull(id);
            this.id = id;
            return self();
        }

        /**
         * The base identifying name for this injection point. If the element represents a function, then the function arguments
         * are encoded in its base identity.
         *
         * @param baseIdentity the base identity of the element
         * @return updated builder instance
         * @see #baseIdentity()
         */
        public BUILDER baseIdentity(String baseIdentity) {
            Objects.requireNonNull(baseIdentity);
            this.baseIdentity = baseIdentity;
            return self();
        }

        /**
         * True if the injection point is of type {@link java.util.List}.
         *
         * @param listWrapped true if list based receiver
         * @return updated builder instance
         * @see #listWrapped()
         */
        public BUILDER listWrapped(boolean listWrapped) {
            this.listWrapped = listWrapped;
            return self();
        }

        /**
         * True if the injection point is of type {@link java.util.Optional}.
         *
         * @param optionalWrapped true if optional based receiver
         * @return updated builder instance
         * @see #optionalWrapped()
         */
        public BUILDER optionalWrapped(boolean optionalWrapped) {
            this.optionalWrapped = optionalWrapped;
            return self();
        }

        /**
         * True if the injection point is of type Provider (or Supplier).
         *
         * @param providerWrapped true if provider based receiver
         * @return updated builder instance
         * @see #providerWrapped()
         */
        public BUILDER providerWrapped(boolean providerWrapped) {
            this.providerWrapped = providerWrapped;
            return self();
        }

        /**
         * The service info criteria/dependency this is dependent upon.
         *
         * @param dependencyToServiceInfo the service info criteria we are dependent upon
         * @return updated builder instance
         * @see #dependencyToServiceInfo()
         */
        public BUILDER dependencyToServiceInfo(ServiceInfoCriteria dependencyToServiceInfo) {
            Objects.requireNonNull(dependencyToServiceInfo);
            this.dependencyToServiceInfo = dependencyToServiceInfo;
            return self();
        }

        /**
         * The service info criteria/dependency this is dependent upon.
         *
         * @param consumer consumer of builder for
         *                 the service info criteria we are dependent upon
         * @return updated builder instance
         * @see #dependencyToServiceInfo()
         */
        public BUILDER dependencyToServiceInfo(Consumer<ServiceInfoCriteria.Builder> consumer) {
            Objects.requireNonNull(consumer);
            var builder = ServiceInfoCriteria.builder();
            consumer.accept(builder);
            this.dependencyToServiceInfo(builder.build());
            return self();
        }

        /**
         * The service info criteria/dependency this is dependent upon.
         *
         * @param supplier supplier of
         *                 the service info criteria we are dependent upon
         * @return updated builder instance
         * @see #dependencyToServiceInfo()
         */
        public BUILDER dependencyToServiceInfo(Supplier<? extends ServiceInfoCriteria> supplier) {
            Objects.requireNonNull(supplier);
            this.dependencyToServiceInfo(supplier.get());
            return self();
        }

        /**
         * Name of the field or argument we are injecting into.
         * Best effort, if cannot be found, an indexed approach may be used (such as {@code arg0}).
         *
         * @return the ip name
         */
        public Optional<String> ipName() {
            return Optional.ofNullable(ipName);
        }

        /**
         * Type of the field or argument we are injecting into.
         *
         * @return the ip type
         */
        public Optional<TypeName> ipType() {
            return Optional.ofNullable(ipType);
        }

        /**
         * The identity (aka id) for this injection point. The id should be unique for the service type it is contained within.
         * <p>
         * This method will return the {@link #baseIdentity()} when {@link #elementOffset()} is null.  If not null
         * then the elemOffset is part of the returned identity.
         *
         * @return the id
         */
        public Optional<String> id() {
            return Optional.ofNullable(id);
        }

        /**
         * The base identifying name for this injection point. If the element represents a function, then the function arguments
         * are encoded in its base identity.
         *
         * @return the base identity
         */
        public Optional<String> baseIdentity() {
            return Optional.ofNullable(baseIdentity);
        }

        /**
         * True if the injection point is of type {@link java.util.List}.
         *
         * @return the list wrapped
         */
        public boolean listWrapped() {
            return listWrapped;
        }

        /**
         * True if the injection point is of type {@link java.util.Optional}.
         *
         * @return the optional wrapped
         */
        public boolean optionalWrapped() {
            return optionalWrapped;
        }

        /**
         * True if the injection point is of type Provider (or Supplier).
         *
         * @return the provider wrapped
         */
        public boolean providerWrapped() {
            return providerWrapped;
        }

        /**
         * The service info criteria/dependency this is dependent upon.
         *
         * @return the dependency to service info
         */
        public Optional<ServiceInfoCriteria> dependencyToServiceInfo() {
            return Optional.ofNullable(dependencyToServiceInfo);
        }

        @Override
        public String toString() {
            return "InjectionPointInfoBuilder{"
                    + "ipName=" + ipName + ","
                    + "ipType=" + ipType + ","
                    + "id=" + id + ","
                    + "baseIdentity=" + baseIdentity + ","
                    + "listWrapped=" + listWrapped + ","
                    + "optionalWrapped=" + optionalWrapped + ","
                    + "providerWrapped=" + providerWrapped + ","
                    + "dependencyToServiceInfo=" + dependencyToServiceInfo
                    + "};"
                    + super.toString();
        }

        /**
         * Handles providers and decorators.
         */
        protected void preBuildPrototype() {
            super.preBuildPrototype();
        }

        /**
         * Validates required properties.
         */
        protected void validatePrototype() {
            super.validatePrototype();
            Errors.Collector collector = Errors.collector();
            if (ipName == null) {
                collector.fatal(getClass(), "Property \"ipName\" must not be null, but not set");
            }
            if (ipType == null) {
                collector.fatal(getClass(), "Property \"ipType\" must not be null, but not set");
            }
            if (id == null) {
                collector.fatal(getClass(), "Property \"id\" must not be null, but not set");
            }
            if (baseIdentity == null) {
                collector.fatal(getClass(), "Property \"baseIdentity\" must not be null, but not set");
            }
            if (dependencyToServiceInfo == null) {
                collector.fatal(getClass(), "Property \"dependencyToServiceInfo\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        /**
         * Generated implementation of the prototype, can be extended by descendant prototype implementations.
         */
        protected static class InjectionPointInfoImpl extends ElementInfoImpl implements InjectionPointInfo {

            private final boolean listWrapped;
            private final boolean optionalWrapped;
            private final boolean providerWrapped;
            private final ServiceInfoCriteria dependencyToServiceInfo;
            private final String baseIdentity;
            private final String id;
            private final String ipName;
            private final TypeName ipType;

            /**
             * Create an instance providing a builder.
             *
             * @param builder extending builder base of this prototype
             */
            protected InjectionPointInfoImpl(InjectionPointInfo.BuilderBase<?, ?> builder) {
                super(builder);
                this.ipName = builder.ipName().get();
                this.ipType = builder.ipType().get();
                this.id = builder.id().get();
                this.baseIdentity = builder.baseIdentity().get();
                this.listWrapped = builder.listWrapped();
                this.optionalWrapped = builder.optionalWrapped();
                this.providerWrapped = builder.providerWrapped();
                this.dependencyToServiceInfo = builder.dependencyToServiceInfo().get();
            }

            @Override
            public String ipName() {
                return ipName;
            }

            @Override
            public TypeName ipType() {
                return ipType;
            }

            @Override
            public String id() {
                return id;
            }

            @Override
            public String baseIdentity() {
                return baseIdentity;
            }

            @Override
            public boolean listWrapped() {
                return listWrapped;
            }

            @Override
            public boolean optionalWrapped() {
                return optionalWrapped;
            }

            @Override
            public boolean providerWrapped() {
                return providerWrapped;
            }

            @Override
            public ServiceInfoCriteria dependencyToServiceInfo() {
                return dependencyToServiceInfo;
            }

            @Override
            public String toString() {
                return "InjectionPointInfo{"
                        + "ipName=" + ipName + ","
                        + "ipType=" + ipType + ","
                        + "id=" + id + ","
                        + "baseIdentity=" + baseIdentity + ","
                        + "listWrapped=" + listWrapped + ","
                        + "optionalWrapped=" + optionalWrapped + ","
                        + "providerWrapped=" + providerWrapped + ","
                        + "dependencyToServiceInfo=" + dependencyToServiceInfo
                        + "};"
                        + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InjectionPointInfo other)) {
                    return false;
                }
                return super.equals(other)
                        && Objects.equals(ipName, other.ipName())
                        && Objects.equals(ipType, other.ipType())
                        && Objects.equals(id, other.id())
                        && Objects.equals(baseIdentity, other.baseIdentity())
                        && listWrapped == other.listWrapped()
                        && optionalWrapped == other.optionalWrapped()
                        && providerWrapped == other.providerWrapped()
                        && Objects.equals(dependencyToServiceInfo, other.dependencyToServiceInfo());
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(ipName, ipType, id, baseIdentity, listWrapped, optionalWrapped, providerWrapped, dependencyToServiceInfo);
            }

        }

    }

    /**
     * Fluent API builder for {@link InjectionPointInfo}.
     */
    class Builder extends InjectionPointInfo.BuilderBase<InjectionPointInfo.Builder, InjectionPointInfo> implements io.helidon.common.Builder<InjectionPointInfo.Builder, InjectionPointInfo> {

        private Builder() {
        }

        @Override
        public InjectionPointInfo buildPrototype() {
            preBuildPrototype();
            validatePrototype();
            return new InjectionPointInfoImpl(this);
        }

        @Override
        public InjectionPointInfo build() {
            return buildPrototype();
        }

    }

}
