/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.inject.api.ActivationResultBlueprint;
import io.helidon.inject.api.ActivationStatus;
import io.helidon.inject.api.Phase;
import io.helidon.inject.api.ServiceProvider;
import io.helidon.inject.spi.InjectionPlan;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.inject.api.ActivationResultBlueprint")
public interface ActivationResult
extends ActivationResultBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ActivationResult instance) {
        return (Builder)ActivationResult.builder().from(instance);
    }

    public static ActivationResult create() {
        return ActivationResult.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ActivationResult>
    implements io.helidon.common.Builder<Builder, ActivationResult> {
        private Builder() {
        }

        public ActivationResult buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ActivationResultImpl(this);
        }

        public ActivationResult build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ActivationResult>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final Map<String, InjectionPlan> injectionPlans = new LinkedHashMap<String, InjectionPlan>();
        private final Map<String, Object> resolvedDependencies = new LinkedHashMap<String, Object>();
        private ActivationStatus finishingStatus;
        private boolean wasResolved = false;
        private Future<ActivationResultBlueprint> finishedActivationResult;
        private Phase finishingActivationPhase;
        private Phase startingActivationPhase = Phase.INIT;
        private Phase targetActivationPhase = Phase.INIT;
        private ServiceProvider<?> serviceProvider;
        private Throwable error;

        protected BuilderBase() {
        }

        public BUILDER from(ActivationResult prototype) {
            this.serviceProvider(prototype.serviceProvider());
            this.finishedActivationResult(prototype.finishedActivationResult());
            this.startingActivationPhase(prototype.startingActivationPhase());
            this.targetActivationPhase(prototype.targetActivationPhase());
            this.finishingActivationPhase(prototype.finishingActivationPhase());
            this.finishingStatus(prototype.finishingStatus());
            this.addInjectionPlans(prototype.injectionPlans());
            this.addResolvedDependencies(prototype.resolvedDependencies());
            this.wasResolved(prototype.wasResolved());
            this.error(prototype.error());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.serviceProvider().ifPresent(this::serviceProvider);
            builder.finishedActivationResult().ifPresent(this::finishedActivationResult);
            this.startingActivationPhase(builder.startingActivationPhase());
            this.targetActivationPhase(builder.targetActivationPhase());
            builder.finishingActivationPhase().ifPresent(this::finishingActivationPhase);
            builder.finishingStatus().ifPresent(this::finishingStatus);
            this.addInjectionPlans(builder.injectionPlans());
            this.addResolvedDependencies(builder.resolvedDependencies());
            this.wasResolved(builder.wasResolved());
            builder.error().ifPresent(this::error);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceProvider(ServiceProvider<?> serviceProvider) {
            Objects.requireNonNull(serviceProvider);
            this.serviceProvider = serviceProvider;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearFinishedActivationResult() {
            this.finishedActivationResult = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER finishedActivationResult(Future<ActivationResultBlueprint> finishedActivationResult) {
            Objects.requireNonNull(finishedActivationResult);
            this.finishedActivationResult = finishedActivationResult;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER startingActivationPhase(Phase startingActivationPhase) {
            Objects.requireNonNull(startingActivationPhase);
            this.startingActivationPhase = startingActivationPhase;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER targetActivationPhase(Phase targetActivationPhase) {
            Objects.requireNonNull(targetActivationPhase);
            this.targetActivationPhase = targetActivationPhase;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER finishingActivationPhase(Phase finishingActivationPhase) {
            Objects.requireNonNull(finishingActivationPhase);
            this.finishingActivationPhase = finishingActivationPhase;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearFinishingStatus() {
            this.finishingStatus = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER finishingStatus(ActivationStatus finishingStatus) {
            Objects.requireNonNull(finishingStatus);
            this.finishingStatus = finishingStatus;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER injectionPlans(Map<? extends String, ? extends InjectionPlan> injectionPlans) {
            Objects.requireNonNull(injectionPlans);
            this.injectionPlans.clear();
            this.injectionPlans.putAll(injectionPlans);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInjectionPlans(Map<? extends String, ? extends InjectionPlan> injectionPlans) {
            Objects.requireNonNull(injectionPlans);
            this.injectionPlans.putAll(injectionPlans);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER resolvedDependencies(Map<? extends String, ?> resolvedDependencies) {
            Objects.requireNonNull(resolvedDependencies);
            this.resolvedDependencies.clear();
            this.resolvedDependencies.putAll(resolvedDependencies);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addResolvedDependencies(Map<? extends String, ?> resolvedDependencies) {
            Objects.requireNonNull(resolvedDependencies);
            this.resolvedDependencies.putAll(resolvedDependencies);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER wasResolved(boolean wasResolved) {
            this.wasResolved = wasResolved;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearError() {
            this.error = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER error(Throwable error) {
            Objects.requireNonNull(error);
            this.error = error;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<ServiceProvider<?>> serviceProvider() {
            return Optional.ofNullable(this.serviceProvider);
        }

        public Optional<Future<ActivationResultBlueprint>> finishedActivationResult() {
            return Optional.ofNullable(this.finishedActivationResult);
        }

        public Phase startingActivationPhase() {
            return this.startingActivationPhase;
        }

        public Phase targetActivationPhase() {
            return this.targetActivationPhase;
        }

        public Optional<Phase> finishingActivationPhase() {
            return Optional.ofNullable(this.finishingActivationPhase);
        }

        public Optional<ActivationStatus> finishingStatus() {
            return Optional.ofNullable(this.finishingStatus);
        }

        public Map<String, InjectionPlan> injectionPlans() {
            return this.injectionPlans;
        }

        public Map<String, Object> resolvedDependencies() {
            return this.resolvedDependencies;
        }

        public boolean wasResolved() {
            return this.wasResolved;
        }

        public Optional<Throwable> error() {
            return Optional.ofNullable(this.error);
        }

        public String toString() {
            return "ActivationResultBuilder{serviceProvider=" + String.valueOf(this.serviceProvider) + ",finishedActivationResult=" + String.valueOf(this.finishedActivationResult) + ",startingActivationPhase=" + String.valueOf((Object)this.startingActivationPhase) + ",targetActivationPhase=" + String.valueOf((Object)this.targetActivationPhase) + ",finishingActivationPhase=" + String.valueOf((Object)this.finishingActivationPhase) + ",finishingStatus=" + String.valueOf((Object)this.finishingStatus) + ",injectionPlans=" + String.valueOf(this.injectionPlans) + ",resolvedDependencies=" + String.valueOf(this.resolvedDependencies) + ",wasResolved=" + this.wasResolved + ",error=" + String.valueOf(this.error) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.serviceProvider == null) {
                collector.fatal(this.getClass(), "Property \"serviceProvider\" must not be null, but not set");
            }
            if (this.finishingActivationPhase == null) {
                collector.fatal(this.getClass(), "Property \"finishingActivationPhase\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER finishedActivationResult(Optional<Future<ActivationResultBlueprint>> finishedActivationResult) {
            Objects.requireNonNull(finishedActivationResult);
            this.finishedActivationResult = finishedActivationResult.map(Future.class::cast).orElse(this.finishedActivationResult);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER finishingStatus(Optional<? extends ActivationStatus> finishingStatus) {
            Objects.requireNonNull(finishingStatus);
            this.finishingStatus = finishingStatus.map(ActivationStatus.class::cast).orElse(this.finishingStatus);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER error(Optional<? extends Throwable> error) {
            Objects.requireNonNull(error);
            this.error = error.map(Throwable.class::cast).orElse(this.error);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ActivationResultImpl
        implements ActivationResult {
            private final boolean wasResolved;
            private final Map<String, InjectionPlan> injectionPlans;
            private final Map<String, Object> resolvedDependencies;
            private final Optional<ActivationStatus> finishingStatus;
            private final Optional<Throwable> error;
            private final Optional<Future<ActivationResultBlueprint>> finishedActivationResult;
            private final Phase finishingActivationPhase;
            private final Phase startingActivationPhase;
            private final Phase targetActivationPhase;
            private final ServiceProvider<?> serviceProvider;

            protected ActivationResultImpl(BuilderBase<?, ?> builder) {
                this.serviceProvider = builder.serviceProvider().get();
                this.finishedActivationResult = builder.finishedActivationResult();
                this.startingActivationPhase = builder.startingActivationPhase();
                this.targetActivationPhase = builder.targetActivationPhase();
                this.finishingActivationPhase = builder.finishingActivationPhase().get();
                this.finishingStatus = builder.finishingStatus();
                this.injectionPlans = Collections.unmodifiableMap(new LinkedHashMap<String, InjectionPlan>(builder.injectionPlans()));
                this.resolvedDependencies = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(builder.resolvedDependencies()));
                this.wasResolved = builder.wasResolved();
                this.error = builder.error();
            }

            @Override
            public ServiceProvider<?> serviceProvider() {
                return this.serviceProvider;
            }

            @Override
            public Optional<Future<ActivationResultBlueprint>> finishedActivationResult() {
                return this.finishedActivationResult;
            }

            @Override
            public Phase startingActivationPhase() {
                return this.startingActivationPhase;
            }

            @Override
            public Phase targetActivationPhase() {
                return this.targetActivationPhase;
            }

            @Override
            public Phase finishingActivationPhase() {
                return this.finishingActivationPhase;
            }

            @Override
            public Optional<ActivationStatus> finishingStatus() {
                return this.finishingStatus;
            }

            @Override
            public Map<String, InjectionPlan> injectionPlans() {
                return this.injectionPlans;
            }

            @Override
            public Map<String, Object> resolvedDependencies() {
                return this.resolvedDependencies;
            }

            @Override
            public boolean wasResolved() {
                return this.wasResolved;
            }

            @Override
            public Optional<Throwable> error() {
                return this.error;
            }

            public String toString() {
                return "ActivationResult{serviceProvider=" + String.valueOf(this.serviceProvider) + ",finishedActivationResult=" + String.valueOf(this.finishedActivationResult) + ",startingActivationPhase=" + String.valueOf((Object)this.startingActivationPhase) + ",targetActivationPhase=" + String.valueOf((Object)this.targetActivationPhase) + ",finishingActivationPhase=" + String.valueOf((Object)this.finishingActivationPhase) + ",finishingStatus=" + String.valueOf(this.finishingStatus) + ",injectionPlans=" + String.valueOf(this.injectionPlans) + ",resolvedDependencies=" + String.valueOf(this.resolvedDependencies) + ",wasResolved=" + this.wasResolved + ",error=" + String.valueOf(this.error) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ActivationResult)) {
                    return false;
                }
                ActivationResult other = (ActivationResult)o;
                return Objects.equals(this.serviceProvider, other.serviceProvider()) && Objects.equals(this.finishedActivationResult, other.finishedActivationResult()) && Objects.equals((Object)this.startingActivationPhase, (Object)other.startingActivationPhase()) && Objects.equals((Object)this.targetActivationPhase, (Object)other.targetActivationPhase()) && Objects.equals((Object)this.finishingActivationPhase, (Object)other.finishingActivationPhase()) && Objects.equals(this.finishingStatus, other.finishingStatus()) && Objects.equals(this.injectionPlans, other.injectionPlans()) && Objects.equals(this.resolvedDependencies, other.resolvedDependencies()) && this.wasResolved == other.wasResolved() && Objects.equals(this.error, other.error());
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.serviceProvider, this.finishedActivationResult, this.startingActivationPhase, this.targetActivationPhase, this.finishingActivationPhase, this.finishingStatus, this.injectionPlans, this.resolvedDependencies, this.wasResolved, this.error});
            }
        }
    }
}

