/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.types.TypeName;
import io.helidon.inject.api.ServiceInfoBasics;
import io.helidon.inject.api.ServiceInfoBlueprint;
import io.helidon.inject.api.ServiceInfoBuildDecorator;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.inject.api.ServiceInfoBlueprint")
public interface ServiceInfo
extends ServiceInfoBlueprint,
Prototype.Api,
ServiceInfoBasics {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ServiceInfo instance) {
        return (Builder)ServiceInfo.builder().from(instance);
    }

    public static ServiceInfo create() {
        return ServiceInfo.builder().buildPrototype();
    }

    public static Builder builder(ServiceInfoBasics prototype) {
        return ServiceInfoBlueprint.CustomMethods.builder(prototype);
    }

    public static class Builder
    extends BuilderBase<Builder, ServiceInfo>
    implements io.helidon.common.Builder<Builder, ServiceInfo> {
        private Builder() {
        }

        public ServiceInfo buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ServiceInfoImpl(this);
        }

        public ServiceInfo build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ServiceInfo>
    extends ServiceInfoBasics.BuilderBase<BUILDER, PROTOTYPE>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final Set<TypeName> externalContractsImplemented = new LinkedHashSet<TypeName>();
        private String moduleName;
        private TypeName activatorTypeName;

        protected BuilderBase() {
        }

        public BUILDER from(ServiceInfo prototype) {
            super.from(prototype);
            this.addExternalContractsImplemented(prototype.externalContractsImplemented());
            this.activatorTypeName(prototype.activatorTypeName());
            this.moduleName(prototype.moduleName());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            this.addExternalContractsImplemented(builder.externalContractsImplemented());
            builder.activatorTypeName().ifPresent(this::activatorTypeName);
            builder.moduleName().ifPresent(this::moduleName);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addExternalContractImplemented(Class<?> type) {
            ServiceInfoBlueprint.CustomMethods.addExternalContractImplemented(this, type);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER activatorTypeName(Class<?> type) {
            ServiceInfoBlueprint.CustomMethods.activatorTypeName(this, type);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addScopeTypeName(Class<?> type) {
            ServiceInfoBlueprint.CustomMethods.addScopeTypeName(this, type);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER externalContractsImplemented(Set<? extends TypeName> externalContractsImplemented) {
            Objects.requireNonNull(externalContractsImplemented);
            this.externalContractsImplemented.clear();
            this.externalContractsImplemented.addAll(externalContractsImplemented);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addExternalContractsImplemented(Set<? extends TypeName> externalContractsImplemented) {
            Objects.requireNonNull(externalContractsImplemented);
            this.externalContractsImplemented.addAll(externalContractsImplemented);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addExternalContractImplemented(TypeName externalContractImplemented) {
            Objects.requireNonNull(externalContractImplemented);
            this.externalContractsImplemented.add(externalContractImplemented);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addExternalContractImplemented(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.externalContractsImplemented.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearActivatorTypeName() {
            this.activatorTypeName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER activatorTypeName(TypeName activatorTypeName) {
            Objects.requireNonNull(activatorTypeName);
            this.activatorTypeName = activatorTypeName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER activatorTypeName(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.activatorTypeName(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearModuleName() {
            this.moduleName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER moduleName(String moduleName) {
            Objects.requireNonNull(moduleName);
            this.moduleName = moduleName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Set<TypeName> externalContractsImplemented() {
            return this.externalContractsImplemented;
        }

        public Optional<TypeName> activatorTypeName() {
            return Optional.ofNullable(this.activatorTypeName);
        }

        public Optional<String> moduleName() {
            return Optional.ofNullable(this.moduleName);
        }

        @Override
        public String toString() {
            return "ServiceInfoBuilder{externalContractsImplemented=" + String.valueOf(this.externalContractsImplemented) + ",activatorTypeName=" + String.valueOf(this.activatorTypeName) + ",moduleName=" + this.moduleName + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
            new ServiceInfoBuildDecorator().decorate(this);
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
        }

        BUILDER activatorTypeName(Optional<? extends TypeName> activatorTypeName) {
            Objects.requireNonNull(activatorTypeName);
            this.activatorTypeName = activatorTypeName.map(TypeName.class::cast).orElse(this.activatorTypeName);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER moduleName(Optional<String> moduleName) {
            Objects.requireNonNull(moduleName);
            this.moduleName = moduleName.map(String.class::cast).orElse(this.moduleName);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ServiceInfoImpl
        extends ServiceInfoBasics.BuilderBase.ServiceInfoBasicsImpl
        implements ServiceInfo {
            private final Optional<TypeName> activatorTypeName;
            private final Optional<String> moduleName;
            private final Set<TypeName> externalContractsImplemented;

            protected ServiceInfoImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.externalContractsImplemented = Collections.unmodifiableSet(new LinkedHashSet<TypeName>(builder.externalContractsImplemented()));
                this.activatorTypeName = builder.activatorTypeName();
                this.moduleName = builder.moduleName();
            }

            @Override
            public Set<TypeName> externalContractsImplemented() {
                return this.externalContractsImplemented;
            }

            @Override
            public Optional<TypeName> activatorTypeName() {
                return this.activatorTypeName;
            }

            @Override
            public Optional<String> moduleName() {
                return this.moduleName;
            }

            @Override
            public String toString() {
                return "ServiceInfo{externalContractsImplemented=" + String.valueOf(this.externalContractsImplemented) + ",activatorTypeName=" + String.valueOf(this.activatorTypeName) + ",moduleName=" + String.valueOf(this.moduleName) + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ServiceInfo)) {
                    return false;
                }
                ServiceInfo other = (ServiceInfo)o;
                return super.equals(other) && Objects.equals(this.externalContractsImplemented, other.externalContractsImplemented()) && Objects.equals(this.activatorTypeName, other.activatorTypeName()) && Objects.equals(this.moduleName, other.moduleName());
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.externalContractsImplemented, this.activatorTypeName, this.moduleName);
            }
        }
    }
}

