/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.types.TypeName;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.inject.api.InjectionServices;
import io.helidon.inject.api.Qualifier;
import io.helidon.inject.api.Qualifiers;
import io.helidon.inject.api.ServiceInfoCriteria;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Deprecated(forRemoval=true, since="4.0.8")
@Prototype.Blueprint
@Prototype.CustomMethods(value=CustomMethods.class)
interface ServiceInfoCriteriaBlueprint {
    public Optional<TypeName> serviceTypeName();

    @Option.Singular
    public Set<TypeName> scopeTypeNames();

    @Option.Singular
    public Set<Qualifier> qualifiers();

    @Option.Singular(value="contractImplemented")
    public Set<TypeName> contractsImplemented();

    public Optional<Integer> runLevel();

    public Optional<Double> weight();

    @Option.Singular(value="externalContractImplemented")
    public Set<TypeName> externalContractsImplemented();

    public Optional<TypeName> activatorTypeName();

    public Optional<String> moduleName();

    @ConfiguredOption(value="false")
    public boolean includeIntercepted();

    default public boolean matches(ServiceInfoCriteriaBlueprint criteria) {
        return this.matchesContracts(criteria) && this.scopeTypeNames().containsAll(criteria.scopeTypeNames()) && Qualifiers.matchesQualifiers(this.qualifiers(), criteria.qualifiers()) && ServiceInfoCriteriaBlueprint.matches(this.activatorTypeName(), criteria.activatorTypeName()) && ServiceInfoCriteriaBlueprint.matches(this.runLevel(), criteria.runLevel()) && ServiceInfoCriteriaBlueprint.matches(this.moduleName(), criteria.moduleName());
    }

    default public boolean matchesContracts(ServiceInfoCriteriaBlueprint criteria) {
        if (criteria == InjectionServices.EMPTY_CRITERIA) {
            return true;
        }
        boolean matches = ServiceInfoCriteriaBlueprint.matches(this.serviceTypeName(), criteria.serviceTypeName());
        if (matches && criteria.serviceTypeName().isEmpty()) {
            matches = this.contractsImplemented().containsAll(criteria.contractsImplemented());
        }
        return matches;
    }

    private static boolean matches(Object src, Optional<?> criteria) {
        return criteria.map(o -> Objects.equals(src, o)).orElse(true);
    }

    public static final class CustomMethods {
        private CustomMethods() {
        }

        @Prototype.BuilderMethod
        static void addContractImplemented(ServiceInfoCriteria.BuilderBase<?, ?> builder, Class<?> contract) {
            builder.addContractImplemented(TypeName.create(contract));
        }
    }
}

