/*
 * Copyright (c) 2024 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.helidon.inject.api;

import java.util.Objects;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;

/**
 * Request to deactivate a {@link ServiceProvider}.
 *
 * @see #builder()
 * @see #create()
 */
@Generated(value = "io.helidon.builder.processor.BlueprintProcessor", trigger = "io.helidon.inject.api.DeActivationRequestBlueprint")
public interface DeActivationRequest extends DeActivationRequestBlueprint, Prototype.Api {

    /**
     * Create a new fluent API builder to customize configuration.
     *
     * @return a new builder
     */
    static DeActivationRequest.Builder builder() {
        return new DeActivationRequest.Builder();
    }

    /**
     * Create a new fluent API builder from an existing instance.
     *
     * @param instance an existing instance used as a base for the builder
     * @return a builder based on an instance
     */
    static DeActivationRequest.Builder builder(DeActivationRequest instance) {
        return DeActivationRequest.builder().from(instance);
    }

    /**
     * Create a new instance with default values.
     *
     * @return a new instance
     */
    static DeActivationRequest create() {
        return DeActivationRequest.builder().buildPrototype();
    }

    /**
     * Fluent API builder base for {@link DeActivationRequest}.
     *
     * @param <BUILDER> type of the builder extending this abstract builder
     * @param <PROTOTYPE> type of the prototype interface that would be built by {@link #buildPrototype()}
     */
    abstract class BuilderBase<BUILDER extends DeActivationRequest.BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends DeActivationRequest> implements Prototype.Builder<BUILDER, PROTOTYPE> {

        private boolean throwIfError = true;

        /**
         * Protected to support extensibility.
         */
        protected BuilderBase() {
        }

        /**
         * Update this builder from an existing prototype instance.
         *
         * @param prototype existing prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(DeActivationRequest prototype) {
            throwIfError(prototype.throwIfError());
            return self();
        }

        /**
         * Update this builder from an existing prototype builder instance.
         *
         * @param builder existing builder prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(DeActivationRequest.BuilderBase<?, ?> builder) {
            throwIfError(builder.throwIfError());
            return self();
        }

        /**
         * Whether to throw an exception on failure, or return it as part of the result.
         *
         * @param throwIfError throw on failure
         * @return updated builder instance
         * @see #throwIfError()
         */
        public BUILDER throwIfError(boolean throwIfError) {
            this.throwIfError = throwIfError;
            return self();
        }

        /**
         * Whether to throw an exception on failure, or return it as part of the result.
         *
         * @return the throw if error
         */
        public boolean throwIfError() {
            return throwIfError;
        }

        @Override
        public String toString() {
            return "DeActivationRequestBuilder{"
                    + "throwIfError=" + throwIfError
                    + "}";
        }

        /**
         * Handles providers and decorators.
         */
        protected void preBuildPrototype() {
        }

        /**
         * Validates required properties.
         */
        protected void validatePrototype() {
        }

        /**
         * Generated implementation of the prototype, can be extended by descendant prototype implementations.
         */
        protected static class DeActivationRequestImpl implements DeActivationRequest {

            private final boolean throwIfError;

            /**
             * Create an instance providing a builder.
             *
             * @param builder extending builder base of this prototype
             */
            protected DeActivationRequestImpl(DeActivationRequest.BuilderBase<?, ?> builder) {
                this.throwIfError = builder.throwIfError();
            }

            @Override
            public boolean throwIfError() {
                return throwIfError;
            }

            @Override
            public String toString() {
                return "DeActivationRequest{"
                        + "throwIfError=" + throwIfError
                        + "}";
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DeActivationRequest other)) {
                    return false;
                }
                return throwIfError == other.throwIfError();
            }

            @Override
            public int hashCode() {
                return Objects.hash(throwIfError);
            }

        }

    }

    /**
     * Fluent API builder for {@link DeActivationRequest}.
     */
    class Builder extends DeActivationRequest.BuilderBase<DeActivationRequest.Builder, DeActivationRequest> implements io.helidon.common.Builder<DeActivationRequest.Builder, DeActivationRequest> {

        private Builder() {
        }

        @Override
        public DeActivationRequest buildPrototype() {
            preBuildPrototype();
            validatePrototype();
            return new DeActivationRequestImpl(this);
        }

        @Override
        public DeActivationRequest build() {
            return buildPrototype();
        }

    }

}
