/*
 * Copyright (c) 2024 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.types.Annotation;

import jakarta.inject.Named;

/**
 * Represents a qualifier annotation (a specific case of annotations, annotated with {@link jakarta.inject.Qualifier}.
 *
 * @see jakarta.inject.Qualifier
 * @see CommonQualifiers
 * @see #builder()
 * @see #create()
 */
@Generated(value = "io.helidon.builder.processor.BlueprintProcessor", trigger = "io.helidon.inject.api.QualifierBlueprint")
public interface Qualifier extends QualifierBlueprint, Prototype.Api, Annotation {

    /**
     * Create a new fluent API builder to customize configuration.
     *
     * @return a new builder
     */
    static Qualifier.Builder builder() {
        return new Qualifier.Builder();
    }

    /**
     * Create a new fluent API builder from an existing instance.
     *
     * @param instance an existing instance used as a base for the builder
     * @return a builder based on an instance
     */
    static Qualifier.Builder builder(Qualifier instance) {
        return Qualifier.builder().from(instance);
    }

    /**
     * Create a new instance with default values.
     *
     * @return a new instance
     */
    static Qualifier create() {
        return Qualifier.builder().buildPrototype();
    }

    /**
     * Creates a qualifier from an annotation.
     *
     * @param qualifierType the qualifier type
     * @return qualifier
     */
    static Qualifier create(Class<? extends java.lang.annotation.Annotation> qualifierType) {
        return QualifierBlueprint.QualifierMethods.create(qualifierType);
    }

    /**
     * Creates a qualifier with a value from an annotation.
     *
     * @param qualifierType the qualifier type
     * @param value the value property
     * @return qualifier
     */
    static Qualifier create(Class<? extends java.lang.annotation.Annotation> qualifierType, String value) {
        return QualifierBlueprint.QualifierMethods.create(qualifierType, value);
    }

    /**
     * Creates a qualifier from an annotation.
     *
     * @param annotation the qualifier annotation
     * @return qualifier
     */
    static Qualifier create(Annotation annotation) {
        return QualifierBlueprint.QualifierMethods.create(annotation);
    }

    /**
     * Creates a {@link jakarta.inject.Named} qualifier.
     *
     * @param name the name
     * @return named qualifier
     */
    static Qualifier createNamed(String name) {
        return QualifierBlueprint.QualifierMethods.createNamed(name);
    }

    /**
     * Creates a {@link jakarta.inject.Named} qualifier.
     *
     * @param name the name
     * @return named qualifier
     */
    static Qualifier createNamed(Named name) {
        return QualifierBlueprint.QualifierMethods.createNamed(name);
    }

    /**
     * Creates a {@link jakarta.inject.Named} qualifier.
     *
     * @param name the name
     * @return named qualifier
     */
    static Qualifier createNamed(ClassNamed name) {
        return QualifierBlueprint.QualifierMethods.createNamed(name);
    }

    /**
     * Creates a {@link jakarta.inject.Named} qualifier from a class name.
     *
     * @param className class whose name will be used
     * @return named qualifier
     */
    static Qualifier createNamed(Class<?> className) {
        return QualifierBlueprint.QualifierMethods.createNamed(className);
    }

    /**
     * Fluent API builder base for {@link Qualifier}.
     *
     * @param <BUILDER> type of the builder extending this abstract builder
     * @param <PROTOTYPE> type of the prototype interface that would be built by {@link #buildPrototype()}
     */
    abstract class BuilderBase<BUILDER extends Qualifier.BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends Qualifier> extends Annotation.BuilderBase<BUILDER, PROTOTYPE> implements Prototype.Builder<BUILDER, PROTOTYPE> {

        /**
         * Protected to support extensibility.
         */
        protected BuilderBase() {
        }

        /**
         * Update this builder from an existing prototype instance.
         *
         * @param prototype existing prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(Qualifier prototype) {
            super.from(prototype);
            return self();
        }

        /**
         * Update this builder from an existing prototype builder instance.
         *
         * @param builder existing builder prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(Qualifier.BuilderBase<?, ?> builder) {
            super.from(builder);
            return self();
        }

        @Override
        public String toString() {
            return "QualifierBuilder{};"
            + super.toString();
        }

        /**
         * Handles providers and decorators.
         */
        protected void preBuildPrototype() {
            super.preBuildPrototype();
        }

        /**
         * Validates required properties.
         */
        protected void validatePrototype() {
            super.validatePrototype();
        }

        /**
         * Generated implementation of the prototype, can be extended by descendant prototype implementations.
         */
        protected static class QualifierImpl extends AnnotationImpl implements Qualifier {

            /**
             * Create an instance providing a builder.
             *
             * @param builder extending builder base of this prototype
             */
            protected QualifierImpl(Qualifier.BuilderBase<?, ?> builder) {
                super(builder);
            }

            @Override
            public String toString() {
                return "Qualifier{};"
                + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Qualifier other)) {
                    return false;
                }
                return super.equals(other);
            }

            @Override
            public int hashCode() {
                return super.hashCode();
            }

        }

    }

    /**
     * Fluent API builder for {@link Qualifier}.
     */
    class Builder extends Qualifier.BuilderBase<Qualifier.Builder, Qualifier> implements io.helidon.common.Builder<Qualifier.Builder, Qualifier> {

        private Builder() {
        }

        @Override
        public Qualifier buildPrototype() {
            preBuildPrototype();
            validatePrototype();
            return new QualifierImpl(this);
        }

        @Override
        public Qualifier build() {
            return buildPrototype();
        }

    }

}
