/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.inject.api.ActivationRequestBlueprint;
import io.helidon.inject.api.InjectionPointInfo;
import io.helidon.inject.api.Phase;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.inject.api.ActivationRequestBlueprint")
public interface ActivationRequest
extends ActivationRequestBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ActivationRequest instance) {
        return (Builder)ActivationRequest.builder().from(instance);
    }

    public static ActivationRequest create() {
        return ActivationRequest.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ActivationRequest>
    implements io.helidon.common.Builder<Builder, ActivationRequest> {
        private Builder() {
        }

        public ActivationRequest buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ActivationRequestImpl(this);
        }

        public ActivationRequest build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ActivationRequest>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private boolean throwIfError = true;
        private InjectionPointInfo injectionPoint;
        private Phase startingPhase;
        private Phase targetPhase = Phase.ACTIVE;

        protected BuilderBase() {
        }

        public BUILDER from(ActivationRequest prototype) {
            this.injectionPoint(prototype.injectionPoint());
            this.startingPhase(prototype.startingPhase());
            this.targetPhase(prototype.targetPhase());
            this.throwIfError(prototype.throwIfError());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.injectionPoint().ifPresent(this::injectionPoint);
            builder.startingPhase().ifPresent(this::startingPhase);
            this.targetPhase(builder.targetPhase());
            this.throwIfError(builder.throwIfError());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearInjectionPoint() {
            this.injectionPoint = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER injectionPoint(InjectionPointInfo injectionPoint) {
            Objects.requireNonNull(injectionPoint);
            this.injectionPoint = injectionPoint;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER injectionPoint(Consumer<InjectionPointInfo.Builder> consumer) {
            Objects.requireNonNull(consumer);
            InjectionPointInfo.Builder builder = InjectionPointInfo.builder();
            consumer.accept(builder);
            this.injectionPoint(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearStartingPhase() {
            this.startingPhase = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER startingPhase(Phase startingPhase) {
            Objects.requireNonNull(startingPhase);
            this.startingPhase = startingPhase;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER targetPhase(Phase targetPhase) {
            Objects.requireNonNull(targetPhase);
            this.targetPhase = targetPhase;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER throwIfError(boolean throwIfError) {
            this.throwIfError = throwIfError;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<InjectionPointInfo> injectionPoint() {
            return Optional.ofNullable(this.injectionPoint);
        }

        public Optional<Phase> startingPhase() {
            return Optional.ofNullable(this.startingPhase);
        }

        public Phase targetPhase() {
            return this.targetPhase;
        }

        public boolean throwIfError() {
            return this.throwIfError;
        }

        public String toString() {
            return "ActivationRequestBuilder{injectionPoint=" + String.valueOf(this.injectionPoint) + ",startingPhase=" + String.valueOf((Object)this.startingPhase) + ",targetPhase=" + String.valueOf((Object)this.targetPhase) + ",throwIfError=" + this.throwIfError + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER injectionPoint(Optional<? extends InjectionPointInfo> injectionPoint) {
            Objects.requireNonNull(injectionPoint);
            this.injectionPoint = injectionPoint.map(InjectionPointInfo.class::cast).orElse(this.injectionPoint);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER startingPhase(Optional<? extends Phase> startingPhase) {
            Objects.requireNonNull(startingPhase);
            this.startingPhase = startingPhase.map(Phase.class::cast).orElse(this.startingPhase);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ActivationRequestImpl
        implements ActivationRequest {
            private final boolean throwIfError;
            private final Optional<InjectionPointInfo> injectionPoint;
            private final Optional<Phase> startingPhase;
            private final Phase targetPhase;

            protected ActivationRequestImpl(BuilderBase<?, ?> builder) {
                this.injectionPoint = builder.injectionPoint();
                this.startingPhase = builder.startingPhase();
                this.targetPhase = builder.targetPhase();
                this.throwIfError = builder.throwIfError();
            }

            @Override
            public Optional<InjectionPointInfo> injectionPoint() {
                return this.injectionPoint;
            }

            @Override
            public Optional<Phase> startingPhase() {
                return this.startingPhase;
            }

            @Override
            public Phase targetPhase() {
                return this.targetPhase;
            }

            @Override
            public boolean throwIfError() {
                return this.throwIfError;
            }

            public String toString() {
                return "ActivationRequest{injectionPoint=" + String.valueOf(this.injectionPoint) + ",startingPhase=" + String.valueOf(this.startingPhase) + ",targetPhase=" + String.valueOf((Object)this.targetPhase) + ",throwIfError=" + this.throwIfError + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ActivationRequest)) {
                    return false;
                }
                ActivationRequest other = (ActivationRequest)o;
                return Objects.equals(this.injectionPoint, other.injectionPoint()) && Objects.equals(this.startingPhase, other.startingPhase()) && Objects.equals((Object)this.targetPhase, (Object)other.targetPhase()) && this.throwIfError == other.throwIfError();
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.injectionPoint, this.startingPhase, this.targetPhase, this.throwIfError});
            }
        }
    }
}

