/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.inject.api;

import io.helidon.inject.api.ContextualServiceQuery;
import io.helidon.inject.api.InjectionException;
import io.helidon.inject.api.InjectionServiceProviderException;
import io.helidon.inject.api.InjectionServices;
import io.helidon.inject.api.ServiceProvider;
import jakarta.inject.Provider;
import java.util.List;
import java.util.Optional;

public interface InjectionPointProvider<T>
extends Provider<T> {
    default public T get() {
        return this.first(InjectionServices.SERVICE_QUERY_REQUIRED).orElseThrow(this::couldNotFindMatch);
    }

    public Optional<T> first(ContextualServiceQuery var1);

    default public List<T> list(ContextualServiceQuery query) {
        return this.first(query).map(List::of).orElseGet(List::of);
    }

    private InjectionException couldNotFindMatch() {
        if (this instanceof ServiceProvider) {
            return new InjectionServiceProviderException("Expected to find a match", (ServiceProvider)this);
        }
        return new InjectionException("Expected to find a match for " + String.valueOf(this));
    }
}

