/*
 * Copyright (c) 2024 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.helidon.inject.api;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;

/**
 * Request to activate a service.
 *
 * @deprecated Helidon inject is deprecated and will be replaced in a future version
 * @see #builder()
 * @see #create()
 */
@Generated(value = "io.helidon.builder.processor.BlueprintProcessor", trigger = "io.helidon.inject.api.ActivationRequestBlueprint")
public interface ActivationRequest extends ActivationRequestBlueprint, Prototype.Api {

    /**
     * Create a new fluent API builder to customize configuration.
     *
     * @return a new builder
     */
    static ActivationRequest.Builder builder() {
        return new ActivationRequest.Builder();
    }

    /**
     * Create a new fluent API builder from an existing instance.
     *
     * @param instance an existing instance used as a base for the builder
     * @return a builder based on an instance
     */
    static ActivationRequest.Builder builder(ActivationRequest instance) {
        return ActivationRequest.builder().from(instance);
    }

    /**
     * Create a new instance with default values.
     *
     * @return a new instance
     */
    static ActivationRequest create() {
        return ActivationRequest.builder().buildPrototype();
    }

    /**
     * Fluent API builder base for {@link ActivationRequest}.
     *
     * @param <BUILDER> type of the builder extending this abstract builder
     * @param <PROTOTYPE> type of the prototype interface that would be built by {@link #buildPrototype()}
     */
    abstract class BuilderBase<BUILDER extends ActivationRequest.BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ActivationRequest> implements Prototype.Builder<BUILDER, PROTOTYPE> {

        private boolean throwIfError = true;
        private InjectionPointInfo injectionPoint;
        private Phase startingPhase;
        private Phase targetPhase = Phase.ACTIVE;

        /**
         * Protected to support extensibility.
         */
        protected BuilderBase() {
        }

        /**
         * Update this builder from an existing prototype instance.
         *
         * @param prototype existing prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(ActivationRequest prototype) {
            injectionPoint(prototype.injectionPoint());
            startingPhase(prototype.startingPhase());
            targetPhase(prototype.targetPhase());
            throwIfError(prototype.throwIfError());
            return self();
        }

        /**
         * Update this builder from an existing prototype builder instance.
         *
         * @param builder existing builder prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(ActivationRequest.BuilderBase<?, ?> builder) {
            builder.injectionPoint().ifPresent(this::injectionPoint);
            builder.startingPhase().ifPresent(this::startingPhase);
            targetPhase(builder.targetPhase());
            throwIfError(builder.throwIfError());
            return self();
        }

        /**
         * Clear existing value of this property.
         *
         * @return updated builder instance
         * @see #injectionPoint()
         */
        public BUILDER clearInjectionPoint() {
            this.injectionPoint = null;
            return self();
        }

        /**
         * Optionally, the injection point context information.
         *
         * @param injectionPoint injection point info
         * @return updated builder instance
         * @see #injectionPoint()
         */
        public BUILDER injectionPoint(InjectionPointInfo injectionPoint) {
            Objects.requireNonNull(injectionPoint);
            this.injectionPoint = injectionPoint;
            return self();
        }

        /**
         * Optionally, the injection point context information.
         *
         * @param consumer injection point info
         * @return updated builder instance
         * @see #injectionPoint()
         */
        public BUILDER injectionPoint(Consumer<InjectionPointInfo.Builder> consumer) {
            Objects.requireNonNull(consumer);
            var builder = InjectionPointInfo.builder();
            consumer.accept(builder);
            this.injectionPoint(builder.build());
            return self();
        }

        /**
         * Clear existing value of this property.
         *
         * @return updated builder instance
         * @see #startingPhase()
         */
        public BUILDER clearStartingPhase() {
            this.startingPhase = null;
            return self();
        }

        /**
         * The phase to start activation. Typically, this should be left as the default (i.e., PENDING).
         *
         * @param startingPhase phase to start
         * @return updated builder instance
         * @see #startingPhase()
         */
        public BUILDER startingPhase(Phase startingPhase) {
            Objects.requireNonNull(startingPhase);
            this.startingPhase = startingPhase;
            return self();
        }

        /**
         * Ultimate target phase for activation.
         *
         * @param targetPhase phase to target
         * @return updated builder instance
         * @see #targetPhase()
         */
        public BUILDER targetPhase(Phase targetPhase) {
            Objects.requireNonNull(targetPhase);
            this.targetPhase = targetPhase;
            return self();
        }

        /**
         * Whether to throw an exception on failure to activate, or return an error activation result on activation.
         *
         * @param throwIfError whether to throw on failure
         * @return updated builder instance
         * @see #throwIfError()
         */
        public BUILDER throwIfError(boolean throwIfError) {
            this.throwIfError = throwIfError;
            return self();
        }

        /**
         * Optionally, the injection point context information.
         *
         * @return the injection point
         */
        public Optional<InjectionPointInfo> injectionPoint() {
            return Optional.ofNullable(injectionPoint);
        }

        /**
         * The phase to start activation. Typically, this should be left as the default (i.e., PENDING).
         *
         * @return the starting phase
         */
        public Optional<Phase> startingPhase() {
            return Optional.ofNullable(startingPhase);
        }

        /**
         * Ultimate target phase for activation.
         *
         * @return the target phase
         */
        public Phase targetPhase() {
            return targetPhase;
        }

        /**
         * Whether to throw an exception on failure to activate, or return an error activation result on activation.
         *
         * @return the throw if error
         */
        public boolean throwIfError() {
            return throwIfError;
        }

        @Override
        public String toString() {
            return "ActivationRequestBuilder{"
                    + "injectionPoint=" + injectionPoint + ","
                    + "startingPhase=" + startingPhase + ","
                    + "targetPhase=" + targetPhase + ","
                    + "throwIfError=" + throwIfError
                    + "}";
        }

        /**
         * Handles providers and decorators.
         */
        protected void preBuildPrototype() {
        }

        /**
         * Validates required properties.
         */
        protected void validatePrototype() {
        }

        /**
         * Optionally, the injection point context information.
         *
         * @param injectionPoint injection point info
         * @return updated builder instance
         * @see #injectionPoint()
         */
        BUILDER injectionPoint(Optional<? extends InjectionPointInfo> injectionPoint) {
            Objects.requireNonNull(injectionPoint);
            this.injectionPoint = injectionPoint.map(InjectionPointInfo.class::cast).orElse(this.injectionPoint);
            return self();
        }

        /**
         * The phase to start activation. Typically, this should be left as the default (i.e., PENDING).
         *
         * @param startingPhase phase to start
         * @return updated builder instance
         * @see #startingPhase()
         */
        BUILDER startingPhase(Optional<? extends Phase> startingPhase) {
            Objects.requireNonNull(startingPhase);
            this.startingPhase = startingPhase.map(io.helidon.inject.api.Phase.class::cast).orElse(this.startingPhase);
            return self();
        }

        /**
         * Generated implementation of the prototype, can be extended by descendant prototype implementations.
         */
        protected static class ActivationRequestImpl implements ActivationRequest {

            private final boolean throwIfError;
            private final Optional<InjectionPointInfo> injectionPoint;
            private final Optional<Phase> startingPhase;
            private final Phase targetPhase;

            /**
             * Create an instance providing a builder.
             *
             * @param builder extending builder base of this prototype
             */
            protected ActivationRequestImpl(ActivationRequest.BuilderBase<?, ?> builder) {
                this.injectionPoint = builder.injectionPoint();
                this.startingPhase = builder.startingPhase();
                this.targetPhase = builder.targetPhase();
                this.throwIfError = builder.throwIfError();
            }

            @Override
            public Optional<InjectionPointInfo> injectionPoint() {
                return injectionPoint;
            }

            @Override
            public Optional<Phase> startingPhase() {
                return startingPhase;
            }

            @Override
            public Phase targetPhase() {
                return targetPhase;
            }

            @Override
            public boolean throwIfError() {
                return throwIfError;
            }

            @Override
            public String toString() {
                return "ActivationRequest{"
                        + "injectionPoint=" + injectionPoint + ","
                        + "startingPhase=" + startingPhase + ","
                        + "targetPhase=" + targetPhase + ","
                        + "throwIfError=" + throwIfError
                        + "}";
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ActivationRequest other)) {
                    return false;
                }
                return Objects.equals(injectionPoint, other.injectionPoint())
                        && Objects.equals(startingPhase, other.startingPhase())
                        && Objects.equals(targetPhase, other.targetPhase())
                        && throwIfError == other.throwIfError();
            }

            @Override
            public int hashCode() {
                return Objects.hash(injectionPoint, startingPhase, targetPhase, throwIfError);
            }

        }

    }

    /**
     * Fluent API builder for {@link ActivationRequest}.
     */
    class Builder extends ActivationRequest.BuilderBase<ActivationRequest.Builder, ActivationRequest> implements io.helidon.common.Builder<ActivationRequest.Builder, ActivationRequest> {

        private Builder() {
        }

        @Override
        public ActivationRequest buildPrototype() {
            preBuildPrototype();
            validatePrototype();
            return new ActivationRequestImpl(this);
        }

        @Override
        public ActivationRequest build() {
            return buildPrototype();
        }

    }

}
