/*
 * Copyright (c) 2024 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.helidon.inject.api;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.types.TypeName;

/**
 * Criteria to discover services.
 *
 * @deprecated Helidon inject is deprecated and will be replaced in a future version
 * @see Services
 * @see ServiceInfo
 * @see #builder()
 * @see #create()
 */
@Generated(value = "io.helidon.builder.processor.BlueprintProcessor", trigger = "io.helidon.inject.api.ServiceInfoCriteriaBlueprint")
public interface ServiceInfoCriteria extends ServiceInfoCriteriaBlueprint, Prototype.Api {

    /**
     * Create a new fluent API builder to customize configuration.
     *
     * @return a new builder
     */
    static ServiceInfoCriteria.Builder builder() {
        return new ServiceInfoCriteria.Builder();
    }

    /**
     * Create a new fluent API builder from an existing instance.
     *
     * @param instance an existing instance used as a base for the builder
     * @return a builder based on an instance
     */
    static ServiceInfoCriteria.Builder builder(ServiceInfoCriteria instance) {
        return ServiceInfoCriteria.builder().from(instance);
    }

    /**
     * Create a new instance with default values.
     *
     * @return a new instance
     */
    static ServiceInfoCriteria create() {
        return ServiceInfoCriteria.builder().buildPrototype();
    }

    /**
     * Fluent API builder base for {@link ServiceInfoCriteria}.
     *
     * @param <BUILDER> type of the builder extending this abstract builder
     * @param <PROTOTYPE> type of the prototype interface that would be built by {@link #buildPrototype()}
     */
    abstract class BuilderBase<BUILDER extends ServiceInfoCriteria.BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ServiceInfoCriteria> implements Prototype.Builder<BUILDER, PROTOTYPE> {

        private final Set<Qualifier> qualifiers = new LinkedHashSet<>();
        private final Set<TypeName> contractsImplemented = new LinkedHashSet<>();
        private final Set<TypeName> externalContractsImplemented = new LinkedHashSet<>();
        private final Set<TypeName> scopeTypeNames = new LinkedHashSet<>();
        private boolean includeIntercepted = false;
        private Double weight;
        private Integer runLevel;
        private String moduleName;
        private TypeName activatorTypeName;
        private TypeName serviceTypeName;

        /**
         * Protected to support extensibility.
         */
        protected BuilderBase() {
        }

        /**
         * Update this builder from an existing prototype instance.
         *
         * @param prototype existing prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(ServiceInfoCriteria prototype) {
            serviceTypeName(prototype.serviceTypeName());
            addScopeTypeNames(prototype.scopeTypeNames());
            addQualifiers(prototype.qualifiers());
            addContractsImplemented(prototype.contractsImplemented());
            runLevel(prototype.runLevel());
            weight(prototype.weight());
            addExternalContractsImplemented(prototype.externalContractsImplemented());
            activatorTypeName(prototype.activatorTypeName());
            moduleName(prototype.moduleName());
            includeIntercepted(prototype.includeIntercepted());
            return self();
        }

        /**
         * Update this builder from an existing prototype builder instance.
         *
         * @param builder existing builder prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(ServiceInfoCriteria.BuilderBase<?, ?> builder) {
            builder.serviceTypeName().ifPresent(this::serviceTypeName);
            addScopeTypeNames(builder.scopeTypeNames());
            addQualifiers(builder.qualifiers());
            addContractsImplemented(builder.contractsImplemented());
            builder.runLevel().ifPresent(this::runLevel);
            builder.weight().ifPresent(this::weight);
            addExternalContractsImplemented(builder.externalContractsImplemented());
            builder.activatorTypeName().ifPresent(this::activatorTypeName);
            builder.moduleName().ifPresent(this::moduleName);
            includeIntercepted(builder.includeIntercepted());
            return self();
        }

        /**
         * The managed services advertised types (i.e., typically its interfaces).
         *
         * @param contract the service contracts implemented
         * @return updated builder instance
         * @see #contractsImplemented()
         */
        public BUILDER addContractImplemented(Class<?> contract) {
            ServiceInfoCriteriaBlueprint.CustomMethods.addContractImplemented(this, contract);
            return self();
        }

        /**
         * Clear existing value of this property.
         *
         * @return updated builder instance
         * @see #serviceTypeName()
         */
        public BUILDER clearServiceTypeName() {
            this.serviceTypeName = null;
            return self();
        }

        /**
         * The managed service implementation type name.
         *
         * @param serviceTypeName the service type name
         * @return updated builder instance
         * @see #serviceTypeName()
         */
        public BUILDER serviceTypeName(TypeName serviceTypeName) {
            Objects.requireNonNull(serviceTypeName);
            this.serviceTypeName = serviceTypeName;
            return self();
        }

        /**
         * The managed service implementation type name.
         *
         * @param consumer the service type name
         * @return updated builder instance
         * @see #serviceTypeName()
         */
        public BUILDER serviceTypeName(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            var builder = TypeName.builder();
            consumer.accept(builder);
            this.serviceTypeName(builder.build());
            return self();
        }

        /**
         * The managed service assigned Scope's.
         *
         * @param scopeTypeNames the service scope type name
         * @return updated builder instance
         * @see #scopeTypeNames()
         */
        public BUILDER scopeTypeNames(Set<? extends TypeName> scopeTypeNames) {
            Objects.requireNonNull(scopeTypeNames);
            this.scopeTypeNames.clear();
            this.scopeTypeNames.addAll(scopeTypeNames);
            return self();
        }

        /**
         * The managed service assigned Scope's.
         *
         * @param scopeTypeNames the service scope type name
         * @return updated builder instance
         * @see #scopeTypeNames()
         */
        public BUILDER addScopeTypeNames(Set<? extends TypeName> scopeTypeNames) {
            Objects.requireNonNull(scopeTypeNames);
            this.scopeTypeNames.addAll(scopeTypeNames);
            return self();
        }

        /**
         * The managed service assigned Scope's.
         *
         * @param scopeTypeName the service scope type name
         * @return updated builder instance
         * @see #scopeTypeNames()
         */
        public BUILDER addScopeTypeName(TypeName scopeTypeName) {
            Objects.requireNonNull(scopeTypeName);
            this.scopeTypeNames.add(scopeTypeName);
            return self();
        }

        /**
         * The managed service assigned Scope's.
         *
         * @param consumer the service scope type name
         * @return updated builder instance
         * @see #scopeTypeNames()
         */
        public BUILDER addScopeTypeName(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            var builder = TypeName.builder();
            consumer.accept(builder);
            this.scopeTypeNames.add(builder.build());
            return self();
        }

        /**
         * The managed service assigned Qualifier's.
         *
         * @param qualifiers the service qualifiers
         * @return updated builder instance
         * @see #qualifiers()
         */
        public BUILDER qualifiers(Set<? extends Qualifier> qualifiers) {
            Objects.requireNonNull(qualifiers);
            this.qualifiers.clear();
            this.qualifiers.addAll(qualifiers);
            return self();
        }

        /**
         * The managed service assigned Qualifier's.
         *
         * @param qualifiers the service qualifiers
         * @return updated builder instance
         * @see #qualifiers()
         */
        public BUILDER addQualifiers(Set<? extends Qualifier> qualifiers) {
            Objects.requireNonNull(qualifiers);
            this.qualifiers.addAll(qualifiers);
            return self();
        }

        /**
         * The managed service assigned Qualifier's.
         *
         * @param qualifier the service qualifiers
         * @return updated builder instance
         * @see #qualifiers()
         */
        public BUILDER addQualifier(Qualifier qualifier) {
            Objects.requireNonNull(qualifier);
            this.qualifiers.add(qualifier);
            return self();
        }

        /**
         * The managed service assigned Qualifier's.
         *
         * @param consumer the service qualifiers
         * @return updated builder instance
         * @see #qualifiers()
         */
        public BUILDER addQualifier(Consumer<Qualifier.Builder> consumer) {
            Objects.requireNonNull(consumer);
            var builder = Qualifier.builder();
            consumer.accept(builder);
            this.qualifiers.add(builder.build());
            return self();
        }

        /**
         * The managed services advertised types (i.e., typically its interfaces).
         *
         * @param contractsImplemented the service contracts implemented
         * @return updated builder instance
         * @see #contractsImplemented()
         */
        public BUILDER contractsImplemented(Set<? extends TypeName> contractsImplemented) {
            Objects.requireNonNull(contractsImplemented);
            this.contractsImplemented.clear();
            this.contractsImplemented.addAll(contractsImplemented);
            return self();
        }

        /**
         * The managed services advertised types (i.e., typically its interfaces).
         *
         * @param contractsImplemented the service contracts implemented
         * @return updated builder instance
         * @see #contractsImplemented()
         */
        public BUILDER addContractsImplemented(Set<? extends TypeName> contractsImplemented) {
            Objects.requireNonNull(contractsImplemented);
            this.contractsImplemented.addAll(contractsImplemented);
            return self();
        }

        /**
         * The managed services advertised types (i.e., typically its interfaces).
         *
         * @param contractImplemented the service contracts implemented
         * @return updated builder instance
         * @see ExternalContracts
         * @see #contractsImplemented()
         */
        public BUILDER addContractImplemented(TypeName contractImplemented) {
            Objects.requireNonNull(contractImplemented);
            this.contractsImplemented.add(contractImplemented);
            return self();
        }

        /**
         * The managed services advertised types (i.e., typically its interfaces).
         *
         * @param consumer the service contracts implemented
         * @return updated builder instance
         * @see ExternalContracts
         * @see #contractsImplemented()
         * @see #contractsImplemented()
         */
        public BUILDER addContractImplemented(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            var builder = TypeName.builder();
            consumer.accept(builder);
            this.contractsImplemented.add(builder.build());
            return self();
        }

        /**
         * Clear existing value of this property.
         *
         * @return updated builder instance
         * @see #runLevel()
         */
        public BUILDER clearRunLevel() {
            this.runLevel = null;
            return self();
        }

        /**
         * The optional {@link RunLevel} ascribed to the service.
         *
         * @param runLevel the service's run level
         * @return updated builder instance
         * @see #runLevel()
         */
        public BUILDER runLevel(int runLevel) {
            Objects.requireNonNull(runLevel);
            this.runLevel = runLevel;
            return self();
        }

        /**
         * Clear existing value of this property.
         *
         * @return updated builder instance
         * @see #weight()
         */
        public BUILDER clearWeight() {
            this.weight = null;
            return self();
        }

        /**
         * Weight that was declared on the type itself.
         *
         * @param weight the declared weight
         * @return updated builder instance
         * @see #weight()
         */
        public BUILDER weight(double weight) {
            Objects.requireNonNull(weight);
            this.weight = weight;
            return self();
        }

        /**
         * The managed services external contracts / interfaces. These should also be contained within
         * {@link #contractsImplemented()}. External contracts are from other modules other than the module containing
         * the implementation typically.
         *
         * @param externalContractsImplemented the service external contracts implemented
         * @return updated builder instance
         * @see #externalContractsImplemented()
         */
        public BUILDER externalContractsImplemented(Set<? extends TypeName> externalContractsImplemented) {
            Objects.requireNonNull(externalContractsImplemented);
            this.externalContractsImplemented.clear();
            this.externalContractsImplemented.addAll(externalContractsImplemented);
            return self();
        }

        /**
         * The managed services external contracts / interfaces. These should also be contained within
         * {@link #contractsImplemented()}. External contracts are from other modules other than the module containing
         * the implementation typically.
         *
         * @param externalContractsImplemented the service external contracts implemented
         * @return updated builder instance
         * @see #externalContractsImplemented()
         */
        public BUILDER addExternalContractsImplemented(Set<? extends TypeName> externalContractsImplemented) {
            Objects.requireNonNull(externalContractsImplemented);
            this.externalContractsImplemented.addAll(externalContractsImplemented);
            return self();
        }

        /**
         * The managed services external contracts / interfaces. These should also be contained within
         * {@link #contractsImplemented()}. External contracts are from other modules other than the module containing
         * the implementation typically.
         *
         * @param externalContractImplemented the service external contracts implemented
         * @return updated builder instance
         * @see ExternalContracts
         * @see #externalContractsImplemented()
         */
        public BUILDER addExternalContractImplemented(TypeName externalContractImplemented) {
            Objects.requireNonNull(externalContractImplemented);
            this.externalContractsImplemented.add(externalContractImplemented);
            return self();
        }

        /**
         * The managed services external contracts / interfaces. These should also be contained within
         * {@link #contractsImplemented()}. External contracts are from other modules other than the module containing
         * the implementation typically.
         *
         * @param consumer the service external contracts implemented
         * @return updated builder instance
         * @see ExternalContracts
         * @see #externalContractsImplemented()
         * @see #externalContractsImplemented()
         */
        public BUILDER addExternalContractImplemented(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            var builder = TypeName.builder();
            consumer.accept(builder);
            this.externalContractsImplemented.add(builder.build());
            return self();
        }

        /**
         * Clear existing value of this property.
         *
         * @return updated builder instance
         * @see #activatorTypeName()
         */
        public BUILDER clearActivatorTypeName() {
            this.activatorTypeName = null;
            return self();
        }

        /**
         * The management agent (i.e., the activator) that is responsible for creating and activating - typically build-time created.
         *
         * @param activatorTypeName the activator type name
         * @return updated builder instance
         * @see #activatorTypeName()
         */
        public BUILDER activatorTypeName(TypeName activatorTypeName) {
            Objects.requireNonNull(activatorTypeName);
            this.activatorTypeName = activatorTypeName;
            return self();
        }

        /**
         * The management agent (i.e., the activator) that is responsible for creating and activating - typically build-time created.
         *
         * @param consumer the activator type name
         * @return updated builder instance
         * @see #activatorTypeName()
         */
        public BUILDER activatorTypeName(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            var builder = TypeName.builder();
            consumer.accept(builder);
            this.activatorTypeName(builder.build());
            return self();
        }

        /**
         * Clear existing value of this property.
         *
         * @return updated builder instance
         * @see #moduleName()
         */
        public BUILDER clearModuleName() {
            this.moduleName = null;
            return self();
        }

        /**
         * The name of the ascribed module, if known.
         *
         * @param moduleName the module name
         * @return updated builder instance
         * @see #moduleName()
         */
        public BUILDER moduleName(String moduleName) {
            Objects.requireNonNull(moduleName);
            this.moduleName = moduleName;
            return self();
        }

        /**
         * Determines whether the non-proxied, {@link Intercepted} services should be returned in any lookup operation. If this
         * option is disabled then only the {@link Interceptor}-generated service will be eligible to be returned and not the service
         * being intercepted.
         * The default value is {@code false}.
         *
         * @param includeIntercepted true if the non-proxied type intercepted services should be eligible
         * @return updated builder instance
         * @see #includeIntercepted()
         */
        public BUILDER includeIntercepted(boolean includeIntercepted) {
            this.includeIntercepted = includeIntercepted;
            return self();
        }

        /**
         * The managed service implementation type name.
         *
         * @return the service type name
         */
        public Optional<TypeName> serviceTypeName() {
            return Optional.ofNullable(serviceTypeName);
        }

        /**
         * The managed service assigned Scope's.
         *
         * @return the scope type names
         */
        public Set<TypeName> scopeTypeNames() {
            return scopeTypeNames;
        }

        /**
         * The managed service assigned Qualifier's.
         *
         * @return the qualifiers
         */
        public Set<Qualifier> qualifiers() {
            return qualifiers;
        }

        /**
         * The managed services advertised types (i.e., typically its interfaces).
         *
         * @return the contracts implemented
         * @see ExternalContracts
         * @see #contractsImplemented()
         * @see #contractsImplemented()
         */
        public Set<TypeName> contractsImplemented() {
            return contractsImplemented;
        }

        /**
         * The optional {@link RunLevel} ascribed to the service.
         *
         * @return the run level
         */
        public Optional<Integer> runLevel() {
            return Optional.ofNullable(runLevel);
        }

        /**
         * Weight that was declared on the type itself.
         *
         * @return the weight
         */
        public Optional<Double> weight() {
            return Optional.ofNullable(weight);
        }

        /**
         * The managed services external contracts / interfaces. These should also be contained within
         * {@link #contractsImplemented()}. External contracts are from other modules other than the module containing
         * the implementation typically.
         *
         * @return the external contracts implemented
         * @see ExternalContracts
         * @see #externalContractsImplemented()
         * @see #externalContractsImplemented()
         */
        public Set<TypeName> externalContractsImplemented() {
            return externalContractsImplemented;
        }

        /**
         * The management agent (i.e., the activator) that is responsible for creating and activating - typically build-time created.
         *
         * @return the activator type name
         */
        public Optional<TypeName> activatorTypeName() {
            return Optional.ofNullable(activatorTypeName);
        }

        /**
         * The name of the ascribed module, if known.
         *
         * @return the module name
         */
        public Optional<String> moduleName() {
            return Optional.ofNullable(moduleName);
        }

        /**
         * Determines whether the non-proxied, {@link Intercepted} services should be returned in any lookup operation. If this
         * option is disabled then only the {@link Interceptor}-generated service will be eligible to be returned and not the service
         * being intercepted.
         * The default value is {@code false}.
         *
         * @return the include intercepted
         */
        public boolean includeIntercepted() {
            return includeIntercepted;
        }

        @Override
        public String toString() {
            return "ServiceInfoCriteriaBuilder{"
                    + "serviceTypeName=" + serviceTypeName + ","
                    + "scopeTypeNames=" + scopeTypeNames + ","
                    + "qualifiers=" + qualifiers + ","
                    + "contractsImplemented=" + contractsImplemented + ","
                    + "runLevel=" + runLevel + ","
                    + "weight=" + weight + ","
                    + "externalContractsImplemented=" + externalContractsImplemented + ","
                    + "activatorTypeName=" + activatorTypeName + ","
                    + "moduleName=" + moduleName + ","
                    + "includeIntercepted=" + includeIntercepted
                    + "}";
        }

        /**
         * Handles providers and decorators.
         */
        protected void preBuildPrototype() {
        }

        /**
         * Validates required properties.
         */
        protected void validatePrototype() {
        }

        /**
         * The managed service implementation type name.
         *
         * @param serviceTypeName the service type name
         * @return updated builder instance
         * @see #serviceTypeName()
         */
        BUILDER serviceTypeName(Optional<? extends TypeName> serviceTypeName) {
            Objects.requireNonNull(serviceTypeName);
            this.serviceTypeName = serviceTypeName.map(io.helidon.common.types.TypeName.class::cast).orElse(this.serviceTypeName);
            return self();
        }

        /**
         * The optional {@link RunLevel} ascribed to the service.
         *
         * @param runLevel the service's run level
         * @return updated builder instance
         * @see #runLevel()
         */
        BUILDER runLevel(Optional<Integer> runLevel) {
            Objects.requireNonNull(runLevel);
            this.runLevel = runLevel.map(java.lang.Integer.class::cast).orElse(this.runLevel);
            return self();
        }

        /**
         * Weight that was declared on the type itself.
         *
         * @param weight the declared weight
         * @return updated builder instance
         * @see #weight()
         */
        BUILDER weight(Optional<Double> weight) {
            Objects.requireNonNull(weight);
            this.weight = weight.map(java.lang.Double.class::cast).orElse(this.weight);
            return self();
        }

        /**
         * The management agent (i.e., the activator) that is responsible for creating and activating - typically build-time created.
         *
         * @param activatorTypeName the activator type name
         * @return updated builder instance
         * @see #activatorTypeName()
         */
        BUILDER activatorTypeName(Optional<? extends TypeName> activatorTypeName) {
            Objects.requireNonNull(activatorTypeName);
            this.activatorTypeName = activatorTypeName.map(io.helidon.common.types.TypeName.class::cast).orElse(this.activatorTypeName);
            return self();
        }

        /**
         * The name of the ascribed module, if known.
         *
         * @param moduleName the module name
         * @return updated builder instance
         * @see #moduleName()
         */
        BUILDER moduleName(Optional<String> moduleName) {
            Objects.requireNonNull(moduleName);
            this.moduleName = moduleName.map(java.lang.String.class::cast).orElse(this.moduleName);
            return self();
        }

        /**
         * Generated implementation of the prototype, can be extended by descendant prototype implementations.
         */
        protected static class ServiceInfoCriteriaImpl implements ServiceInfoCriteria {

            private final boolean includeIntercepted;
            private final Optional<TypeName> activatorTypeName;
            private final Optional<TypeName> serviceTypeName;
            private final Optional<Double> weight;
            private final Optional<Integer> runLevel;
            private final Optional<String> moduleName;
            private final Set<Qualifier> qualifiers;
            private final Set<TypeName> contractsImplemented;
            private final Set<TypeName> externalContractsImplemented;
            private final Set<TypeName> scopeTypeNames;

            /**
             * Create an instance providing a builder.
             *
             * @param builder extending builder base of this prototype
             */
            protected ServiceInfoCriteriaImpl(ServiceInfoCriteria.BuilderBase<?, ?> builder) {
                this.serviceTypeName = builder.serviceTypeName();
                this.scopeTypeNames = Collections.unmodifiableSet(new LinkedHashSet<>(builder.scopeTypeNames()));
                this.qualifiers = Collections.unmodifiableSet(new LinkedHashSet<>(builder.qualifiers()));
                this.contractsImplemented = Collections.unmodifiableSet(new LinkedHashSet<>(builder.contractsImplemented()));
                this.runLevel = builder.runLevel();
                this.weight = builder.weight();
                this.externalContractsImplemented = Collections.unmodifiableSet(new LinkedHashSet<>(builder.externalContractsImplemented()));
                this.activatorTypeName = builder.activatorTypeName();
                this.moduleName = builder.moduleName();
                this.includeIntercepted = builder.includeIntercepted();
            }

            @Override
            public Optional<TypeName> serviceTypeName() {
                return serviceTypeName;
            }

            @Override
            public Set<TypeName> scopeTypeNames() {
                return scopeTypeNames;
            }

            @Override
            public Set<Qualifier> qualifiers() {
                return qualifiers;
            }

            @Override
            public Set<TypeName> contractsImplemented() {
                return contractsImplemented;
            }

            @Override
            public Optional<Integer> runLevel() {
                return runLevel;
            }

            @Override
            public Optional<Double> weight() {
                return weight;
            }

            @Override
            public Set<TypeName> externalContractsImplemented() {
                return externalContractsImplemented;
            }

            @Override
            public Optional<TypeName> activatorTypeName() {
                return activatorTypeName;
            }

            @Override
            public Optional<String> moduleName() {
                return moduleName;
            }

            @Override
            public boolean includeIntercepted() {
                return includeIntercepted;
            }

            @Override
            public String toString() {
                return "ServiceInfoCriteria{"
                        + "serviceTypeName=" + serviceTypeName + ","
                        + "scopeTypeNames=" + scopeTypeNames + ","
                        + "qualifiers=" + qualifiers + ","
                        + "contractsImplemented=" + contractsImplemented + ","
                        + "runLevel=" + runLevel + ","
                        + "weight=" + weight + ","
                        + "externalContractsImplemented=" + externalContractsImplemented + ","
                        + "activatorTypeName=" + activatorTypeName + ","
                        + "moduleName=" + moduleName + ","
                        + "includeIntercepted=" + includeIntercepted
                        + "}";
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ServiceInfoCriteria other)) {
                    return false;
                }
                return Objects.equals(serviceTypeName, other.serviceTypeName())
                        && Objects.equals(scopeTypeNames, other.scopeTypeNames())
                        && Objects.equals(qualifiers, other.qualifiers())
                        && Objects.equals(contractsImplemented, other.contractsImplemented())
                        && Objects.equals(runLevel, other.runLevel())
                        && Objects.equals(weight, other.weight())
                        && Objects.equals(externalContractsImplemented, other.externalContractsImplemented())
                        && Objects.equals(activatorTypeName, other.activatorTypeName())
                        && Objects.equals(moduleName, other.moduleName())
                        && includeIntercepted == other.includeIntercepted();
            }

            @Override
            public int hashCode() {
                return Objects.hash(serviceTypeName, scopeTypeNames, qualifiers, contractsImplemented, runLevel, weight, externalContractsImplemented, activatorTypeName, moduleName, includeIntercepted);
            }

        }

    }

    /**
     * Fluent API builder for {@link ServiceInfoCriteria}.
     */
    class Builder extends ServiceInfoCriteria.BuilderBase<ServiceInfoCriteria.Builder, ServiceInfoCriteria> implements io.helidon.common.Builder<ServiceInfoCriteria.Builder, ServiceInfoCriteria> {

        private Builder() {
        }

        @Override
        public ServiceInfoCriteria buildPrototype() {
            preBuildPrototype();
            validatePrototype();
            return new ServiceInfoCriteriaImpl(this);
        }

        @Override
        public ServiceInfoCriteria build() {
            return buildPrototype();
        }

    }

}
