/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.cdi.jpa;

import io.helidon.integrations.cdi.jpa.DelegatingEntityManager;
import io.helidon.integrations.cdi.jpa.EntityManagers;
import io.helidon.integrations.cdi.jpa.TransactionSupport;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Vetoed;
import jakarta.persistence.EntityManager;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

@Vetoed
class CdiTransactionScopedEntityManager
extends DelegatingEntityManager {
    private final Instance<Object> instance;
    private final Set<? extends Annotation> suppliedQualifiers;
    private final TransactionSupport transactionSupport;
    private EntityManager delegate;
    private boolean closeDelegate;
    private boolean closed;

    @Deprecated
    CdiTransactionScopedEntityManager() {
        this.closeDelegate = true;
        this.instance = null;
        this.transactionSupport = null;
        this.suppliedQualifiers = Collections.emptySet();
    }

    CdiTransactionScopedEntityManager(Instance<Object> instance, Set<? extends Annotation> suppliedQualifiers) {
        this.instance = Objects.requireNonNull(instance);
        this.transactionSupport = (TransactionSupport)instance.select(TransactionSupport.class, new Annotation[0]).get();
        this.suppliedQualifiers = Objects.requireNonNull(suppliedQualifiers);
    }

    void dispose(Instance<Object> ignoredInstance) {
        this.close();
    }

    @Override
    protected EntityManager acquireDelegate() {
        if (this.delegate == null) {
            this.delegate = EntityManagers.createContainerManagedEntityManager(this.instance, this.suppliedQualifiers);
            this.closeDelegate = true;
        }
        assert (this.delegate != null);
        return this.delegate;
    }

    void setDelegate(EntityManager delegate) {
        Objects.requireNonNull(delegate);
        if (delegate == this) {
            throw new IllegalArgumentException("delegate == this");
        }
        if (this.delegate != null) {
            throw new IllegalStateException();
        }
        this.delegate = delegate;
        this.closeDelegate = false;
    }

    @Override
    public boolean isOpen() {
        return !this.closed && super.isOpen();
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.closeDelegate) {
            super.close();
            assert (this.delegate == null || !this.delegate.isOpen());
        }
    }
}

