/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.cdi.jpa;

import io.helidon.integrations.cdi.jpa.ContainerManaged;
import io.helidon.integrations.cdi.jpa.JpaCdiQualifiers;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Named;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

final class EntityManagerFactories {
    private static final Logger LOGGER = Logger.getLogger(EntityManagerFactories.class.getName(), EntityManagerFactories.class.getPackage().getName() + ".Messages");

    private EntityManagerFactories() {
    }

    static EntityManagerFactory getContainerManagedEntityManagerFactory(Instance<Object> instance, Set<? extends Annotation> suppliedQualifiers) {
        Set<ContainerManaged> selectionQualifiers;
        String cn = EntityManagerFactories.class.getName();
        String mn = "getContainerManagedEntityManagerFactory";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "getContainerManagedEntityManagerFactory", new Object[]{instance, suppliedQualifiers});
        }
        Objects.requireNonNull(instance);
        Objects.requireNonNull(suppliedQualifiers);
        if (suppliedQualifiers.isEmpty()) {
            selectionQualifiers = Collections.singleton(ContainerManaged.Literal.INSTANCE);
        } else {
            selectionQualifiers = new HashSet<Annotation>(suppliedQualifiers);
            selectionQualifiers.remove(Any.Literal.INSTANCE);
            selectionQualifiers.removeAll(JpaCdiQualifiers.JPA_CDI_QUALIFIERS);
            selectionQualifiers.add(ContainerManaged.Literal.INSTANCE);
        }
        EntityManagerFactory returnValue = (EntityManagerFactory)instance.select(EntityManagerFactory.class, selectionQualifiers.toArray(new Annotation[selectionQualifiers.size()])).get();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "getContainerManagedEntityManagerFactory", returnValue);
        }
        return returnValue;
    }

    static EntityManagerFactory createContainerManagedEntityManagerFactory(Instance<Object> instance, Set<? extends Annotation> suppliedQualifiers, BeanManager beanManager) {
        Instance validatorFactoryInstance;
        Class<?> validatorFactoryClass;
        HashMap<String, Object> properties;
        PersistenceProvider persistenceProvider;
        PersistenceUnitInfo pu;
        String cn;
        block11: {
            cn = EntityManagerFactories.class.getName();
            String mn = "createContainerManagedEntityManagerFactory";
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.entering(cn, "createContainerManagedEntityManagerFactory", new Object[]{instance, suppliedQualifiers});
            }
            Objects.requireNonNull(instance);
            Objects.requireNonNull(suppliedQualifiers);
            Objects.requireNonNull(beanManager);
            pu = EntityManagerFactories.getPersistenceUnitInfo(instance, suppliedQualifiers);
            assert (pu != null);
            if (LOGGER.isLoggable(Level.WARNING) && PersistenceUnitTransactionType.RESOURCE_LOCAL.equals((Object)pu.getTransactionType())) {
                LOGGER.logp(Level.WARNING, cn, "createContainerManagedEntityManagerFactory", "resourceLocalPersistenceUnitWarning", pu);
            }
            persistenceProvider = null;
            try {
                persistenceProvider = EntityManagerFactories.getPersistenceProvider(instance, suppliedQualifiers, pu);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new PersistenceException(reflectiveOperationException.getMessage(), (Throwable)reflectiveOperationException);
            }
            properties = new HashMap<String, Object>();
            properties.put("jakarta.persistence.bean.manager", beanManager);
            validatorFactoryClass = null;
            try {
                validatorFactoryClass = Class.forName("jakarta.validation.ValidatorFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!LOGGER.isLoggable(Level.INFO)) break block11;
                LOGGER.logp(Level.INFO, cn, "createContainerManagedEntityManagerFactory", "noValidatorFactoryClass", classNotFoundException);
            }
        }
        if (validatorFactoryClass != null && !(validatorFactoryInstance = instance.select(validatorFactoryClass, new Annotation[0])).isUnsatisfied()) {
            properties.put("jakarta.persistence.validation.factory", validatorFactoryInstance.get());
        }
        EntityManagerFactory returnValue = persistenceProvider.createContainerEntityManagerFactory(pu, properties);
        assert (returnValue != null);
        assert (returnValue.isOpen());
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "createContainerManagedEntityManagerFactory", returnValue);
        }
        return returnValue;
    }

    private static PersistenceProvider getPersistenceProvider(Instance<Object> instance, Set<? extends Annotation> suppliedQualifiers, PersistenceUnitInfo persistenceUnitInfo) throws ReflectiveOperationException {
        String cn = EntityManagerFactories.class.getName();
        String mn = "getPersistenceProvider";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "getPersistenceProvider", new Object[]{instance, suppliedQualifiers, persistenceUnitInfo});
        }
        Objects.requireNonNull(instance);
        Objects.requireNonNull(suppliedQualifiers);
        Objects.requireNonNull(persistenceUnitInfo);
        HashSet<? extends Annotation> selectionQualifiers = new HashSet<Annotation>(suppliedQualifiers);
        selectionQualifiers.remove(Any.Literal.INSTANCE);
        selectionQualifiers.removeAll(JpaCdiQualifiers.JPA_CDI_QUALIFIERS);
        selectionQualifiers.removeIf(q -> q instanceof Named);
        Annotation[] selectionQualifiersArray = selectionQualifiers.toArray(new Annotation[selectionQualifiers.size()]);
        String providerClassName = persistenceUnitInfo.getPersistenceProviderClassName();
        PersistenceProvider returnValue = providerClassName == null ? (PersistenceProvider)instance.select(PersistenceProvider.class, selectionQualifiersArray).get() : (PersistenceProvider)instance.select(Class.forName(providerClassName, true, Thread.currentThread().getContextClassLoader()), selectionQualifiersArray).get();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "getPersistenceProvider", returnValue);
        }
        return returnValue;
    }

    private static PersistenceUnitInfo getPersistenceUnitInfo(Instance<Object> instance, Set<? extends Annotation> suppliedQualifiers) {
        Instance puInstance;
        String cn = EntityManagerFactories.class.getName();
        String mn = "getPersistenceUnitInfo";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "getPersistenceUnitInfo", new Object[]{instance, suppliedQualifiers});
        }
        Objects.requireNonNull(instance);
        Objects.requireNonNull(suppliedQualifiers);
        HashSet<? extends Annotation> selectionQualifiers = new HashSet<Annotation>(suppliedQualifiers);
        selectionQualifiers.remove(Any.Literal.INSTANCE);
        selectionQualifiers.removeAll(JpaCdiQualifiers.JPA_CDI_QUALIFIERS);
        if (selectionQualifiers.isEmpty()) {
            puInstance = instance.select(PersistenceUnitInfo.class, new Annotation[0]);
        } else {
            puInstance = instance.select(PersistenceUnitInfo.class, selectionQualifiers.toArray(new Annotation[selectionQualifiers.size()]));
            if (puInstance.isUnsatisfied()) {
                selectionQualifiers.removeIf(q -> q instanceof Named);
                puInstance = instance.select(PersistenceUnitInfo.class, selectionQualifiers.toArray(new Annotation[selectionQualifiers.size()]));
                if (puInstance.isUnsatisfied() && !selectionQualifiers.equals(Collections.singleton(Default.Literal.INSTANCE)) && (puInstance = instance.select(PersistenceUnitInfo.class, new Annotation[0])).isUnsatisfied()) {
                    puInstance = instance.select(PersistenceUnitInfo.class, new Annotation[]{Any.Literal.INSTANCE});
                }
            }
        }
        PersistenceUnitInfo returnValue = (PersistenceUnitInfo)puInstance.get();
        assert (returnValue != null);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "getPersistenceUnitInfo", returnValue);
        }
        return returnValue;
    }
}

