/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.cdi.jpa;

import io.helidon.integrations.cdi.jpa.ContainerManaged;
import io.helidon.integrations.cdi.jpa.EntityManagerFactories;
import io.helidon.integrations.cdi.jpa.JpaCdiQualifiers;
import io.helidon.integrations.cdi.jpa.Unsynchronized;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.SynchronizationType;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

final class EntityManagers {
    private static final Logger LOGGER = Logger.getLogger(EntityManagers.class.getName(), EntityManagers.class.getPackage().getName() + ".Messages");

    private EntityManagers() {
    }

    static EntityManager createContainerManagedEntityManager(Instance<Object> instance, Set<? extends Annotation> suppliedQualifiers) {
        return EntityManagers.createContainerManagedEntityManager(instance, suppliedQualifiers, null);
    }

    static EntityManager createContainerManagedEntityManager(Instance<Object> instance, Set<? extends Annotation> suppliedQualifiers, SynchronizationType syncType) {
        Set<ContainerManaged> selectionQualifiers;
        String cn = EntityManagers.class.getName();
        String mn = "createContainerManagedEntityManager";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "createContainerManagedEntityManager", new Object[]{instance, suppliedQualifiers});
        }
        Objects.requireNonNull(instance);
        Objects.requireNonNull(suppliedQualifiers);
        EntityManagerFactory emf = EntityManagerFactories.getContainerManagedEntityManagerFactory(instance, suppliedQualifiers);
        assert (emf != null);
        assert (emf.isOpen());
        if (suppliedQualifiers.isEmpty()) {
            selectionQualifiers = Collections.singleton(ContainerManaged.Literal.INSTANCE);
        } else {
            selectionQualifiers = new HashSet<Annotation>(suppliedQualifiers);
            selectionQualifiers.remove(Any.Literal.INSTANCE);
            selectionQualifiers.add(ContainerManaged.Literal.INSTANCE);
        }
        TypeLiteral typeLiteral = new TypeLiteral<Map<? extends String, ?>>(){
            private static final long serialVersionUID = 1L;
        };
        HashMap<String, SynchronizationType> properties = new HashMap<String, SynchronizationType>();
        Instance propertiesInstance = instance.select(typeLiteral, selectionQualifiers.toArray(new Annotation[selectionQualifiers.size()]));
        if (propertiesInstance != null && !propertiesInstance.isUnsatisfied()) {
            selectionQualifiers.removeAll(JpaCdiQualifiers.JPA_CDI_QUALIFIERS);
            selectionQualifiers.add(ContainerManaged.Literal.INSTANCE);
            propertiesInstance = instance.select(typeLiteral, selectionQualifiers.toArray(new Annotation[selectionQualifiers.size()]));
            if (propertiesInstance != null && !propertiesInstance.isUnsatisfied()) {
                properties.putAll((Map)propertiesInstance.get());
            }
        }
        if (syncType == null) {
            SynchronizationType synchronizationType = syncType = suppliedQualifiers.contains(Unsynchronized.Literal.INSTANCE) ? SynchronizationType.UNSYNCHRONIZED : SynchronizationType.SYNCHRONIZED;
        }
        assert (!properties.containsKey(SynchronizationType.class.getName()));
        properties.put(SynchronizationType.class.getName(), syncType);
        EntityManager returnValue = emf.createEntityManager(syncType, properties);
        assert (returnValue != null);
        assert (returnValue.isOpen());
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "createContainerManagedEntityManager", returnValue);
        }
        return returnValue;
    }

    static SynchronizationType getSynchronizationTypeFor(EntityManager entityManager) {
        Object propertyValue;
        Map properties;
        SynchronizationType returnValue = entityManager == null ? null : ((properties = entityManager.getProperties()) == null || properties.isEmpty() ? null : ((propertyValue = properties.get(SynchronizationType.class.getName())) instanceof SynchronizationType ? (SynchronizationType)propertyValue : null));
        return returnValue;
    }
}

