/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.cdi.jpa;

import io.helidon.integrations.cdi.jpa.CdiTransactionScoped;
import io.helidon.integrations.cdi.jpa.CdiTransactionScopedEntityManager;
import io.helidon.integrations.cdi.jpa.ContainerManaged;
import io.helidon.integrations.cdi.jpa.DelegatingEntityManager;
import io.helidon.integrations.cdi.jpa.EntityManagers;
import io.helidon.integrations.cdi.jpa.Extended;
import io.helidon.integrations.cdi.jpa.JpaTransactionScoped;
import io.helidon.integrations.cdi.jpa.Messages;
import io.helidon.integrations.cdi.jpa.NonTransactional;
import io.helidon.integrations.cdi.jpa.Synchronized;
import io.helidon.integrations.cdi.jpa.TransactionSupport;
import io.helidon.integrations.cdi.jpa.Unsynchronized;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.CreationException;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.persistence.EntityManager;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

final class ExtendedEntityManager
extends DelegatingEntityManager {
    private EntityManager delegate;
    private EntityManager subdelegate;
    private final TransactionSupport transactionSupport;
    private final Set<? extends Annotation> suppliedQualifiers;
    private final boolean isSynchronized;
    private final Instance<Object> instance;
    private final BeanManager beanManager;

    ExtendedEntityManager(Instance<Object> instance, Set<? extends Annotation> suppliedQualifiers, BeanManager beanManager) {
        this.instance = Objects.requireNonNull(instance);
        this.suppliedQualifiers = Objects.requireNonNull(suppliedQualifiers);
        this.beanManager = Objects.requireNonNull(beanManager);
        this.transactionSupport = Objects.requireNonNull((TransactionSupport)instance.select(TransactionSupport.class, new Annotation[0]).get());
        if (!this.transactionSupport.isEnabled()) {
            throw new IllegalArgumentException("!transactionSupport.isEnabled()");
        }
        boolean bl = this.isSynchronized = !suppliedQualifiers.contains(Unsynchronized.Literal.INSTANCE);
        assert (suppliedQualifiers.contains(Unsynchronized.Literal.INSTANCE) || suppliedQualifiers.contains(Synchronized.Literal.INSTANCE)) : "Unexpected supplied qualifiers: " + String.valueOf(suppliedQualifiers);
    }

    @Override
    protected EntityManager acquireDelegate() {
        EntityManager returnValue;
        Context context = this.transactionSupport.getContext();
        if (context == null || !context.isActive()) {
            if (this.delegate == null) {
                assert (this.subdelegate == null);
                this.delegate = EntityManagers.createContainerManagedEntityManager(this.instance, this.suppliedQualifiers);
            } else if (this.delegate instanceof CdiTransactionScopedEntityManager) {
                assert (this.subdelegate != null);
                assert (!(this.subdelegate instanceof CdiTransactionScopedEntityManager));
                assert (this.subdelegate.isOpen());
                this.delegate = this.subdelegate;
                this.subdelegate = null;
            }
            assert (this.delegate != null);
            assert (!(this.delegate instanceof CdiTransactionScopedEntityManager));
            assert (this.delegate.isOpen());
            assert (this.subdelegate == null);
            returnValue = this.delegate;
        } else {
            if (this.delegate != null && !this.delegate.isOpen()) {
                assert (this.delegate instanceof CdiTransactionScopedEntityManager);
                assert (this.subdelegate != null);
                assert (!(this.subdelegate instanceof CdiTransactionScopedEntityManager));
                assert (this.subdelegate.isOpen());
                this.delegate = this.subdelegate;
                this.subdelegate = null;
            }
            if (!(this.delegate instanceof CdiTransactionScopedEntityManager)) {
                assert (this.subdelegate == null);
                assert (this.delegate == null || this.delegate.isOpen());
                HashSet<? extends Annotation> selectionQualifiers = new HashSet<Annotation>(this.suppliedQualifiers);
                selectionQualifiers.remove(Extended.Literal.INSTANCE);
                selectionQualifiers.remove(JpaTransactionScoped.Literal.INSTANCE);
                selectionQualifiers.remove(NonTransactional.Literal.INSTANCE);
                selectionQualifiers.add(CdiTransactionScoped.Literal.INSTANCE);
                selectionQualifiers.add(ContainerManaged.Literal.INSTANCE);
                Set cdiTransactionScopedEntityManagerBeans = this.beanManager.getBeans(CdiTransactionScopedEntityManager.class, selectionQualifiers.toArray(new Annotation[selectionQualifiers.size()]));
                assert (cdiTransactionScopedEntityManagerBeans != null);
                assert (!cdiTransactionScopedEntityManagerBeans.isEmpty());
                Bean cdiTransactionScopedEntityManagerBean = this.beanManager.resolve(cdiTransactionScopedEntityManagerBeans);
                assert (cdiTransactionScopedEntityManagerBean != null);
                assert (context.getScope().equals(cdiTransactionScopedEntityManagerBean.getScope()));
                Object existingContainerManagedCdiTransactionScopedEntityManager = context.get((Contextual)cdiTransactionScopedEntityManagerBean);
                if (existingContainerManagedCdiTransactionScopedEntityManager != null) {
                    throw new CreationException(Messages.format("preexistingExtendedEntityManager", cdiTransactionScopedEntityManagerBean, existingContainerManagedCdiTransactionScopedEntityManager));
                }
                CdiTransactionScopedEntityManager cdiTransactionScopedEntityManager = (CdiTransactionScopedEntityManager)this.beanManager.getReference(cdiTransactionScopedEntityManagerBean, CdiTransactionScopedEntityManager.class, this.beanManager.createCreationalContext((Contextual)cdiTransactionScopedEntityManagerBean));
                assert (cdiTransactionScopedEntityManager != null);
                if (this.delegate == null) {
                    this.subdelegate = EntityManagers.createContainerManagedEntityManager(this.instance, this.suppliedQualifiers);
                } else {
                    assert (!(this.delegate instanceof CdiTransactionScopedEntityManager));
                    assert (this.subdelegate == null);
                    this.subdelegate = this.delegate;
                }
                assert (this.subdelegate != null);
                cdiTransactionScopedEntityManager.setDelegate(this.subdelegate);
                this.delegate = cdiTransactionScopedEntityManager;
                if (this.isSynchronized) {
                    this.delegate.joinTransaction();
                }
            }
            assert (this.delegate != null);
            assert (this.delegate.isOpen());
            returnValue = this.delegate;
        }
        return returnValue;
    }

    @Override
    public void close() {
        throw new IllegalStateException();
    }

    void closeDelegates() {
        if (this.delegate != null && this.delegate.isOpen()) {
            this.delegate.close();
        }
    }
}

