/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.cdi.jpa;

import io.helidon.integrations.cdi.jpa.CdiTransactionScoped;
import io.helidon.integrations.cdi.jpa.CdiTransactionScopedEntityManager;
import io.helidon.integrations.cdi.jpa.ContainerManaged;
import io.helidon.integrations.cdi.jpa.EntityManagerFactories;
import io.helidon.integrations.cdi.jpa.Extended;
import io.helidon.integrations.cdi.jpa.ExtendedEntityManager;
import io.helidon.integrations.cdi.jpa.JpaCdiQualifiers;
import io.helidon.integrations.cdi.jpa.JpaTransactionScoped;
import io.helidon.integrations.cdi.jpa.JpaTransactionScopedEntityManager;
import io.helidon.integrations.cdi.jpa.Messages;
import io.helidon.integrations.cdi.jpa.NoTransactionSupport;
import io.helidon.integrations.cdi.jpa.NonTransactional;
import io.helidon.integrations.cdi.jpa.NonTransactionalEntityManager;
import io.helidon.integrations.cdi.jpa.PersistenceUnitInfoBean;
import io.helidon.integrations.cdi.jpa.Synchronized;
import io.helidon.integrations.cdi.jpa.Unsynchronized;
import io.helidon.integrations.cdi.jpa.jaxb.Persistence;
import io.helidon.integrations.cdi.referencecountedcontext.ReferenceCounted;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.CreationException;
import jakarta.enterprise.inject.InjectionException;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Vetoed;
import jakarta.enterprise.inject.literal.InjectLiteral;
import jakarta.enterprise.inject.literal.NamedLiteral;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessInjectionPoint;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.enterprise.inject.spi.configurator.AnnotatedFieldConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedParameterConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.persistence.Converter;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import jakarta.persistence.PersistenceProperty;
import jakarta.persistence.PersistenceUnit;
import jakarta.persistence.SynchronizationType;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceProviderResolver;
import jakarta.persistence.spi.PersistenceProviderResolverHolder;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class JpaExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(JpaExtension.class.getName(), JpaExtension.class.getPackage().getName() + ".Messages");
    static final String DEFAULT_PERSISTENCE_UNIT_NAME = "__DEFAULT__";
    private boolean transactionsSupported;
    private final Map<String, PersistenceUnitInfoBean> implicitPersistenceUnits;
    private final Map<String, Set<Class<?>>> unlistedManagedClassesByPersistenceUnitNames;
    private final Set<Set<Annotation>> persistenceContextQualifiers;
    private final Set<Set<Annotation>> persistenceUnitQualifiers;
    private final Set<Set<Annotation>> cdiTransactionScopedEntityManagerQualifiers;
    private final Set<Set<Annotation>> nonTransactionalEntityManagerQualifiers;
    private final Set<Set<Annotation>> containerManagedEntityManagerFactoryQualifiers;
    private boolean defaultPersistenceUnitInEffect;
    private boolean addedDefaultPersistenceUnit;

    public JpaExtension() {
        String cn = JpaExtension.class.getName();
        String mn = "<init>";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "<init>");
        }
        this.unlistedManagedClassesByPersistenceUnitNames = new HashMap();
        this.implicitPersistenceUnits = new HashMap<String, PersistenceUnitInfoBean>();
        this.persistenceContextQualifiers = new HashSet<Set<Annotation>>();
        this.cdiTransactionScopedEntityManagerQualifiers = new HashSet<Set<Annotation>>();
        this.containerManagedEntityManagerFactoryQualifiers = new HashSet<Set<Annotation>>();
        this.nonTransactionalEntityManagerQualifiers = new HashSet<Set<Annotation>>();
        this.persistenceUnitQualifiers = new HashSet<Set<Annotation>>();
        this.transactionsSupported = true;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "<init>");
        }
    }

    private void disableTransactionSupport(@Observes @Priority(value=1000) ProcessAnnotatedType<NoTransactionSupport> event) {
        String cn = JpaExtension.class.getName();
        String mn = "disableTransactionSupport";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "disableTransactionSupport", event);
        }
        Objects.requireNonNull(event);
        this.transactionsSupported = false;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "disableTransactionSupport");
        }
    }

    private <T> void rewriteJpaAnnotations(@Observes @WithAnnotations(value={PersistenceContext.class, PersistenceUnit.class}) ProcessAnnotatedType<T> event) {
        String cn = JpaExtension.class.getName();
        String mn = "rewriteJpaAnnotations";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "rewriteJpaAnnotations", event);
        }
        Objects.requireNonNull(event);
        AnnotatedTypeConfigurator atc = event.configureAnnotatedType();
        atc.filterFields(JpaExtension::isEligiblePersistenceContextField).forEach(this::rewritePersistenceContextFieldAnnotations);
        atc.filterFields(JpaExtension::isEligiblePersistenceUnitField).forEach(this::rewritePersistenceUnitFieldAnnotations);
        atc.filterMethods(JpaExtension::isEligiblePersistenceContextSetterMethod).forEach(this::rewritePersistenceContextSetterMethodAnnotations);
        atc.filterMethods(JpaExtension::isEligiblePersistenceUnitSetterMethod).forEach(this::rewritePersistenceUnitSetterMethodAnnotations);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "rewriteJpaAnnotations");
        }
    }

    private void gatherImplicitPersistenceUnits(@Observes @WithAnnotations(value={PersistenceContext.class}) ProcessAnnotatedType<?> event, BeanManager beanManager) {
        Set persistenceContexts;
        String cn = JpaExtension.class.getName();
        String mn = "gatherImplicitPersistenceUnits";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "gatherImplicitPersistenceUnits", new Object[]{event, beanManager});
        }
        Objects.requireNonNull(event);
        Objects.requireNonNull(beanManager);
        AnnotatedType annotatedType = event.getAnnotatedType();
        if (annotatedType != null && !annotatedType.isAnnotationPresent(Vetoed.class) && (persistenceContexts = annotatedType.getAnnotations(PersistenceContext.class)) != null && !persistenceContexts.isEmpty()) {
            for (PersistenceContext persistenceContext : persistenceContexts) {
                CodeSource cs;
                PersistenceProperty[] persistenceProperties;
                String name;
                if (LOGGER.isLoggable(Level.INFO) && !(name = persistenceContext.name().trim()).isEmpty()) {
                    LOGGER.logp(Level.INFO, cn, "gatherImplicitPersistenceUnits", "persistenceContextNameIgnored", new Object[]{annotatedType, name});
                }
                if ((persistenceProperties = persistenceContext.properties()) == null || persistenceProperties.length <= 0) continue;
                String persistenceUnitName = persistenceContext.unitName();
                assert (persistenceUnitName != null);
                PersistenceUnitInfoBean persistenceUnit = this.implicitPersistenceUnits.get(persistenceUnitName);
                if (persistenceUnit != null) continue;
                String jtaDataSourceName = persistenceUnitName.isEmpty() ? null : persistenceUnitName;
                Class javaClass = annotatedType.getJavaClass();
                URL persistenceUnitRoot = null;
                ProtectionDomain pd = javaClass.getProtectionDomain();
                if (pd != null && (cs = pd.getCodeSource()) != null) {
                    persistenceUnitRoot = cs.getLocation();
                }
                Properties properties = new Properties();
                for (PersistenceProperty persistenceProperty : persistenceProperties) {
                    String persistencePropertyName = persistenceProperty.name();
                    if (persistencePropertyName.isEmpty()) continue;
                    properties.setProperty(persistencePropertyName, persistenceProperty.value());
                }
                persistenceUnit = new PersistenceUnitInfoBean(persistenceUnitName, persistenceUnitRoot, null, () -> (PersistenceUnitInfoBean.DataSourceProvider)beanManager.createInstance().select(PersistenceUnitInfoBean.DataSourceProvider.class, new Annotation[0]).get(), properties);
                this.implicitPersistenceUnits.put(persistenceUnitName, persistenceUnit);
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "gatherImplicitPersistenceUnits");
        }
    }

    private void discoverManagedClasses(@Observes @WithAnnotations(value={Converter.class, Embeddable.class, Entity.class, MappedSuperclass.class}) ProcessAnnotatedType<?> event) {
        String cn = JpaExtension.class.getName();
        String mn = "discoverManagedClasses";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "discoverManagedClasses", event);
        }
        Objects.requireNonNull(event);
        AnnotatedType annotatedType = event.getAnnotatedType();
        if (annotatedType != null && !annotatedType.isAnnotationPresent(Vetoed.class)) {
            this.assignManagedClassToPersistenceUnit(annotatedType.getAnnotations(PersistenceContext.class), annotatedType.getAnnotations(PersistenceUnit.class), annotatedType.getJavaClass());
            event.veto();
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "discoverManagedClasses");
        }
    }

    private void assignManagedClassToPersistenceUnit(Set<? extends PersistenceContext> persistenceContexts, Set<? extends PersistenceUnit> persistenceUnits, Class<?> c) {
        String cn = JpaExtension.class.getName();
        String mn = "assignManagedClassToPersistenceUnit";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "assignManagedClassToPersistenceUnit", new Object[]{persistenceContexts, persistenceUnits, c});
        }
        if (c != null) {
            String unitName;
            boolean processed = false;
            if (persistenceContexts != null && !persistenceContexts.isEmpty()) {
                for (PersistenceContext persistenceContext : persistenceContexts) {
                    if (persistenceContext == null) continue;
                    unitName = persistenceContext.unitName();
                    if (unitName == null || unitName.isEmpty()) {
                        unitName = DEFAULT_PERSISTENCE_UNIT_NAME;
                        this.defaultPersistenceUnitInEffect = true;
                    }
                    processed = true;
                    this.addUnlistedManagedClass(unitName, c);
                }
            }
            if (persistenceUnits != null && !persistenceUnits.isEmpty()) {
                for (PersistenceUnit persistenceUnit : persistenceUnits) {
                    if (persistenceUnit == null) continue;
                    unitName = persistenceUnit.unitName();
                    if (unitName == null || unitName.isEmpty()) {
                        unitName = DEFAULT_PERSISTENCE_UNIT_NAME;
                        this.defaultPersistenceUnitInEffect = true;
                    }
                    processed = true;
                    this.addUnlistedManagedClass(unitName, c);
                }
            }
            if (!processed) {
                this.addUnlistedManagedClass(DEFAULT_PERSISTENCE_UNIT_NAME, c);
                this.defaultPersistenceUnitInEffect = true;
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "assignManagedClassToPersistenceUnit");
        }
    }

    private void addUnlistedManagedClass(String name, Class<?> managedClass) {
        String cn = JpaExtension.class.getName();
        String mn = "addUnlistedManagedClass";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "addUnlistedManagedClass", new Object[]{name, managedClass});
        }
        if (managedClass != null) {
            Set<Class<?>> unlistedManagedClasses;
            if (name == null || name.isEmpty()) {
                name = DEFAULT_PERSISTENCE_UNIT_NAME;
                this.defaultPersistenceUnitInEffect = true;
            }
            if ((unlistedManagedClasses = this.unlistedManagedClassesByPersistenceUnitNames.get(name)) == null) {
                unlistedManagedClasses = new HashSet();
                this.unlistedManagedClassesByPersistenceUnitNames.put(name, unlistedManagedClasses);
            }
            unlistedManagedClasses.add(managedClass);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "addUnlistedManagedClass");
        }
    }

    private <T extends EntityManagerFactory> void saveEntityManagerFactoryQualifiers(@Observes ProcessInjectionPoint<?, T> event) {
        String cn = JpaExtension.class.getName();
        String mn = "saveEntityManagerFactoryQualifiers";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "saveEntityManagerFactoryQualifiers", event);
        }
        Objects.requireNonNull(event);
        InjectionPoint injectionPoint = event.getInjectionPoint();
        assert (injectionPoint != null);
        this.persistenceUnitQualifiers.add(injectionPoint.getQualifiers());
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "saveEntityManagerFactoryQualifiers");
        }
    }

    private <T extends EntityManager> void saveEntityManagerQualifiers(@Observes ProcessInjectionPoint<?, T> event) {
        String cn = JpaExtension.class.getName();
        String mn = "saveEntityManagerQualifiers";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "saveEntityManagerQualifiers", event);
        }
        Objects.requireNonNull(event);
        InjectionPoint injectionPoint = event.getInjectionPoint();
        assert (injectionPoint != null);
        Set qualifiers = injectionPoint.getQualifiers();
        assert (qualifiers != null);
        boolean error = false;
        if (qualifiers.contains(JpaTransactionScoped.Literal.INSTANCE)) {
            if (qualifiers.contains(CdiTransactionScoped.Literal.INSTANCE) || qualifiers.contains(Extended.Literal.INSTANCE) || qualifiers.contains(NonTransactional.Literal.INSTANCE)) {
                error = true;
            }
        } else if (qualifiers.contains(Extended.Literal.INSTANCE)) {
            if (qualifiers.contains(CdiTransactionScoped.Literal.INSTANCE) || qualifiers.contains(NonTransactional.Literal.INSTANCE)) {
                error = true;
            }
        } else if (qualifiers.contains(NonTransactional.Literal.INSTANCE)) {
            if (qualifiers.contains(CdiTransactionScoped.Literal.INSTANCE)) {
                error = true;
            }
        } else if (qualifiers.contains(Synchronized.Literal.INSTANCE) && qualifiers.contains(Unsynchronized.Literal.INSTANCE)) {
            error = true;
        }
        if (error) {
            event.addDefinitionError((Throwable)new InjectionException("Invalid injection point; some qualifiers are mutually exclusive: " + String.valueOf(qualifiers)));
        } else {
            this.persistenceContextQualifiers.add(qualifiers);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "saveEntityManagerQualifiers");
        }
    }

    private void afterBeanDiscovery(@Observes @Priority(value=3000) AfterBeanDiscovery event, BeanManager beanManager) throws IOException, JAXBException, ReflectiveOperationException, XMLStreamException {
        ClassLoader classLoader;
        Enumeration<URL> urls;
        String cn = JpaExtension.class.getName();
        String mn = "afterBeanDiscovery";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "afterBeanDiscovery", new Object[]{event, beanManager});
        }
        Objects.requireNonNull(event);
        Objects.requireNonNull(beanManager);
        Collection<? extends PersistenceProvider> providers = JpaExtension.addPersistenceProviderBeans(event);
        boolean processImplicits = true;
        Set preexistingPersistenceUnitInfoBeans = beanManager.getBeans(PersistenceUnitInfo.class, new Annotation[]{Any.Literal.INSTANCE});
        if (preexistingPersistenceUnitInfoBeans != null && !preexistingPersistenceUnitInfoBeans.isEmpty()) {
            processImplicits = false;
            this.maybeAddPersistenceProviderBeans(event, beanManager, preexistingPersistenceUnitInfoBeans, providers);
        }
        if ((urls = (classLoader = Thread.currentThread().getContextClassLoader()).getResources("META-INF/persistence.xml")) != null && urls.hasMoreElements()) {
            processImplicits = false;
            this.processPersistenceXmls(event, beanManager, classLoader, urls, providers, preexistingPersistenceUnitInfoBeans != null && !preexistingPersistenceUnitInfoBeans.isEmpty());
        }
        if (processImplicits) {
            this.processImplicitPersistenceUnits(event, providers);
        }
        this.addContainerManagedJpaBeans(event, beanManager);
        this.cdiTransactionScopedEntityManagerQualifiers.clear();
        this.containerManagedEntityManagerFactoryQualifiers.clear();
        this.implicitPersistenceUnits.clear();
        this.nonTransactionalEntityManagerQualifiers.clear();
        this.persistenceContextQualifiers.clear();
        this.persistenceUnitQualifiers.clear();
        this.unlistedManagedClassesByPersistenceUnitNames.clear();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "afterBeanDiscovery");
        }
    }

    private void validate(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        String cn = JpaExtension.class.getName();
        String mn = "validateJpaInjectionPoints";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "validateJpaInjectionPoints", new Object[]{event, beanManager});
        }
        Objects.requireNonNull(event);
        Objects.requireNonNull(beanManager);
        if (this.defaultPersistenceUnitInEffect && !this.addedDefaultPersistenceUnit) {
            Set persistenceUnitInfoBeans = beanManager.getBeans(PersistenceUnitInfo.class, new Annotation[]{Any.Literal.INSTANCE});
            assert (persistenceUnitInfoBeans != null);
            assert (persistenceUnitInfoBeans.size() > 1) : "Unexpected persistenceUnitInfoBeans: " + String.valueOf(persistenceUnitInfoBeans);
            try {
                beanManager.resolve(persistenceUnitInfoBeans);
            }
            catch (AmbiguousResolutionException expected) {
                HashSet<String> names = new HashSet<String>();
                block2: for (Bean bean : persistenceUnitInfoBeans) {
                    assert (bean != null);
                    Set qualifiers = bean.getQualifiers();
                    for (Annotation qualifier : qualifiers) {
                        if (!(qualifier instanceof Named)) continue;
                        names.add(((Named)qualifier).value());
                        continue block2;
                    }
                }
                event.addDeploymentProblem((Throwable)new AmbiguousResolutionException(Messages.format("ambiguousPersistenceUnitInfo", names), (Throwable)expected));
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "validateJpaInjectionPoints");
        }
    }

    private void addContainerManagedJpaBeans(AfterBeanDiscovery event, BeanManager beanManager) throws ReflectiveOperationException {
        String cn = JpaExtension.class.getName();
        String mn = "addContainerManagedJpaBeans";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "addContainerManagedJpaBeans", new Object[]{event, beanManager});
        }
        Objects.requireNonNull(event);
        Objects.requireNonNull(beanManager);
        for (Set<Annotation> qualifiers : this.persistenceUnitQualifiers) {
            this.addContainerManagedEntityManagerFactoryBeans(event, qualifiers, beanManager);
        }
        if (this.transactionsSupported) {
            for (Set<Annotation> qualifiers : this.persistenceContextQualifiers) {
                this.addContainerManagedEntityManagerFactoryBeans(event, qualifiers, beanManager);
                this.addCdiTransactionScopedEntityManagerBeans(event, qualifiers);
                if (qualifiers.contains(Extended.Literal.INSTANCE)) {
                    this.addExtendedEntityManagerBeans(event, qualifiers, beanManager);
                    continue;
                }
                assert (qualifiers.contains(JpaTransactionScoped.Literal.INSTANCE));
                this.addNonTransactionalEntityManagerBeans(event, qualifiers, beanManager);
                this.addJpaTransactionScopedEntityManagerBeans(event, qualifiers);
            }
        } else {
            for (Set<Annotation> qualifiers : this.persistenceContextQualifiers) {
                this.addContainerManagedEntityManagerFactoryBeans(event, qualifiers, beanManager);
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "addContainerManagedJpaBeans");
        }
    }

    private void addContainerManagedEntityManagerFactoryBeans(AfterBeanDiscovery event, Set<Annotation> suppliedQualifiers, BeanManager beanManager) {
        String cn = JpaExtension.class.getName();
        String mn = "addContainerManagedEntityManagerFactoryBeans";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "addContainerManagedEntityManagerFactoryBeans", new Object[]{event, suppliedQualifiers, beanManager});
        }
        Objects.requireNonNull(event);
        Objects.requireNonNull(suppliedQualifiers);
        Objects.requireNonNull(beanManager);
        HashSet<Annotation> qualifiers = new HashSet<Annotation>(suppliedQualifiers);
        qualifiers.removeAll(JpaCdiQualifiers.JPA_CDI_QUALIFIERS);
        qualifiers.add(ContainerManaged.Literal.INSTANCE);
        if (this.containerManagedEntityManagerFactoryQualifiers.add(qualifiers)) {
            event.addBean().addType(EntityManagerFactory.class).scope(ApplicationScoped.class).addQualifiers(qualifiers).produceWith(instance -> EntityManagerFactories.createContainerManagedEntityManagerFactory((Instance<Object>)instance, qualifiers, beanManager)).disposeWith((emf, instance) -> {
                if (emf.isOpen()) {
                    emf.close();
                }
            });
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "addContainerManagedEntityManagerFactoryBeans");
        }
    }

    private void addCdiTransactionScopedEntityManagerBeans(AfterBeanDiscovery event, Set<Annotation> suppliedQualifiers) throws ReflectiveOperationException {
        String cn = JpaExtension.class.getName();
        String mn = "addCdiTransactionScopedEntityManagerBeans";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "addCdiTransactionScopedEntityManagerBeans", new Object[]{event, suppliedQualifiers});
        }
        Objects.requireNonNull(event);
        Objects.requireNonNull(suppliedQualifiers);
        if (!this.transactionsSupported) {
            throw new IllegalStateException();
        }
        HashSet<Annotation> qualifiers = new HashSet<Annotation>(suppliedQualifiers);
        qualifiers.add(ContainerManaged.Literal.INSTANCE);
        qualifiers.add(CdiTransactionScoped.Literal.INSTANCE);
        qualifiers.remove(Extended.Literal.INSTANCE);
        qualifiers.remove(JpaTransactionScoped.Literal.INSTANCE);
        qualifiers.remove(NonTransactional.Literal.INSTANCE);
        qualifiers.remove(Synchronized.Literal.INSTANCE);
        qualifiers.remove(Unsynchronized.Literal.INSTANCE);
        if (!this.cdiTransactionScopedEntityManagerQualifiers.contains(qualifiers)) {
            Class<?> scope;
            this.cdiTransactionScopedEntityManagerQualifiers.add(new HashSet<Annotation>(qualifiers));
            Class<?> temp = null;
            try {
                Class<?> transactionScopedAnnotationClass;
                temp = transactionScopedAnnotationClass = Class.forName("jakarta.transaction.TransactionScoped", true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new InternalError(classNotFoundException.getMessage(), classNotFoundException);
            }
            finally {
                Class<?> scope2 = temp;
            }
            assert (scope != null);
            qualifiers.add(Synchronized.Literal.INSTANCE);
            HashSet<Annotation> synchronizedQualifiers = new HashSet<Annotation>(qualifiers);
            event.addBean().addTransitiveTypeClosure(CdiTransactionScopedEntityManager.class).scope(scope).addQualifiers(synchronizedQualifiers).produceWith(instance -> new CdiTransactionScopedEntityManager((Instance<Object>)instance, synchronizedQualifiers)).disposeWith(CdiTransactionScopedEntityManager::dispose);
            qualifiers.remove(Synchronized.Literal.INSTANCE);
            qualifiers.add(Unsynchronized.Literal.INSTANCE);
            HashSet<Annotation> unsynchronizedQualifiers = new HashSet<Annotation>(qualifiers);
            event.addBean().addTransitiveTypeClosure(CdiTransactionScopedEntityManager.class).scope(scope).addQualifiers(unsynchronizedQualifiers).produceWith(instance -> new CdiTransactionScopedEntityManager((Instance<Object>)instance, unsynchronizedQualifiers)).disposeWith(CdiTransactionScopedEntityManager::dispose);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "addCdiTransactionScopedEntityManagerBeans");
        }
    }

    private void addJpaTransactionScopedEntityManagerBeans(AfterBeanDiscovery event, Set<Annotation> suppliedQualifiers) {
        String cn = JpaExtension.class.getName();
        String mn = "addJpaTransactionScopedEntityManagerBeans";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "addJpaTransactionScopedEntityManagerBeans", new Object[]{event, suppliedQualifiers});
        }
        Objects.requireNonNull(event);
        Objects.requireNonNull(suppliedQualifiers);
        if (!this.transactionsSupported) {
            throw new IllegalStateException();
        }
        HashSet<Annotation> qualifiers = new HashSet<Annotation>(suppliedQualifiers);
        qualifiers.add(ContainerManaged.Literal.INSTANCE);
        qualifiers.add(JpaTransactionScoped.Literal.INSTANCE);
        qualifiers.remove(CdiTransactionScoped.Literal.INSTANCE);
        qualifiers.remove(Extended.Literal.INSTANCE);
        qualifiers.remove(NonTransactional.Literal.INSTANCE);
        event.addBean().addTransitiveTypeClosure(JpaTransactionScopedEntityManager.class).scope(Dependent.class).addQualifiers(qualifiers).produceWith(instance -> new JpaTransactionScopedEntityManager((Instance<Object>)instance, suppliedQualifiers)).disposeWith(JpaTransactionScopedEntityManager::dispose);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "addJpaTransactionScopedEntityManagerBeans");
        }
    }

    private void addNonTransactionalEntityManagerBeans(AfterBeanDiscovery event, Set<Annotation> suppliedQualifiers, BeanManager beanManager) {
        String cn = JpaExtension.class.getName();
        String mn = "addNonTransactionalEntityManagerBeans";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "addNonTransactionalEntityManagerBeans", new Object[]{event, suppliedQualifiers});
        }
        Objects.requireNonNull(event);
        Objects.requireNonNull(suppliedQualifiers);
        Objects.requireNonNull(beanManager);
        HashSet<Annotation> qualifiers = new HashSet<Annotation>(suppliedQualifiers);
        qualifiers.removeAll(JpaCdiQualifiers.JPA_CDI_QUALIFIERS);
        qualifiers.add(NonTransactional.Literal.INSTANCE);
        if (this.nonTransactionalEntityManagerQualifiers.add(qualifiers)) {
            event.addBean().addTransitiveTypeClosure(NonTransactionalEntityManager.class).scope(ReferenceCounted.class).addQualifiers(qualifiers).produceWith(instance -> new NonTransactionalEntityManager((Instance<Object>)instance, suppliedQualifiers)).disposeWith((em, instance) -> {
                if (em.isOpen()) {
                    em.close();
                }
            });
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "addNonTransactionalEntityManagerBeans");
        }
    }

    private void addExtendedEntityManagerBeans(AfterBeanDiscovery event, Set<Annotation> suppliedQualifiers, BeanManager beanManager) {
        String cn = JpaExtension.class.getName();
        String mn = "addExtendedEntityManagerBeans";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "addExtendedEntityManagerBeans", new Object[]{event, suppliedQualifiers, beanManager});
        }
        Objects.requireNonNull(event);
        Objects.requireNonNull(suppliedQualifiers);
        Objects.requireNonNull(beanManager);
        if (!this.transactionsSupported) {
            throw new IllegalStateException();
        }
        HashSet<Annotation> qualifiers = new HashSet<Annotation>(suppliedQualifiers);
        qualifiers.add(ContainerManaged.Literal.INSTANCE);
        qualifiers.add(Extended.Literal.INSTANCE);
        qualifiers.remove(JpaTransactionScoped.Literal.INSTANCE);
        qualifiers.remove(CdiTransactionScoped.Literal.INSTANCE);
        qualifiers.remove(NonTransactional.Literal.INSTANCE);
        event.addBean().addTransitiveTypeClosure(ExtendedEntityManager.class).scope(ReferenceCounted.class).qualifiers(qualifiers).produceWith(instance -> new ExtendedEntityManager((Instance<Object>)instance, suppliedQualifiers, beanManager)).disposeWith((em, instance) -> em.closeDelegates());
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "addExtendedEntityManagerBeans");
        }
    }

    private void processImplicitPersistenceUnits(AfterBeanDiscovery event, Collection<? extends PersistenceProvider> providers) throws ReflectiveOperationException {
        String cn = JpaExtension.class.getName();
        String mn = "processImplicitPersistenceUnits";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "processImplicitPersistenceUnits", new Object[]{event, providers});
        }
        Objects.requireNonNull(event);
        int persistenceUnitCount = 0;
        PersistenceUnitInfoBean solePersistenceUnitInfoBean = null;
        for (PersistenceUnitInfoBean persistenceUnitInfoBean : this.implicitPersistenceUnits.values()) {
            Collection unlistedManagedClasses;
            assert (persistenceUnitInfoBean != null);
            String persistenceUnitName = persistenceUnitInfoBean.getPersistenceUnitName();
            if (persistenceUnitName == null || persistenceUnitName.isEmpty()) {
                persistenceUnitName = DEFAULT_PERSISTENCE_UNIT_NAME;
                this.defaultPersistenceUnitInEffect = true;
            }
            if (!persistenceUnitInfoBean.excludeUnlistedClasses() && (unlistedManagedClasses = (Collection)this.unlistedManagedClassesByPersistenceUnitNames.get(persistenceUnitName)) != null && !unlistedManagedClasses.isEmpty()) {
                for (Class unlistedManagedClass : unlistedManagedClasses) {
                    persistenceUnitInfoBean.addManagedClassName(unlistedManagedClass.getName());
                }
            }
            event.addBean().beanClass(PersistenceUnitInfoBean.class).types(Collections.singleton(PersistenceUnitInfo.class)).scope(ApplicationScoped.class).addQualifiers(new Annotation[]{NamedLiteral.of((String)persistenceUnitName)}).createWith(cc -> persistenceUnitInfoBean);
            if (persistenceUnitCount == 0) {
                assert (solePersistenceUnitInfoBean == null);
                solePersistenceUnitInfoBean = persistenceUnitInfoBean;
            } else if (solePersistenceUnitInfoBean != null) {
                solePersistenceUnitInfoBean = null;
            }
            this.maybeAddPersistenceProviderBean(event, persistenceUnitInfoBean, providers);
            ++persistenceUnitCount;
        }
        switch (persistenceUnitCount) {
            case 0: {
                break;
            }
            case 1: {
                assert (solePersistenceUnitInfoBean != null);
                String name = solePersistenceUnitInfoBean.getPersistenceUnitName();
                if (name == null || name.isEmpty()) break;
                this.defaultPersistenceUnitInEffect = true;
                this.addedDefaultPersistenceUnit = true;
                PersistenceUnitInfoBean instance = solePersistenceUnitInfoBean;
                event.addBean().beanClass(PersistenceUnitInfoBean.class).types(Collections.singleton(PersistenceUnitInfo.class)).scope(ApplicationScoped.class).addQualifiers(new Annotation[]{NamedLiteral.of((String)DEFAULT_PERSISTENCE_UNIT_NAME)}).createWith(cc -> instance);
                break;
            }
            default: {
                assert (persistenceUnitCount > 1);
                assert (solePersistenceUnitInfoBean == null) : "Unexpected solePersistenceUnitInfoBean: " + String.valueOf(solePersistenceUnitInfoBean) + " with persistenceUnitCount " + persistenceUnitCount;
                break;
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "processImplicitPersistenceUnits");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPersistenceXmls(AfterBeanDiscovery event, BeanManager beanManager, ClassLoader classLoader, Enumeration<URL> urls, Collection<? extends PersistenceProvider> providers, boolean userSuppliedPersistenceUnitInfoBeans) throws IOException, JAXBException, ReflectiveOperationException, XMLStreamException {
        String cn = JpaExtension.class.getName();
        String mn = "processPersistenceXmls";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "processPersistenceXmls", new Object[]{event, beanManager, classLoader, urls, providers});
        }
        Objects.requireNonNull(event);
        if (urls != null && urls.hasMoreElements()) {
            String name;
            Supplier<ClassLoader> tempClassLoaderSupplier = () -> {
                if (classLoader instanceof URLClassLoader) {
                    return new URLClassLoader(((URLClassLoader)classLoader).getURLs());
                }
                return classLoader;
            };
            XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
            xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
            xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            Unmarshaller unmarshaller = JAXBContext.newInstance((String)Persistence.class.getPackage().getName()).createUnmarshaller();
            Supplier<PersistenceUnitInfoBean.DataSourceProvider> dataSourceProviderSupplier = () -> (PersistenceUnitInfoBean.DataSourceProvider)beanManager.createInstance().select(PersistenceUnitInfoBean.DataSourceProvider.class, new Annotation[0]).get();
            Object solePersistenceUnitInfo = null;
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                assert (url != null);
                ArrayList<PersistenceUnitInfoBean> persistenceUnitInfos = null;
                Persistence persistence = null;
                try (BufferedInputStream inputStream = new BufferedInputStream(url.openStream());
                     XMLStreamReader reader = xmlInputFactory.createXMLStreamReader(inputStream);){
                    persistence = (Persistence)unmarshaller.unmarshal(reader);
                }
                List<Persistence.PersistenceUnit> persistenceUnits = persistence.getPersistenceUnit();
                if (persistenceUnits != null && !persistenceUnits.isEmpty()) {
                    persistenceUnitInfos = new ArrayList<PersistenceUnitInfoBean>();
                    for (Persistence.PersistenceUnit persistenceUnit : persistenceUnits) {
                        if (persistenceUnit == null) continue;
                        persistenceUnitInfos.add(PersistenceUnitInfoBean.fromPersistenceUnit(persistenceUnit, classLoader, tempClassLoaderSupplier, new URL(url, ".."), this.unlistedManagedClassesByPersistenceUnitNames, dataSourceProviderSupplier));
                    }
                }
                if (persistenceUnitInfos == null || persistenceUnitInfos.isEmpty()) continue;
                for (PersistenceUnitInfo persistenceUnitInfo : persistenceUnitInfos) {
                    String persistenceUnitName = persistenceUnitInfo.getPersistenceUnitName();
                    if (persistenceUnitName == null || persistenceUnitName.isEmpty()) {
                        persistenceUnitName = DEFAULT_PERSISTENCE_UNIT_NAME;
                        this.defaultPersistenceUnitInEffect = true;
                    }
                    event.addBean().beanClass(PersistenceUnitInfoBean.class).types(Collections.singleton(PersistenceUnitInfo.class)).scope(ApplicationScoped.class).addQualifiers(new Annotation[]{NamedLiteral.of((String)persistenceUnitName)}).createWith(cc -> persistenceUnitInfo);
                    solePersistenceUnitInfo = solePersistenceUnitInfo == null ? persistenceUnitInfo : null;
                    this.maybeAddPersistenceProviderBean(event, persistenceUnitInfo, providers);
                }
            }
            if (!(userSuppliedPersistenceUnitInfoBeans || solePersistenceUnitInfo == null || (name = solePersistenceUnitInfo.getPersistenceUnitName()) == null || name.isEmpty() || name.equals(DEFAULT_PERSISTENCE_UNIT_NAME))) {
                this.defaultPersistenceUnitInEffect = true;
                this.addedDefaultPersistenceUnit = true;
                PersistenceUnitInfo instance = solePersistenceUnitInfo;
                event.addBean().beanClass(PersistenceUnitInfoBean.class).types(Collections.singleton(PersistenceUnitInfo.class)).scope(ApplicationScoped.class).addQualifiers(new Annotation[]{NamedLiteral.of((String)DEFAULT_PERSISTENCE_UNIT_NAME)}).createWith(cc -> instance);
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "processPersistenceXmls");
        }
    }

    private static <T> boolean isEligiblePersistenceContextField(AnnotatedField<T> f) {
        Type fieldType;
        String cn = JpaExtension.class.getName();
        String mn = "isEligiblePersistenceContextField";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "isEligiblePersistenceContextField", f);
        }
        boolean returnValue = f != null && f.isAnnotationPresent(PersistenceContext.class) && !f.isAnnotationPresent(Inject.class) ? (fieldType = f.getBaseType()) instanceof Class && EntityManager.class.isAssignableFrom((Class)fieldType) : false;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "isEligiblePersistenceContextField", returnValue);
        }
        return returnValue;
    }

    private static <T> boolean isEligiblePersistenceUnitField(AnnotatedField<T> f) {
        Type fieldType;
        String cn = JpaExtension.class.getName();
        String mn = "isEligiblePersistenceUnitField";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "isEligiblePersistenceUnitField", f);
        }
        boolean returnValue = f != null && f.isAnnotationPresent(PersistenceUnit.class) && !f.isAnnotationPresent(Inject.class) ? (fieldType = f.getBaseType()) instanceof Class && EntityManagerFactory.class.isAssignableFrom((Class)fieldType) : false;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "isEligiblePersistenceUnitField", returnValue);
        }
        return returnValue;
    }

    private <T> void rewritePersistenceContextFieldAnnotations(AnnotatedFieldConfigurator<T> fc) {
        String cn = JpaExtension.class.getName();
        String mn = "rewritePersistenceContextFieldAnnotations";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "rewritePersistenceContextFieldAnnotations", fc);
        }
        Objects.requireNonNull(fc);
        PersistenceContext pc = (PersistenceContext)fc.getAnnotated().getAnnotation(PersistenceContext.class);
        if (pc != null) {
            String unitName;
            String name;
            fc.remove(a -> a == pc);
            fc.add((Annotation)InjectLiteral.INSTANCE);
            fc.add((Annotation)ContainerManaged.Literal.INSTANCE);
            if (PersistenceContextType.EXTENDED.equals((Object)pc.type())) {
                fc.add((Annotation)Extended.Literal.INSTANCE);
            } else {
                fc.add((Annotation)JpaTransactionScoped.Literal.INSTANCE);
            }
            if (SynchronizationType.UNSYNCHRONIZED.equals((Object)pc.synchronization())) {
                fc.add((Annotation)Unsynchronized.Literal.INSTANCE);
            } else {
                fc.add((Annotation)Synchronized.Literal.INSTANCE);
            }
            if (LOGGER.isLoggable(Level.INFO) && !(name = pc.name().trim()).isEmpty()) {
                LOGGER.logp(Level.INFO, cn, "rewritePersistenceContextFieldAnnotations", "persistenceContextNameIgnored", new Object[]{fc.getAnnotated(), name});
            }
            if ((unitName = pc.unitName().trim()).isEmpty()) {
                unitName = DEFAULT_PERSISTENCE_UNIT_NAME;
                this.defaultPersistenceUnitInEffect = true;
            }
            fc.add((Annotation)NamedLiteral.of((String)unitName));
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "rewritePersistenceContextFieldAnnotations");
        }
    }

    private <T> void rewritePersistenceUnitFieldAnnotations(AnnotatedFieldConfigurator<T> fc) {
        String cn = JpaExtension.class.getName();
        String mn = "rewritePersistenceUnitFieldAnnotations";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "rewritePersistenceUnitFieldAnnotations", fc);
        }
        Objects.requireNonNull(fc);
        PersistenceUnit pu = (PersistenceUnit)fc.getAnnotated().getAnnotation(PersistenceUnit.class);
        if (pu != null) {
            fc.remove(a -> a == pu);
        }
        fc.add((Annotation)InjectLiteral.INSTANCE);
        fc.add((Annotation)ContainerManaged.Literal.INSTANCE);
        String unitName = pu.unitName().trim();
        if (unitName.isEmpty()) {
            unitName = DEFAULT_PERSISTENCE_UNIT_NAME;
            this.defaultPersistenceUnitInEffect = true;
        }
        fc.add((Annotation)NamedLiteral.of((String)unitName));
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "rewritePersistenceUnitFieldAnnotations");
        }
    }

    private static <T> boolean isEligiblePersistenceContextSetterMethod(AnnotatedMethod<T> m) {
        boolean returnValue;
        String cn = JpaExtension.class.getName();
        String mn = "isEligiblePersistenceContextSetterMethod";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "isEligiblePersistenceContextSetterMethod", m);
        }
        if (m != null && m.isAnnotationPresent(PersistenceContext.class) && !m.isAnnotationPresent(Inject.class)) {
            List parameters = m.getParameters();
            if (parameters != null && !parameters.isEmpty()) {
                boolean temp = false;
                for (Annotated parameter : parameters) {
                    Type type = parameter.getBaseType();
                    if (!(type instanceof Class) || !EntityManager.class.isAssignableFrom((Class)type)) continue;
                    if (temp) {
                        temp = false;
                        break;
                    }
                    temp = true;
                }
                returnValue = temp;
            } else {
                returnValue = false;
            }
        } else {
            returnValue = false;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "isEligiblePersistenceContextSetterMethod", returnValue);
        }
        return returnValue;
    }

    private static <T> boolean isEligiblePersistenceUnitSetterMethod(AnnotatedMethod<T> m) {
        boolean returnValue;
        String cn = JpaExtension.class.getName();
        String mn = "isEligiblePersistenceUnitSetterMethod";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "isEligiblePersistenceUnitSetterMethod", m);
        }
        if (m != null && m.isAnnotationPresent(PersistenceUnit.class) && !m.isAnnotationPresent(Inject.class)) {
            List parameters = m.getParameters();
            if (parameters != null && !parameters.isEmpty()) {
                boolean temp = false;
                for (Annotated parameter : parameters) {
                    Type type = parameter.getBaseType();
                    if (!(type instanceof Class) || !EntityManagerFactory.class.isAssignableFrom((Class)type)) continue;
                    if (temp) {
                        temp = false;
                        break;
                    }
                    temp = true;
                }
                returnValue = temp;
            } else {
                returnValue = false;
            }
        } else {
            returnValue = false;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "isEligiblePersistenceUnitSetterMethod", returnValue);
        }
        return returnValue;
    }

    private <T> void rewritePersistenceContextSetterMethodAnnotations(AnnotatedMethodConfigurator<T> mc) {
        PersistenceContext pc;
        String cn = JpaExtension.class.getName();
        String mn = "rewritePersistenceContextSetterMethodAnnotations";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "rewritePersistenceContextSetterMethodAnnotations", mc);
        }
        Objects.requireNonNull(mc);
        AnnotatedMethod annotated = mc.getAnnotated();
        if (!annotated.isAnnotationPresent(Inject.class) && (pc = (PersistenceContext)annotated.getAnnotation(PersistenceContext.class)) != null) {
            String name;
            if (LOGGER.isLoggable(Level.INFO) && !(name = pc.name().trim()).isEmpty()) {
                LOGGER.logp(Level.INFO, cn, "rewritePersistenceContextSetterMethodAnnotations", "persistenceContextNameIgnored", new Object[]{annotated, name});
            }
            boolean observerMethod = false;
            List parameters = mc.params();
            if (parameters != null && !parameters.isEmpty()) {
                for (AnnotatedParameterConfigurator apc : parameters) {
                    AnnotatedParameter parameter = apc.getAnnotated();
                    if (parameter.isAnnotationPresent(Observes.class)) {
                        if (observerMethod) continue;
                        observerMethod = true;
                        continue;
                    }
                    Type parameterType = parameter.getBaseType();
                    if (!(parameterType instanceof Class) || !EntityManager.class.isAssignableFrom((Class)parameterType)) continue;
                    apc.add((Annotation)ContainerManaged.Literal.INSTANCE);
                    if (PersistenceContextType.EXTENDED.equals((Object)pc.type())) {
                        apc.add((Annotation)Extended.Literal.INSTANCE);
                    } else {
                        apc.add((Annotation)JpaTransactionScoped.Literal.INSTANCE);
                    }
                    if (SynchronizationType.UNSYNCHRONIZED.equals((Object)pc.synchronization())) {
                        apc.add((Annotation)Unsynchronized.Literal.INSTANCE);
                    } else {
                        apc.add((Annotation)Synchronized.Literal.INSTANCE);
                    }
                    String unitName = pc.unitName().trim();
                    if (unitName.isEmpty()) {
                        unitName = DEFAULT_PERSISTENCE_UNIT_NAME;
                        this.defaultPersistenceUnitInEffect = true;
                    }
                    apc.add((Annotation)NamedLiteral.of((String)unitName));
                }
                mc.remove(a -> a == pc);
                if (!observerMethod) {
                    mc.add((Annotation)InjectLiteral.INSTANCE);
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "rewritePersistenceContextSetterMethodAnnotations");
        }
    }

    private <T> void rewritePersistenceUnitSetterMethodAnnotations(AnnotatedMethodConfigurator<T> mc) {
        PersistenceUnit pu;
        String cn = JpaExtension.class.getName();
        String mn = "rewritePersistenceUnitSetterMethodAnnotations";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "rewritePersistenceUnitSetterMethodAnnotations", mc);
        }
        Objects.requireNonNull(mc);
        AnnotatedMethod annotated = mc.getAnnotated();
        if (!annotated.isAnnotationPresent(Inject.class) && (pu = (PersistenceUnit)annotated.getAnnotation(PersistenceUnit.class)) != null) {
            boolean observerMethod = false;
            List parameters = mc.params();
            if (parameters != null && !parameters.isEmpty()) {
                for (AnnotatedParameterConfigurator apc : parameters) {
                    AnnotatedParameter parameter = apc.getAnnotated();
                    if (parameter.isAnnotationPresent(Observes.class)) {
                        if (observerMethod) continue;
                        observerMethod = true;
                        continue;
                    }
                    Type parameterType = parameter.getBaseType();
                    if (!(parameterType instanceof Class) || !EntityManagerFactory.class.isAssignableFrom((Class)parameterType)) continue;
                    apc.add((Annotation)ContainerManaged.Literal.INSTANCE);
                    String unitName = pu.unitName().trim();
                    if (unitName.isEmpty()) {
                        unitName = DEFAULT_PERSISTENCE_UNIT_NAME;
                        this.defaultPersistenceUnitInEffect = true;
                    }
                    apc.add((Annotation)NamedLiteral.of((String)unitName));
                }
                mc.remove(a -> a == pu);
                if (!observerMethod) {
                    mc.add((Annotation)InjectLiteral.INSTANCE);
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "rewritePersistenceUnitSetterMethodAnnotations");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeAddPersistenceProviderBeans(AfterBeanDiscovery event, BeanManager beanManager, Set<Bean<?>> preexistingPersistenceUnitInfoBeans, Collection<? extends PersistenceProvider> providers) throws ReflectiveOperationException {
        String cn = JpaExtension.class.getName();
        String mn = "maybeAddPersistenceProviderBeans";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "maybeAddPersistenceProviderBeans", new Object[]{event, beanManager, preexistingPersistenceUnitInfoBeans, providers});
        }
        Objects.requireNonNull(event);
        Objects.requireNonNull(beanManager);
        Objects.requireNonNull(preexistingPersistenceUnitInfoBeans);
        for (Bean<?> bean : preexistingPersistenceUnitInfoBeans) {
            if (bean == null) continue;
            assert (bean.getTypes().contains(PersistenceUnitInfo.class));
            Bean<?> preexistingPersistenceUnitInfoBean = bean;
            CreationalContext cc = beanManager.createCreationalContext(preexistingPersistenceUnitInfoBean);
            PersistenceUnitInfo pui = (PersistenceUnitInfo)preexistingPersistenceUnitInfoBean.create(cc);
            try {
                this.maybeAddPersistenceProviderBean(event, pui, providers);
            }
            finally {
                preexistingPersistenceUnitInfoBean.destroy((Object)pui, cc);
                cc.release();
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "maybeAddPersistenceProviderBeans");
        }
    }

    private static Collection<? extends PersistenceProvider> addPersistenceProviderBeans(AfterBeanDiscovery event) {
        String cn = JpaExtension.class.getName();
        String mn = "addPersistenceProviderBeans";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "addPersistenceProviderBeans", event);
        }
        Objects.requireNonNull(event);
        PersistenceProviderResolver resolver = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
        event.addBean().types(new Type[]{PersistenceProviderResolver.class}).scope(ApplicationScoped.class).createWith(cc -> resolver);
        List providers = resolver.getPersistenceProviders();
        for (PersistenceProvider provider : providers) {
            event.addBean().addTransitiveTypeClosure((Type)provider.getClass()).scope(ApplicationScoped.class).createWith(cc -> provider);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "addPersistenceProviderBeans", providers);
        }
        return providers;
    }

    private void maybeAddPersistenceProviderBean(AfterBeanDiscovery event, PersistenceUnitInfo persistenceUnitInfo, Collection<? extends PersistenceProvider> providers) throws ReflectiveOperationException {
        String cn = JpaExtension.class.getName();
        String mn = "maybeAddPersistenceProviderBean";
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(cn, "maybeAddPersistenceProviderBean", new Object[]{event, persistenceUnitInfo, providers});
        }
        Objects.requireNonNull(event);
        Objects.requireNonNull(persistenceUnitInfo);
        String providerClassName = persistenceUnitInfo.getPersistenceProviderClassName();
        if (providerClassName != null) {
            boolean add = true;
            if (providers != null && !providers.isEmpty()) {
                for (PersistenceProvider persistenceProvider : providers) {
                    if (persistenceProvider == null || !persistenceProvider.getClass().getName().equals(providerClassName)) continue;
                    add = false;
                    break;
                }
            }
            if (add) {
                String persistenceUnitName = persistenceUnitInfo.getPersistenceUnitName();
                if (persistenceUnitName == null || persistenceUnitName.isEmpty()) {
                    persistenceUnitName = DEFAULT_PERSISTENCE_UNIT_NAME;
                    this.defaultPersistenceUnitInEffect = true;
                }
                event.addBean().types(new Type[]{PersistenceProvider.class}).scope(ApplicationScoped.class).addQualifiers(new Annotation[]{NamedLiteral.of((String)persistenceUnitName)}).createWith(cc -> {
                    try {
                        ClassLoader classLoader = persistenceUnitInfo.getClassLoader();
                        if (classLoader == null) {
                            classLoader = Thread.currentThread().getContextClassLoader();
                        }
                        assert (classLoader != null);
                        Class<?> c = Class.forName(providerClassName, true, classLoader);
                        return c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        throw new CreationException(reflectiveOperationException.getMessage(), (Throwable)reflectiveOperationException);
                    }
                });
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(cn, "maybeAddPersistenceProviderBean");
        }
    }

    private static void onStartup(@Observes @Initialized(value=ApplicationScoped.class) @Priority(value=1000) Object event, @ContainerManaged Instance<EntityManagerFactory> emfs) {
        if (!emfs.isUnsatisfied()) {
            for (EntityManagerFactory emfProxy : emfs) {
                emfProxy.isOpen();
            }
        }
    }
}

