/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.cdi.jpa;

import io.helidon.integrations.cdi.jpa.CdiTransactionScoped;
import io.helidon.integrations.cdi.jpa.CdiTransactionScopedEntityManager;
import io.helidon.integrations.cdi.jpa.ContainerManaged;
import io.helidon.integrations.cdi.jpa.DelegatingEntityManager;
import io.helidon.integrations.cdi.jpa.Extended;
import io.helidon.integrations.cdi.jpa.JpaTransactionScoped;
import io.helidon.integrations.cdi.jpa.Messages;
import io.helidon.integrations.cdi.jpa.NonTransactional;
import io.helidon.integrations.cdi.jpa.NonTransactionalEntityManager;
import io.helidon.integrations.cdi.jpa.Synchronized;
import io.helidon.integrations.cdi.jpa.TransactionSupport;
import io.helidon.integrations.cdi.jpa.Unsynchronized;
import io.helidon.integrations.cdi.referencecountedcontext.ReferenceCountedContext;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Vetoed;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.metamodel.Metamodel;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Vetoed
final class JpaTransactionScopedEntityManager
extends DelegatingEntityManager {
    private final BeanManager beanManager;
    private final Instance<Object> instance;
    private final TransactionSupport transactionSupport;
    private final Bean<NonTransactionalEntityManager> nonTransactionalEntityManagerBean;
    private final NonTransactionalEntityManager nonTransactionalEntityManager;
    private final int startingReferenceCount;
    private final Bean<?> oppositeSynchronizationBean;
    private final CdiTransactionScopedEntityManager cdiTransactionScopedEntityManager;

    JpaTransactionScopedEntityManager(Instance<Object> instance, Set<? extends Annotation> suppliedQualifiers) {
        Bean nonTransactionalEntityManagerBean;
        Annotation[] cdiTransactionScopedEntityManagerSelectionQualifiersArray;
        Objects.requireNonNull(instance);
        Objects.requireNonNull(suppliedQualifiers);
        this.transactionSupport = (TransactionSupport)instance.select(TransactionSupport.class, new Annotation[0]).get();
        if (!this.transactionSupport.isEnabled()) {
            throw new IllegalArgumentException("!instance.select(TransactionSupport.class).get().isEnabled()");
        }
        this.beanManager = (BeanManager)instance.select(BeanManager.class, new Annotation[0]).get();
        this.instance = instance;
        HashSet<? extends Annotation> selectionQualifiers = new HashSet<Annotation>(suppliedQualifiers);
        selectionQualifiers.remove(Any.Literal.INSTANCE);
        selectionQualifiers.remove(Default.Literal.INSTANCE);
        selectionQualifiers.remove(Extended.Literal.INSTANCE);
        selectionQualifiers.remove(JpaTransactionScoped.Literal.INSTANCE);
        selectionQualifiers.remove(NonTransactional.Literal.INSTANCE);
        selectionQualifiers.add(CdiTransactionScoped.Literal.INSTANCE);
        selectionQualifiers.add(ContainerManaged.Literal.INSTANCE);
        if (suppliedQualifiers.contains(Unsynchronized.Literal.INSTANCE)) {
            selectionQualifiers.remove(Synchronized.Literal.INSTANCE);
            selectionQualifiers.add(Unsynchronized.Literal.INSTANCE);
            cdiTransactionScopedEntityManagerSelectionQualifiersArray = selectionQualifiers.toArray(new Annotation[selectionQualifiers.size()]);
            selectionQualifiers.remove(Unsynchronized.Literal.INSTANCE);
            selectionQualifiers.add(Synchronized.Literal.INSTANCE);
        } else {
            selectionQualifiers.remove(Unsynchronized.Literal.INSTANCE);
            selectionQualifiers.add(Synchronized.Literal.INSTANCE);
            cdiTransactionScopedEntityManagerSelectionQualifiersArray = selectionQualifiers.toArray(new Annotation[selectionQualifiers.size()]);
            selectionQualifiers.remove(Synchronized.Literal.INSTANCE);
            selectionQualifiers.add(Unsynchronized.Literal.INSTANCE);
        }
        Set beans = this.beanManager.getBeans(EntityManager.class, selectionQualifiers.toArray(new Annotation[selectionQualifiers.size()]));
        assert (beans != null);
        this.oppositeSynchronizationBean = Objects.requireNonNull(this.beanManager.resolve(beans));
        this.cdiTransactionScopedEntityManager = (CdiTransactionScopedEntityManager)instance.select(CdiTransactionScopedEntityManager.class, cdiTransactionScopedEntityManagerSelectionQualifiersArray).get();
        assert (this.cdiTransactionScopedEntityManager.getClass().isSynthetic());
        selectionQualifiers.remove(CdiTransactionScoped.Literal.INSTANCE);
        selectionQualifiers.remove(ContainerManaged.Literal.INSTANCE);
        selectionQualifiers.remove(Synchronized.Literal.INSTANCE);
        selectionQualifiers.remove(Unsynchronized.Literal.INSTANCE);
        selectionQualifiers.add(NonTransactional.Literal.INSTANCE);
        beans = this.beanManager.getBeans(NonTransactionalEntityManager.class, selectionQualifiers.toArray(new Annotation[selectionQualifiers.size()]));
        assert (beans != null);
        this.nonTransactionalEntityManagerBean = nonTransactionalEntityManagerBean = this.beanManager.resolve(beans);
        assert (this.nonTransactionalEntityManagerBean != null);
        beans = null;
        ReferenceCountedContext context = ReferenceCountedContext.getInstanceFrom((BeanManager)this.beanManager);
        assert (context != null);
        assert (context.isActive());
        this.startingReferenceCount = context.getReferenceCount(this.nonTransactionalEntityManagerBean);
        this.nonTransactionalEntityManager = (NonTransactionalEntityManager)this.beanManager.getReference(this.nonTransactionalEntityManagerBean, NonTransactionalEntityManager.class, this.beanManager.createCreationalContext(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected EntityManager acquireDelegate() {
        DelegatingEntityManager returnValue;
        int status = this.transactionSupport.getStatus();
        switch (status) {
            case 0: {
                Context transactionScopedContext = this.transactionSupport.getContext();
                if (transactionScopedContext == null || !transactionScopedContext.isActive()) {
                    returnValue = this.nonTransactionalEntityManager;
                    break;
                }
                DelegatingEntityManager candidateReturnValue = this.cdiTransactionScopedEntityManager;
                try {
                    Object existingContextualInstance = transactionScopedContext.get(this.oppositeSynchronizationBean);
                    if (existingContextualInstance != null) {
                        throw new PersistenceException(Messages.format("mixedSynchronizationTypes", this.oppositeSynchronizationBean, existingContextualInstance));
                    }
                    break;
                }
                catch (ContextNotActiveException contextNotActiveException) {
                    candidateReturnValue = this.nonTransactionalEntityManager;
                    break;
                }
                finally {
                    returnValue = candidateReturnValue;
                }
            }
            default: {
                returnValue = this.nonTransactionalEntityManager;
            }
        }
        assert (returnValue != null);
        return returnValue;
    }

    @Override
    public EntityTransaction getTransaction() {
        throw new IllegalStateException(Messages.format("jpaTransactionScopedEntityManagerGetTransaction", new Object[0]));
    }

    @Override
    public void close() {
        throw new IllegalStateException(Messages.format("jpaTransactionScopedEntityManagerClose", new Object[0]));
    }

    void dispose(Instance<Object> instance) {
        ReferenceCountedContext context = ReferenceCountedContext.getInstanceFrom((BeanManager)this.beanManager);
        assert (context != null);
        assert (context.isActive());
        int finalReferenceCount = context.getReferenceCount(this.nonTransactionalEntityManagerBean);
        context.decrementReferenceCount(this.nonTransactionalEntityManagerBean, finalReferenceCount - this.startingReferenceCount);
    }

    @Override
    public void persist(Object entity) {
        try {
            super.persist(entity);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            this.nonTransactionalEntityManager.persist(entity);
        }
    }

    @Override
    public <T> T merge(T entity) {
        try {
            return super.merge(entity);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.merge(entity);
        }
    }

    @Override
    public void remove(Object entity) {
        try {
            super.remove(entity);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            this.nonTransactionalEntityManager.remove(entity);
        }
    }

    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        try {
            return super.find(entityClass, primaryKey);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.find(entityClass, primaryKey);
        }
    }

    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        try {
            return super.find(entityClass, primaryKey, properties);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.find(entityClass, primaryKey, properties);
        }
    }

    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        try {
            return super.find(entityClass, primaryKey, lockMode);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.find(entityClass, primaryKey, lockMode);
        }
    }

    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        try {
            return super.find(entityClass, primaryKey, lockMode, properties);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.find(entityClass, primaryKey, lockMode, properties);
        }
    }

    @Override
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        try {
            return super.getReference(entityClass, primaryKey);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.getReference(entityClass, primaryKey);
        }
    }

    @Override
    public void flush() {
        try {
            super.flush();
        }
        catch (ContextNotActiveException contextNotActiveException) {
            this.nonTransactionalEntityManager.flush();
        }
    }

    @Override
    public void setFlushMode(FlushModeType flushMode) {
        try {
            super.setFlushMode(flushMode);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            this.nonTransactionalEntityManager.setFlushMode(flushMode);
        }
    }

    @Override
    public FlushModeType getFlushMode() {
        try {
            return super.getFlushMode();
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.getFlushMode();
        }
    }

    @Override
    public void lock(Object entity, LockModeType lockMode) {
        try {
            super.lock(entity, lockMode);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            this.nonTransactionalEntityManager.lock(entity, lockMode);
        }
    }

    @Override
    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        try {
            super.lock(entity, lockMode, properties);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            this.nonTransactionalEntityManager.lock(entity, lockMode, properties);
        }
    }

    @Override
    public void refresh(Object entity) {
        try {
            super.refresh(entity);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            this.nonTransactionalEntityManager.refresh(entity);
        }
    }

    @Override
    public void refresh(Object entity, Map<String, Object> properties) {
        try {
            super.refresh(entity, properties);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            this.nonTransactionalEntityManager.refresh(entity, properties);
        }
    }

    @Override
    public void refresh(Object entity, LockModeType lockMode) {
        try {
            super.refresh(entity, lockMode);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            this.nonTransactionalEntityManager.refresh(entity, lockMode);
        }
    }

    @Override
    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        try {
            super.refresh(entity, lockMode, properties);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            this.nonTransactionalEntityManager.refresh(entity, lockMode, properties);
        }
    }

    @Override
    public void clear() {
        try {
            super.clear();
        }
        catch (ContextNotActiveException contextNotActiveException) {
            this.nonTransactionalEntityManager.clear();
        }
    }

    @Override
    public void detach(Object entity) {
        try {
            super.detach(entity);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            this.nonTransactionalEntityManager.detach(entity);
        }
    }

    @Override
    public boolean contains(Object entity) {
        try {
            return super.contains(entity);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.contains(entity);
        }
    }

    @Override
    public LockModeType getLockMode(Object entity) {
        try {
            return super.getLockMode(entity);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.getLockMode(entity);
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        try {
            return super.getProperties();
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.getProperties();
        }
    }

    @Override
    public void setProperty(String propertyName, Object propertyValue) {
        try {
            super.setProperty(propertyName, propertyValue);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            this.nonTransactionalEntityManager.setProperty(propertyName, propertyValue);
        }
    }

    @Override
    public Query createQuery(String jpql) {
        try {
            return super.createQuery(jpql);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.createQuery(jpql);
        }
    }

    @Override
    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        try {
            return super.createQuery(criteriaQuery);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.createQuery(criteriaQuery);
        }
    }

    @Override
    public Query createQuery(CriteriaUpdate criteriaUpdate) {
        try {
            return super.createQuery(criteriaUpdate);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.createQuery(criteriaUpdate);
        }
    }

    @Override
    public Query createQuery(CriteriaDelete criteriaDelete) {
        try {
            return super.createQuery(criteriaDelete);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.createQuery(criteriaDelete);
        }
    }

    @Override
    public <T> TypedQuery<T> createQuery(String jpql, Class<T> resultClass) {
        try {
            return super.createQuery(jpql, resultClass);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.createQuery(jpql, resultClass);
        }
    }

    @Override
    public Query createNamedQuery(String sql) {
        try {
            return super.createNamedQuery(sql);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.createNamedQuery(sql);
        }
    }

    @Override
    public <T> TypedQuery<T> createNamedQuery(String sql, Class<T> resultClass) {
        try {
            return super.createNamedQuery(sql, resultClass);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.createNamedQuery(sql, resultClass);
        }
    }

    @Override
    public Query createNativeQuery(String sql) {
        try {
            return super.createNativeQuery(sql);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.createNativeQuery(sql);
        }
    }

    @Override
    public Query createNativeQuery(String sql, Class resultClass) {
        try {
            return super.createNativeQuery(sql, resultClass);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.createNativeQuery(sql, resultClass);
        }
    }

    @Override
    public Query createNativeQuery(String sql, String resultSetMapping) {
        try {
            return super.createNativeQuery(sql, resultSetMapping);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.createNativeQuery(sql, resultSetMapping);
        }
    }

    @Override
    public StoredProcedureQuery createNamedStoredProcedureQuery(String procedureName) {
        try {
            return super.createNamedStoredProcedureQuery(procedureName);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.createNamedStoredProcedureQuery(procedureName);
        }
    }

    @Override
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        try {
            return super.createStoredProcedureQuery(procedureName);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.createStoredProcedureQuery(procedureName);
        }
    }

    @Override
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        try {
            return super.createStoredProcedureQuery(procedureName, resultClasses);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.createStoredProcedureQuery(procedureName, resultClasses);
        }
    }

    @Override
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        try {
            return super.createStoredProcedureQuery(procedureName, resultSetMappings);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.createStoredProcedureQuery(procedureName, resultSetMappings);
        }
    }

    @Override
    public void joinTransaction() {
        try {
            super.joinTransaction();
        }
        catch (ContextNotActiveException contextNotActiveException) {
            this.nonTransactionalEntityManager.joinTransaction();
        }
    }

    @Override
    public boolean isJoinedToTransaction() {
        try {
            return super.isJoinedToTransaction();
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.isJoinedToTransaction();
        }
    }

    @Override
    public <T> T unwrap(Class<T> c) {
        try {
            return super.unwrap(c);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.unwrap(c);
        }
    }

    @Override
    public Object getDelegate() {
        try {
            return super.getDelegate();
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.getDelegate();
        }
    }

    @Override
    public boolean isOpen() {
        try {
            return super.isOpen();
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.isOpen();
        }
    }

    @Override
    public EntityManagerFactory getEntityManagerFactory() {
        try {
            return super.getEntityManagerFactory();
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.getEntityManagerFactory();
        }
    }

    @Override
    public CriteriaBuilder getCriteriaBuilder() {
        try {
            return super.getCriteriaBuilder();
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.getCriteriaBuilder();
        }
    }

    @Override
    public Metamodel getMetamodel() {
        try {
            return super.getMetamodel();
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.getMetamodel();
        }
    }

    @Override
    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        try {
            return super.createEntityGraph(rootType);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.createEntityGraph(rootType);
        }
    }

    @Override
    public EntityGraph<?> createEntityGraph(String graphName) {
        try {
            return super.createEntityGraph(graphName);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.createEntityGraph(graphName);
        }
    }

    @Override
    public EntityGraph<?> getEntityGraph(String graphName) {
        try {
            return super.getEntityGraph(graphName);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.getEntityGraph(graphName);
        }
    }

    @Override
    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        try {
            return super.getEntityGraphs(entityClass);
        }
        catch (ContextNotActiveException contextNotActiveException) {
            return this.nonTransactionalEntityManager.getEntityGraphs(entityClass);
        }
    }
}

